/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.openas2.util.HTTPUtil;
import org.openas2.util.ResponseWrapper;

public class CheckCertificate {
    public static final String HOST = "s";
    public static final String PORT = "p";
    public static final String URI = "u";
    public static final String CACERT = "c";
    public static final String PASSWORD = "P";
    public static final String DEBUG = "d";
    public static final String AUTH_USER = "a";
    public static final String AUTH_PWD = "A";
    public static final String HELP_OPT = "h";
    private String auth_user = null;
    private String auth_pwd = null;
    public String[][] opts = new String[][]{{"s", "server", "true", "true", "the target host name"}, {"u", "uri", "true", "false", "URI part of the connection"}, {"p", "port", "true", "false", "target server port"}, {"c", "cacert", "true", "false", "Java keystore file to create if cert chain not present in Java keystore"}, {"P", "password", "true", "false", "password for Keystore if not 'changeit'"}, {"d", "debug", "true", "false", "Enabling debug logging"}, {"a", "authuser", "true", "false", "Basic auth user"}, {"A", "authpwd", "true", "false", "Basic auth password"}, {"h", "help", "false", "false", "print this help"}};

    private void usage(Options options) {
        String header = "Checks SSL connectivity.\nTries to connect to the remote server and establish a connection.";
        String footer = "Good luck!";
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getClass().getName(), header, options, footer, true);
    }

    private CommandLine parseCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        for (String[] opt : this.opts) {
            Option option = Option.builder((String)opt[0]).longOpt(opt[1]).hasArg("true".equalsIgnoreCase(opt[2])).desc(opt[4]).build();
            option.setRequired("true".equalsIgnoreCase(opt[3]));
            options.addOption(option);
        }
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Unexpected exception:" + e.getMessage());
            this.usage(options);
        }
        return line;
    }

    public int CheckCertStore(String host, int port, String uri, String targetKeyStore, String keyStorePwd) throws Exception {
        if (keyStorePwd == null || keyStorePwd.length() < 1) {
            keyStorePwd = "changeit";
        }
        char[] passphrase = keyStorePwd.toCharArray();
        File file = new File(targetKeyStore);
        if (!file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            if (!dir.isDirectory()) {
                dir = new File(System.getProperty("java.home") + SEP + "jre" + SEP + "lib" + SEP + "security");
            }
            if (!dir.isDirectory()) {
                throw new Exception("The JSSE folder could not be identified. Please check that JSSE is installed.");
            }
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passphrase);
        ((InputStream)in).close();
        SSLSocket socket = null;
        try {
            socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(host, port);
        }
        catch (Exception e) {
            throw new Exception("\nSOCKET FAIL ::: Reason: " + e + "\n");
        }
        SSLParameters sslParms = socket.getSSLParameters();
        String[] protocols = sslParms.getProtocols();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultX509TM = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultX509TM = (X509TrustManager)tm;
            break;
        }
        SavingTrustManager tm = new SavingTrustManager(defaultX509TM);
        String lastExceptionMsg = "";
        for (int i = 0; i < protocols.length; ++i) {
            SSLContext context;
            try {
                context = SSLContext.getInstance(protocols[i]);
            }
            catch (NoSuchAlgorithmException e1) {
                lastExceptionMsg = e1.getMessage();
                continue;
            }
            System.out.println("Adding KeyManager for possible HTTP AUTH...");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            context.init(kmf.getKeyManagers(), new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            try {
                socket = (SSLSocket)factory.createSocket(host, port);
            }
            catch (IOException io) {
                lastExceptionMsg = io.getMessage();
                continue;
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            System.out.println("Set SSLContext using protocol: " + protocols[i]);
            break;
        }
        if (socket == null) {
            throw new Exception("Failed to connect to remote system:  " + lastExceptionMsg);
        }
        try {
            socket.setSoTimeout(10000);
            System.out.println("\n\t\t**** Starting SSL handshake...");
            socket.startHandshake();
            if (!socket.isClosed()) {
                socket.close();
            }
            this.checkUsingApacheHttp(host, port, uri, targetKeyStore, keyStorePwd);
            System.out.println("No errors, certificate is already trusted");
            return 0;
        }
        catch (SSLHandshakeException e) {
            boolean startNdx;
            e.printStackTrace(System.out);
            System.out.println("\nException caught starting SSL handshake so trying to set up a local certificate store with trust chain....\n\n");
            this.checkUsingApacheHttp(host, port, uri, targetKeyStore, keyStorePwd);
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                throw new Exception("Could not obtain server certificate chain");
            }
            System.out.println("Number of certificates in chain: " + chain.length);
            boolean bl = startNdx = chain.length != 1;
            if (!startNdx) {
                CheckCertificate.findClosestMatchTrustedCert(ks, chain[0]);
                System.out.println("\n\nThe root certificate is not trusted so storing it locally... ");
            }
            for (int k = 0; k < chain.length; ++k) {
                X509Certificate cert = chain[k];
                String alias = host + "-" + (k + 1);
                ks.setCertificateEntry(alias, cert);
                FileOutputStream out = new FileOutputStream(targetKeyStore);
                ks.store(out, passphrase);
                ((OutputStream)out).close();
                System.out.println("Installed certificate as trusted: " + cert.getIssuerDN() + "::" + cert.getSigAlgName());
            }
            return 0;
        }
    }

    private void checkUsingApacheHttp(String host, int port, String uri, String targetKeyStore, String keyStorePwd) throws Exception {
        System.out.println("Trying using Apache HTTP Client...");
        HashMap<String, String> httpOptions = new HashMap<String, String>();
        if (this.auth_user != null) {
            httpOptions.put("http_user", this.auth_user);
            httpOptions.put("http_password", this.auth_pwd);
        }
        ResponseWrapper resp = HTTPUtil.execRequest("POST", "https://" + host + ":" + port + "/" + uri, null, null, new ByteArrayInputStream("Testing".getBytes()), httpOptions, 1000000000L);
        System.out.println("Got a response using Apache HTTP Client: " + resp.getStatusCode());
        System.out.println("\t\tHEADERS: " + resp.getHeaders());
        System.out.println("\t\tBODY: " + resp.getBody());
    }

    private static void findClosestMatchTrustedCert(KeyStore ks, X509Certificate rootCert) {
        PKIXParameters params;
        try {
            params = new PKIXParameters(ks);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String rootCertDN = rootCert.getIssuerDN().getName();
        String org = CheckCertificate.getDNField("O", rootCertDN).toLowerCase();
        String org1StWord = org.replaceAll("(\\S*)[^$]*", "$1").toLowerCase();
        System.out.println("Looking for matches to root certificate DN:\n\t" + rootCertDN + "\n\t\tReference certificate signing algorthim: " + rootCert.getSigAlgName() + "\n\n\tTrusted certificate(s) most closely matching \"O\" field of root certificate DN:");
        Iterator<TrustAnchor> it = params.getTrustAnchors().iterator();
        boolean found = false;
        while (it.hasNext()) {
            TrustAnchor ta = it.next();
            X509Certificate cert = ta.getTrustedCert();
            String dn = cert.getIssuerDN().getName();
            String lcDN = dn.toLowerCase();
            if (!lcDN.contains(org) && !lcDN.contains(org1StWord)) continue;
            found = true;
            System.out.println("\t\tTrusted certificate DN:\n\t\t" + dn + "\n\t\tTrusted certificate signing algorthim: " + cert.getSigAlgName());
        }
        if (!found) {
            System.out.println("\n\t\t\tNo matching certificates found");
        }
    }

    private static String getDNField(String dnFld, String dn) {
        return dn.contains(" " + dnFld + "=\"") ? dn.replaceAll(".* " + dnFld + "=\"([^\"]*)\",[^$]*", "$1") : dn.replaceAll(".* " + dnFld + "=([^,]*),[^$]*", "$1");
    }

    private void process(String[] args) {
        CommandLine line = this.parseCommandLine(args);
        String host = line.getOptionValue(HOST);
        int port = line.hasOption(PORT) ? Integer.parseInt(line.getOptionValue(PORT)) : 443;
        String uri = line.hasOption(URI) ? line.getOptionValue(URI) : "";
        String keyStoreFile = line.hasOption(CACERT) ? line.getOptionValue(CACERT) : "";
        String passphrase = line.hasOption(PASSWORD) ? line.getOptionValue(PASSWORD) : "changeit";
        this.auth_user = line.hasOption(AUTH_USER) ? line.getOptionValue(AUTH_USER) : null;
        String string = this.auth_pwd = line.hasOption(AUTH_PWD) ? line.getOptionValue(AUTH_PWD) : null;
        if (line.hasOption(DEBUG) && "true".equalsIgnoreCase(line.getOptionValue(DEBUG))) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "DEBUG");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "ERROR");
        }
        try {
            this.CheckCertStore(host, port, uri, keyStoreFile, passphrase);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            CheckCertificate mgr = new CheckCertificate();
            mgr.process(args);
        }
        catch (Exception e) {
            System.out.println("Unexpected exception:" + e.getMessage());
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.tm.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

