/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.openas2.logging.Level;
import org.openas2.logging.LogManager;

public class Log
implements org.apache.commons.logging.Log {
    LogManager lm = LogManager.getLogManager();
    String clazzname;
    protected static final String systemPrefix = "org.openas2.logging.";
    protected static final Properties openas2LogProps = new Properties();
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected volatile int configuredLogLevel;
    protected volatile int currentLogLevel;

    public Log(String inName) {
        this.lm.addRequestors(inName);
        this.clazzname = inName;
        this.setLevel(3);
        String lvl = Log.getStringProperty("org.openas2.logging.log." + this.clazzname);
        int i = String.valueOf(inName).lastIndexOf(".");
        while (null == lvl && i > -1) {
            inName = inName.substring(0, i);
            lvl = Log.getStringProperty("org.openas2.logging.log." + inName);
            i = String.valueOf(inName).lastIndexOf(".");
        }
        if (null == lvl) {
            lvl = Log.getStringProperty("org.openas2.logging.defaultlog");
        }
        if (null == lvl) {
            lvl = (String)LogFactory.getFactory().getAttribute("level");
        }
        if (null != lvl) {
            this.setLevel(Log.getIntLogLevel(lvl));
        }
        this.configuredLogLevel = this.getLevel();
    }

    private static int getIntLogLevel(String lvl) {
        if ("all".equalsIgnoreCase(lvl)) {
            return 0;
        }
        if ("trace".equalsIgnoreCase(lvl)) {
            return 1;
        }
        if ("debug".equalsIgnoreCase(lvl)) {
            return 2;
        }
        if ("info".equalsIgnoreCase(lvl)) {
            return 3;
        }
        if ("warn".equalsIgnoreCase(lvl)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(lvl)) {
            return 5;
        }
        if ("fatal".equalsIgnoreCase(lvl)) {
            return 6;
        }
        if ("off".equalsIgnoreCase(lvl)) {
            return 7;
        }
        return -1;
    }

    private static String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? openas2LogProps.getProperty(name) : prop;
    }

    public void resetLevel() {
        this.currentLogLevel = this.configuredLogLevel;
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    protected boolean isLevelEnabled(int logLevel) {
        int overrideLevel;
        String overrideSetting = System.getProperty("logging.level.override." + this.clazzname, "");
        if ("".equals(overrideSetting)) {
            overrideSetting = System.getProperty("logging.level.override", "");
        }
        if (!"".equals(overrideSetting) && (overrideLevel = Log.getIntLogLevel(overrideSetting)) >= 0) {
            return logLevel >= overrideLevel;
        }
        return logLevel >= this.currentLogLevel;
    }

    public void trace(Object message) {
        this.trace(message, null);
    }

    public void trace(Object message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            this.lm.log(Level.FINEST, this.clazzname, message, t);
        }
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            this.lm.log(Level.FINER, this.clazzname, message, t);
        }
    }

    public void info(Object message) {
        this.info(message, null);
    }

    public void info(Object message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            this.lm.log(Level.FINE, this.clazzname, message, t);
        }
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            this.lm.log(Level.WARNING, this.clazzname, message, t);
        }
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            this.lm.log(Level.ERROR, this.clazzname, message, t);
        }
    }

    public void fatal(Object message) {
        this.fatal(message, null);
    }

    public void fatal(Object message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            this.lm.log(Level.ERROR, this.clazzname, message, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    private static InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public static String getExceptionMsg(Throwable e) {
        String msg = null;
        if (e.getCause() != null) {
            msg = e.getCause().getMessage();
        }
        if (!(msg != null && msg.length() != 0 || (msg = e.getMessage()) != null && msg.length() != 0)) {
            msg = e.toString();
        }
        return msg;
    }

    static {
        String logPropsFiile = System.getProperty("openas2log.properties", "openas2log.properties");
        InputStream in = Log.getResourceAsStream(logPropsFiile);
        if (null != in) {
            try {
                openas2LogProps.load(in);
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

