/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd;

import java.util.Map;
import org.openas2.BaseComponent;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandResult;
import org.openas2.params.InvalidParameterException;

public abstract class BaseCommand
extends BaseComponent
implements Command {
    public static final String PARAM_NAME = "name";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_USAGE = "usage";

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        if (this.getName() == null) {
            this.setName(this.getDefaultName());
        }
        if (this.getDescription() == null) {
            this.setDescription(this.getDefaultDescription());
        }
        if (this.getUsage() == null) {
            this.setUsage(this.getDefaultUsage());
        }
    }

    @Override
    public String getDescription() {
        try {
            return this.getParameter(PARAM_DESCRIPTION, false);
        }
        catch (InvalidParameterException e) {
            return null;
        }
    }

    @Override
    public void setDescription(String desc) {
        this.setParameter(PARAM_DESCRIPTION, desc);
    }

    @Override
    public String getName() {
        try {
            return this.getParameter(PARAM_NAME, false);
        }
        catch (InvalidParameterException e) {
            return null;
        }
    }

    @Override
    public void setName(String name) {
        this.setParameter(PARAM_NAME, name);
    }

    @Override
    public String getUsage() {
        try {
            return this.getParameter(PARAM_USAGE, false);
        }
        catch (InvalidParameterException e) {
            return null;
        }
    }

    @Override
    public void setUsage(String usage) {
        this.setParameter(PARAM_USAGE, usage);
    }

    public abstract String getDefaultName();

    public abstract String getDefaultDescription();

    public abstract String getDefaultUsage();

    @Override
    public abstract CommandResult execute(Object[] var1);
}

