/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.remote;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openas2.remote.SocketLogging;

public class OpenAS2Servlet
extends HttpServlet {
    private static final long serialVersionUID = -625641001873163537L;
    SocketLogging sl = null;
    LogGetter lg = null;
    ByteArrayOutputStream baos = null;
    int logPort;
    String commandHostID = "";
    int commandPort;
    String commandUserID = "";
    String commandPWD = "";
    PrintWriter writer;

    public void init() throws ServletException {
        super.init();
        String port = this.getServletConfig().getInitParameter("loggingPort");
        if (port == null) {
            throw new ServletException("loggingPort not defined in servlet config file");
        }
        try {
            this.logPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new ServletException("loggingPort value not an int", (Throwable)e);
        }
        this.commandHostID = this.getServletConfig().getInitParameter("commandHostID");
        if (this.commandHostID == null) {
            throw new ServletException("commandHostID not defined in servlet config file");
        }
        port = this.getServletConfig().getInitParameter("commandPort");
        if (port == null) {
            throw new ServletException("commandPort not defined in servlet config file");
        }
        try {
            this.commandPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new ServletException("commandPort value not an int", (Throwable)e);
        }
        this.commandUserID = this.getServletConfig().getInitParameter("commandUserID");
        if (this.commandUserID == null) {
            throw new ServletException("commandUserID not defined in servlet config file");
        }
        this.commandPWD = this.getServletConfig().getInitParameter("commandPWD");
        if (this.commandPWD == null) {
            throw new ServletException("commandPWD not defined in servlet config file");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        this.writer = response.getWriter();
        this.writer.println("<h1>Not Ready</h1>");
        this.writer.flush();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        try {
            this.writer = response.getWriter();
            String userid = request.getParameter("userid");
            if (userid == null || userid.equals("")) {
                response.sendError(401);
                return;
            }
            String pwd = request.getParameter("pwd");
            if (pwd == null || pwd.equals("")) {
                response.sendError(401);
                return;
            }
            String action = request.getParameter("action");
            if (action.startsWith("log")) {
                this.doLog(request, response);
            } else if (action.startsWith("cert ")) {
                this.doCertificate(request, response);
            } else if (action.startsWith("partner ")) {
                this.doPartner(request, response);
            } else if (action.startsWith("partnership ")) {
                this.doPartnership(request, response);
            } else if (action.equals("useridpwd")) {
                this.doUserIDPWD(userid, pwd, response);
            } else {
                this.writer.println("<h1>Not Ready</h1>");
            }
            this.writer.flush();
        }
        catch (IOException ioe) {
            throw new ServletException("IOException " + ioe.getMessage());
        }
    }

    private void doUserIDPWD(String inuser, String inpwd, HttpServletResponse response) {
        if (this.commandUserID.equals(inuser) && this.commandPWD.equals(inpwd)) {
            this.writer.print("<useridpwd resp=\"okay\"/>");
        } else {
            this.writer.print("<useridpwd resp=\"nope\"/>");
        }
    }

    private void doPartnership(HttpServletRequest request, HttpServletResponse response) throws UnknownHostException, IOException {
        String action = request.getParameter("action");
        String reply = "not defined";
        if (action.equals("partnership list")) {
            reply = this.remoteCommandCall(action);
        }
        if (action.startsWith("partnership view")) {
            reply = this.remoteCommandCall(action);
        }
        this.writer.print("<partnership>" + OpenAS2Servlet.normalize(reply) + "</partnership>");
    }

    private void doPartner(HttpServletRequest request, HttpServletResponse response) throws UnknownHostException, IOException {
        String action = request.getParameter("action");
        String reply = "not defined";
        if (action.equals("partner list")) {
            reply = this.remoteCommandCall(action);
        }
        if (action.startsWith("partner view")) {
            reply = this.remoteCommandCall(action);
        }
        this.writer.print("<partner>" + OpenAS2Servlet.normalize(reply) + "</partner>");
    }

    private void doCertificate(HttpServletRequest request, HttpServletResponse response) throws UnknownHostException, IOException {
        String action = request.getParameter("action");
        String reply = "not defined";
        if (action.equals("cert list")) {
            reply = this.remoteCommandCall(action);
        }
        if (action.startsWith("cert view")) {
            reply = this.remoteCommandCall(action);
        }
        if (action.startsWith("cert delete")) {
            reply = this.remoteCommandCall(action);
        }
        if (action.startsWith("cert import")) {
            action = reply = this.remoteCommandCall(action);
        }
        this.writer.print("<cert>" + OpenAS2Servlet.normalize(reply) + "</cert>");
    }

    private void doLog(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String logResponse = "";
        String action = request.getParameter("action");
        if (action.endsWith("0")) {
            this.baos.reset();
            logResponse = "<p/>log stopped<p/>";
            this.lg.threadSuspended = true;
            this.lg.interrupt();
            try {
                this.lg.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lg = null;
            this.sl = null;
            this.baos = null;
        } else {
            if (this.sl == null) {
                this.sl = new SocketLogging(this.logPort);
                this.baos = new ByteArrayOutputStream();
                this.lg = new LogGetter(this.sl, new PrintStream(this.baos));
                this.lg.start();
            }
            if (this.baos.size() > 0) {
                logResponse = this.baos.toString();
                this.baos.reset();
            }
        }
        this.writer.print("<log resp=\"" + OpenAS2Servlet.xmlNormalize(logResponse) + "\"/>");
    }

    public static String normalize(String in) {
        int len = in.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            if (in.charAt(i) == '\'') {
                sb.append('\\');
            }
            if (in.charAt(i) == '\"') {
                sb.append('\\');
            }
            if (in.charAt(i) == '\n') {
                sb.append("%");
                continue;
            }
            if (in.charAt(i) == '\r') {
                sb.append("$");
                continue;
            }
            sb.append(in.charAt(i));
        }
        return new String(sb);
    }

    public static String xmlNormalize(String in) {
        int len = in.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            if (in.charAt(i) == '<') {
                sb.append("&lt;");
                continue;
            }
            if (in.charAt(i) == '>') {
                sb.append("&gt;");
                continue;
            }
            if (in.charAt(i) == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(in.charAt(i));
        }
        return new String(sb);
    }

    public String remoteCommandCall(String command) throws UnknownHostException, IOException {
        String r;
        InetAddress hostAddress = InetAddress.getByName(this.commandHostID);
        SSLSocket s = (SSLSocket)SSLSocketFactory.getDefault().createSocket(hostAddress, this.commandPort);
        String cmdCipher = "TLS_DH_anon_WITH_AES_256_CBC_SHA";
        String cipherSuites = System.getProperty("CmdProcessorSocketCipher", "TLS_DH_anon_WITH_AES_256_CBC_SHA");
        String[] enabledCipherSuites = new String[]{cipherSuites};
        try {
            s.setEnabledCipherSuites(enabledCipherSuites);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.out.println("Cipher is not supported. Try using the command line switch -DCmdProcessorSocketCipher=<some cipher suite> to use one supported by your version of java security.");
        }
        String cmd = "<command id=\"" + this.commandUserID + "\" password=\"" + this.commandPWD + "\">" + command + "</command>\n";
        s.getOutputStream().write(cmd.getBytes());
        s.getOutputStream().flush();
        CharArrayWriter caw = new CharArrayWriter();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(s.getInputStream()));
        while ((r = rdr.readLine()) != null) {
            caw.write(r.toCharArray());
            caw.write("\n");
        }
        s.close();
        return caw.toString();
    }

    class LogGetter
    extends Thread {
        PrintStream ps;
        SocketLogging sl;
        boolean threadSuspended = false;

        LogGetter(SocketLogging inSL, PrintStream inPS) throws IOException {
            this.sl = inSL;
            this.ps = inPS;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            if (this.threadSuspended) {
                this.sl.close();
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.threadSuspended) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    this.sl.logToPrintStream(this.ps, "<br/>");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }
}

