/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import net.sf.okapi.tm.pensieve.seeker.TmSeekerFactory;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxImporter;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TmxHandlerImportTest {
    private static final LocaleId locENUS = LocaleId.fromString((String)"EN-US");
    private static final LocaleId locDEDE = LocaleId.fromString((String)"DE-DE");
    private static final LocaleId locEN = LocaleId.fromString((String)"EN");
    private static final LocaleId locIT = LocaleId.fromString((String)"IT");
    private ITmSeeker seeker;
    private FileLocation root;

    @Before
    public void setUP() {
        this.root = FileLocation.fromClass(this.getClass());
        this.seeker = TmSeekerFactory.createFileBasedTmSeeker((String)this.root.in("/").toString());
    }

    @After
    public void tearDown() {
        if (this.seeker != null) {
            this.seeker.close();
        }
    }

    @Test
    @Ignore
    public void importTmx_exact_really_big_file() throws Exception {
        long startTime = System.currentTimeMillis();
        List tus = this.seeker.searchExact(new TextFragment("All Rights Reserved."), null);
        long totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        tus = this.seeker.searchExact(new TextFragment("Notice to U.S. Government End Users."), null);
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        tus = this.seeker.searchExact(new TextFragment("Portions copyright 1984-1998 FairCom Corporation."), null);
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        tus = this.seeker.searchExact(new TextFragment("Second Ed. C:"), null);
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void importTmx_fuzzy_really_big_file() throws Exception {
        int i;
        long startTime = System.currentTimeMillis();
        List tus = this.seeker.searchFuzzy(new TextFragment("All Rights Reserved."), 80, 10, null);
        long totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        tus = this.seeker.searchFuzzy(new TextFragment("Notice to U.S. Government End Users."), 80, 10, null);
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        tus = this.seeker.searchFuzzy(new TextFragment("Portions copyright 1984-1998 FairCom Corporation."), 80, 10, null);
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        tus = this.seeker.searchFuzzy(new TextFragment("Second Ed. C:"), 80, 10, null);
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        for (i = 0; i < 1; ++i) {
            tus = this.seeker.searchFuzzy(new TextFragment("Notice to U.S. Government End Users."), 80, 10, null);
        }
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        for (i = 0; i < 1; ++i) {
            tus = this.seeker.searchFuzzy(new TextFragment("Consistent with 48 C.F.R. \u00a712.212 or 48 C.F.R. \u00a7\u00a7227.7202-1 through 227.7202-4, as applicable, the Commercial Computer Software and Commercial Computer Software Documentation are being licensed to U.S. Government end users (a) only as Commercial Items and (b) with only those rights as are granted to all other end users pursuant to the terms and conditions herein."), 80, 10, null);
        }
        totalTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)"Didn't find something", (tus.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void importTmx_paragraph_tmx_basics() throws Exception {
        TmxFilter tmxFilter = new TmxFilter();
        RAMDirectory ramDir = new RAMDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxHandler = new OkapiTmxImporter(locENUS, (IFilter)tmxFilter);
        tmxHandler.importTmx(this.root.in("/Paragraph_TM.tmx").asUri(), locDEDE, (ITmWriter)tmWriter);
        tmWriter.close();
        try (PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);){
            TranslationUnit tu = ((TmHit)seeker.searchExact(new TextFragment("Pumps have been paused for 3 minutes. Consider starting a saline drip."), null).get(0)).getTu();
            Assert.assertEquals((String)"tu target content", (Object)"Pumpen wurden 3 Minuten lang angehalten, ggf. NaCl-Infusion starten", (Object)tu.getTarget().getContent().toText());
        }
    }

    @Test
    public void importTmx_sample_tmx_basics() throws Exception {
        TmxFilter tmxFilter = new TmxFilter();
        RAMDirectory ramDir = new RAMDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxHandler = new OkapiTmxImporter(locEN, (IFilter)tmxFilter);
        tmxHandler.importTmx(this.root.in("/sample_tmx.xml").asUri(), locIT, (ITmWriter)tmWriter);
        tmWriter.close();
        try (PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);){
            TranslationUnit tu = ((TmHit)seeker.searchExact(new TextFragment("hello"), null).get(0)).getTu();
            Assert.assertEquals((String)"tu target content", (Object)"ciao", (Object)tu.getTarget().getContent().toText());
            Assert.assertEquals((String)"tu source content", (Object)"hello", (Object)tu.getSource().getContent().toText());
            tu = ((TmHit)seeker.searchExact(new TextFragment("world"), null).get(0)).getTu();
            Assert.assertEquals((String)"tu target content", (Object)"mondo", (Object)tu.getTarget().getContent().toText());
            Assert.assertEquals((String)"tu source content", (Object)"world", (Object)tu.getSource().getContent().toText());
        }
    }

    @Test
    public void importTmx_sample_metadata() throws Exception {
        TmxFilter tmxFilter = new TmxFilter();
        RAMDirectory ramDir = new RAMDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxHandler = new OkapiTmxImporter(locEN, (IFilter)tmxFilter);
        tmxHandler.importTmx(this.root.in("/sample_tmx.xml").asUri(), locIT, (ITmWriter)tmWriter);
        tmWriter.close();
        try (PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);){
            TranslationUnit tu = ((TmHit)seeker.searchExact(new TextFragment("hello"), null).get(0)).getTu();
            Assert.assertEquals((String)"# of metadata (not ignored)", (long)4L, (long)tu.getMetadata().size());
            Assert.assertEquals((String)"tu id", (Object)"hello123", (Object)tu.getMetadata().get((Object)MetadataType.ID));
            Assert.assertEquals((String)"tu FileName", (Object)"GeorgeInTheJungle.hdf", (Object)tu.getMetadata().get((Object)MetadataType.FILE_NAME));
            Assert.assertEquals((String)"tu GroupName", (Object)"ImAGroupie", (Object)tu.getMetadata().get((Object)MetadataType.GROUP_NAME));
            Assert.assertEquals((String)"tu Type", (Object)"plaintext", (Object)tu.getMetadata().get((Object)MetadataType.TYPE));
        }
    }
}

