/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.writer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class TmWriterFactory {
    public static ITmWriter createFileBasedTmWriter(String indexDirectoryPath, boolean createNewTmIndex) {
        PensieveWriter writer;
        try {
            File f = new File(indexDirectoryPath);
            if (!f.exists()) {
                throw new OkapiIOException(indexDirectoryPath + " does not exist");
            }
            writer = new PensieveWriter((Directory)FSDirectory.open((Path)f.toPath()), createNewTmIndex);
        }
        catch (IOException ioe) {
            throw new OkapiIOException("Trouble creating FSDirectory with the given path: " + indexDirectoryPath, (Throwable)ioe);
        }
        catch (NullPointerException npe) {
            throw new OkapiIOException("indexDirectoryPath cannot be null");
        }
        return writer;
    }
}

