/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.seeker;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public final class TmSeekerFactory {
    private TmSeekerFactory() {
    }

    public static ITmSeeker createFileBasedTmSeeker(String indexDirectoryPath) {
        FSDirectory dir;
        try {
            File f = new File(indexDirectoryPath);
            if (!f.exists()) {
                throw new OkapiIOException(String.format("'%s' does not exist.", indexDirectoryPath));
            }
            dir = FSDirectory.open((Path)f.toPath());
        }
        catch (IOException ioe) {
            throw new OkapiIOException(String.format("Trouble creating FSDirectory with the path '%s'.", indexDirectoryPath), (Throwable)ioe);
        }
        catch (NullPointerException npe) {
            throw new OkapiIOException("'indexDirectoryPath' cannot be null");
        }
        return new PensieveSeeker((Directory)dir);
    }
}

