/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import net.sf.okapi.common.Util;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;

public class TranslationUnit {
    private TranslationUnitVariant source;
    private TranslationUnitVariant target;
    private Metadata metadata = new Metadata();

    public TranslationUnit() {
    }

    public TranslationUnit(TranslationUnitVariant source, TranslationUnitVariant target) {
        this();
        this.source = source;
        this.target = target;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public TranslationUnitVariant getSource() {
        return this.source;
    }

    public TranslationUnitVariant getTarget() {
        return this.target;
    }

    public void setSource(TranslationUnitVariant source) {
        this.source = source;
    }

    public void setTarget(TranslationUnitVariant target) {
        this.target = target;
    }

    public boolean isSourceEmpty() {
        return TranslationUnit.isFragmentEmpty(this.source);
    }

    public void setMetadataValue(MetadataType key, String value) {
        if (Util.isEmpty((String)value)) {
            this.metadata.remove((Object)key);
        } else {
            this.metadata.put(key, value);
        }
    }

    public boolean isTargetEmpty() {
        return TranslationUnit.isFragmentEmpty(this.target);
    }

    public String getMetadataValue(MetadataType key) {
        return (String)this.metadata.get((Object)key);
    }

    private static boolean isFragmentEmpty(TranslationUnitVariant frag) {
        return frag == null || frag.getContent() == null || frag.getContent().isEmpty();
    }

    public String toString() {
        return "Source: " + this.getSource().getContent().toText() + "\nTarget: " + this.getTarget().getContent().toText();
    }
}

