/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TmHitTest {
    TmHit h1;
    TmHit h2;
    TranslationUnitVariant tuvSource1;
    TranslationUnitVariant tuvTarget1;
    TranslationUnitVariant tuvSource2;
    TranslationUnitVariant tuvTarget2;
    TranslationUnit tu1;
    TranslationUnit tu2;

    @Before
    public void setUp() {
        this.tuvSource1 = new TranslationUnitVariant(new LocaleId("en"), new TextFragment("test1"));
        this.tuvTarget1 = new TranslationUnitVariant(new LocaleId("es"), new TextFragment("prueba1"));
        this.tu1 = new TranslationUnit(this.tuvSource1, this.tuvTarget1);
        this.tuvSource2 = new TranslationUnitVariant(new LocaleId("en"), new TextFragment("test2"));
        this.tuvTarget2 = new TranslationUnitVariant(new LocaleId("es"), new TextFragment("prueba2"));
        this.tu2 = new TranslationUnit(this.tuvSource2, this.tuvTarget2);
        this.h1 = new TmHit(this.tu1, MatchType.EXACT, 100.0f);
        this.h2 = new TmHit(this.tu2, MatchType.EXACT, 100.0f);
    }

    @Test
    public void noArgConstructor() {
        TmHit tmh = new TmHit();
        Assert.assertNull((Object)tmh.getTu());
        Assert.assertEquals((float)0.0f, (float)tmh.getScore(), (float)0.001f);
        Assert.assertTrue((MatchType.UKNOWN == tmh.getMatchType() ? 1 : 0) != 0);
    }

    @Test
    public void constructor() {
        Assert.assertNotNull((Object)this.h1.getTu());
        Assert.assertNotNull((Object)Float.valueOf(this.h1.getScore()));
        Assert.assertNotNull((Object)this.h1.getMatchType());
    }

    @Test
    public void instanceEquality() {
        TmHit h1;
        TmHit h2 = h1 = new TmHit();
        Assert.assertTrue((String)"instance equality", (boolean)h1.equals((Object)h2));
    }

    @Test
    public void equals() {
        TmHit h = new TmHit();
        h.setTu(this.tu1);
        h.setScore(Float.valueOf(80.0f));
        h.setMatchType(MatchType.EXACT);
        Assert.assertTrue((String)"equals", (boolean)this.h1.equals((Object)h));
    }

    @Test
    public void notEquals() {
        Assert.assertFalse((String)"not equals", (boolean)this.h1.equals((Object)this.h2));
    }

    @Test
    public void compareToEquals() {
        TmHit h = new TmHit();
        h.setTu(this.tu1);
        h.setScore(Float.valueOf(100.0f));
        h.setMatchType(MatchType.EXACT);
        Assert.assertEquals((long)0L, (long)this.h1.compareTo(h));
    }

    @Test
    public void compareToGreaterThanScore() {
        TmHit h = new TmHit();
        h.setTu(this.tu1);
        h.setScore(Float.valueOf(50.0f));
        h.setMatchType(MatchType.EXACT);
        Assert.assertTrue((this.h1.compareTo(h) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToLessThanScore() {
        TmHit h = new TmHit();
        h.setTu(this.tu1);
        h.setScore(Float.valueOf(80.0f));
        h.setMatchType(MatchType.EXACT);
        Assert.assertTrue((this.h1.compareTo(h) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToLessThanMatchType() {
        TmHit h = new TmHit();
        h.setTu(this.tu1);
        h.setScore(Float.valueOf(80.0f));
        h.setMatchType(MatchType.FUZZY);
        Assert.assertTrue((this.h1.compareTo(h) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToGreaterThanMatchType() {
        TmHit h = new TmHit();
        h.setTu(this.tu1);
        h.setScore(Float.valueOf(80.0f));
        h.setMatchType(MatchType.EXACT_LOCAL_CONTEXT);
        Assert.assertTrue((this.h1.compareTo(h) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToLessThanSource() {
        TmHit h = new TmHit();
        TranslationUnitVariant tuvSource = new TranslationUnitVariant(new LocaleId("en"), new TextFragment("aest1"));
        TranslationUnitVariant tuvTarget = new TranslationUnitVariant(new LocaleId("es"), new TextFragment("prueba1"));
        TranslationUnit tu = new TranslationUnit(tuvSource, tuvTarget);
        h.setTu(tu);
        h.setScore(Float.valueOf(80.0f));
        h.setMatchType(MatchType.FUZZY);
        Assert.assertTrue((this.h1.compareTo(h) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToGreaterThanSource() {
        TmHit h = new TmHit();
        TranslationUnitVariant tuvSource = new TranslationUnitVariant(new LocaleId("en"), new TextFragment("zest1"));
        TranslationUnitVariant tuvTarget = new TranslationUnitVariant(new LocaleId("es"), new TextFragment("prueba1"));
        TranslationUnit tu = new TranslationUnit(tuvSource, tuvTarget);
        h.setTu(tu);
        h.setScore(Float.valueOf(80.0f));
        h.setMatchType(MatchType.EXACT_LOCAL_CONTEXT);
        Assert.assertTrue((this.h1.compareTo(h) > 0 ? 1 : 0) != 0);
    }
}

