/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.io.IOException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.tm.pensieve.common.PensieveUtil;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import net.sf.okapi.tm.pensieve.tmx.ITmxExporter;

public class OkapiTmxExporter
implements ITmxExporter {
    @Override
    public void exportTmx(LocaleId sourceLocale, ITmSeeker tmSeeker, TMXWriter tmxWriter) throws IOException {
        this.exportTmx(sourceLocale, null, tmSeeker, tmxWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportTmx(LocaleId sourceLang, LocaleId targetLang, ITmSeeker tmSeeker, TMXWriter tmxWriter) throws IOException {
        this.checkExportTmxParams(sourceLang, tmSeeker, tmxWriter);
        try {
            tmxWriter.writeStartDocument(sourceLang, targetLang, "pensieve", "0.0.1", "sentence", "pensieve", "unknown");
            for (TranslationUnit tu : (PensieveSeeker)tmSeeker) {
                if (!OkapiTmxExporter.isWriteTextUnit(sourceLang, targetLang, tu)) continue;
                tmxWriter.writeTUFull(PensieveUtil.convertToTextUnit(tu));
            }
            tmxWriter.writeEndDocument();
        }
        finally {
            tmxWriter.close();
        }
    }

    private static boolean isWriteTextUnit(LocaleId sourceLang, LocaleId targetLang, TranslationUnit tu) {
        return sourceLang.equals((Object)tu.getSource().getLanguage()) && (targetLang == null || targetLang.equals((Object)tu.getTarget().getLanguage()));
    }

    private void checkExportTmxParams(LocaleId sourceLang, ITmSeeker tmSeeker, TMXWriter tmxWriter) {
        if (sourceLang == null) {
            throw new IllegalArgumentException("'sourceLang' was not set");
        }
        if (tmSeeker == null) {
            throw new IllegalArgumentException("'tmSeeker' was not set");
        }
        if (tmxWriter == null) {
            throw new IllegalArgumentException("'tmxWriter' was not set");
        }
    }
}

