/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import net.sf.okapi.common.HashCodeUtil;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;

public class TmHit
implements Comparable<TmHit> {
    private TranslationUnit tu;
    private float score;
    private MatchType matchType;
    private boolean codeMismatch;
    private int docId;

    public TmHit() {
        this.setMatchType(MatchType.UKNOWN);
        this.setCodeMismatch(false);
    }

    public TmHit(TranslationUnit tu, MatchType matchType, float score) {
        this.setTu(tu);
        this.setMatchType(matchType);
        this.setScore(Float.valueOf(score));
        this.setCodeMismatch(false);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score.floatValue();
    }

    public TranslationUnit getTu() {
        return this.tu;
    }

    public void setTu(TranslationUnit tu) {
        this.tu = tu;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setCodeMismatch(boolean codeMismatch) {
        this.codeMismatch = codeMismatch;
    }

    public boolean isCodeMismatch() {
        return this.codeMismatch;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public int getDocId() {
        return this.docId;
    }

    @Override
    public int compareTo(TmHit other) {
        int comparison;
        boolean EQUAL = false;
        if (this == other) {
            return 0;
        }
        String thisSource = this.tu.getSource().getContent().toText();
        String otherSource = other.tu.getSource().getContent().toText();
        if ((this.isExact(this.matchType) || this.isExact(other.matchType)) && (comparison = this.matchType.compareTo((Enum)other.getMatchType())) != 0) {
            return comparison;
        }
        comparison = Float.compare(this.score, other.getScore());
        if (comparison != 0) {
            return comparison * -1;
        }
        comparison = thisSource.compareTo(otherSource);
        if (comparison != 0) {
            return comparison;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TmHit)) {
            return false;
        }
        TmHit otherHit = (TmHit)other;
        return this.matchType == otherHit.getMatchType() && this.tu.getSource().getContent().toText().equals(otherHit.getTu().getSource().getContent().toText()) && this.tu.getTarget().getContent().toText().equals(otherHit.getTu().getTarget().getContent().toText());
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.matchType);
        result = HashCodeUtil.hash((int)result, (Object)this.tu.getSource().getContent().toText());
        result = HashCodeUtil.hash((int)result, (Object)this.tu.getTarget().getContent().toText());
        return result;
    }

    private boolean isExact(MatchType type) {
        return type.ordinal() <= MatchType.EXACT_REPAIRED.ordinal();
    }
}

