/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.writer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.tm.pensieve.Helper;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitField;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PensieveWriterTest {
    PensieveWriter tmWriter;
    IndexWriter writer;
    static final File GOOD_DIR = new File("../data/");
    static final File GOOD_FILE = new File(GOOD_DIR, "apache1.0.txt");
    RAMDirectory dir;
    LocaleId locEN = LocaleId.fromString((String)"EN");
    LocaleId locFR = LocaleId.fromString((String)"FR");
    LocaleId locKR = LocaleId.fromString((String)"KR");

    @Before
    public void init() throws IOException {
        this.dir = new RAMDirectory();
        this.tmWriter = new PensieveWriter((Directory)this.dir, true);
        this.writer = this.tmWriter.getIndexWriter();
    }

    @Test
    public void constructorCreateNew() throws IOException {
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1"));
        this.tmWriter.close();
        this.tmWriter = new PensieveWriter((Directory)this.dir, true);
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joseph", "Yosep", "2"));
        this.tmWriter.close();
        Assert.assertEquals((String)"# of docs in tm", (long)1L, (long)this.tmWriter.getIndexWriter().numDocs());
    }

    @Test
    public void constructorCreateNew2() throws IOException {
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1"));
        this.tmWriter.close();
        this.tmWriter = new PensieveWriter((Directory)this.dir, true);
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joseph", "Yosep", "2"));
        this.tmWriter.close();
        Assert.assertEquals((String)"# of docs in tm", (long)1L, (long)this.tmWriter.getIndexWriter().numDocs());
    }

    @Test
    public void constructorAppend() throws IOException {
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1"));
        this.tmWriter.close();
        this.tmWriter = new PensieveWriter((Directory)this.dir, false);
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joseph", "Yosep", "2"));
        this.tmWriter.close();
        Assert.assertEquals((String)"# of docs in tm", (long)2L, (long)this.tmWriter.getIndexWriter().numDocs());
    }

    @Test
    public void getIndexWriterSameDirectory() {
        Assert.assertSame((String)"ram directory", (Object)this.dir, (Object)this.tmWriter.getIndexWriter().getDirectory());
    }

    @Test
    public void indexTranslationUnitMetaData() throws IOException {
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1"));
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Jane", "Jaen", "2"));
        this.writer.commit();
        Assert.assertEquals((String)"# of docs found for id=1", (long)1L, (long)this.getNumOfHitsFor(MetadataType.ID.fieldName(), "1"));
        Assert.assertEquals((String)"# of docs found for id=2", (long)1L, (long)this.getNumOfHitsFor(MetadataType.ID.fieldName(), "2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateNullTu() {
        this.tmWriter.update(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateEmptyId() {
        this.tmWriter.update(new TranslationUnit());
    }

    @Test
    public void update() throws IOException {
        TranslationUnit tu1 = Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1");
        TranslationUnit tu2 = Helper.createTU(this.locEN, this.locKR, "Jane", "Jaen", "2");
        this.tmWriter.indexTranslationUnit(tu1);
        this.tmWriter.indexTranslationUnit(tu2);
        this.writer.commit();
        tu1.getTarget().setContent(new TextFragment("Ju"));
        this.tmWriter.update(tu1);
        this.writer.commit();
        Document doc1 = this.findDocument(MetadataType.ID.fieldName(), "1");
        Document doc2 = this.findDocument(MetadataType.ID.fieldName(), "2");
        Assert.assertEquals((String)"source text", (Object)tu1.getSource().getContent().toText(), (Object)doc1.getField(TranslationUnitField.SOURCE_EXACT.name()).stringValue());
        Assert.assertEquals((String)"target text", (Object)tu1.getTarget().getContent().toText(), (Object)doc1.getField(TranslationUnitField.TARGET.name()).stringValue());
        Assert.assertEquals((String)"target text", (Object)tu2.getTarget().getContent().toText(), (Object)doc2.getField(TranslationUnitField.TARGET.name()).stringValue());
    }

    @Test
    public void indexTranslationUnitWithOverwriteOption() throws IOException {
        TranslationUnit tu1 = Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1");
        TranslationUnit tu2 = Helper.createTU(this.locEN, this.locKR, "Jane", "Jaen", "2");
        this.tmWriter.indexTranslationUnit(tu1);
        this.tmWriter.indexTranslationUnit(tu2);
        this.writer.commit();
        TranslationUnit tu1new = Helper.createTU(this.locEN, this.locKR, "Joe", "NewJo", "3");
        this.tmWriter.indexTranslationUnit(tu1new, true);
        this.writer.commit();
        Document doc = this.findDocument(MetadataType.ID.fieldName(), "3");
        Assert.assertEquals((String)"source text", (Object)"Joe", (Object)doc.getField(TranslationUnitField.SOURCE_EXACT.name()).stringValue());
        Assert.assertEquals((String)"target text", (Object)"NewJo", (Object)doc.getField(TranslationUnitField.TARGET.name()).stringValue());
        doc = this.findDocument(MetadataType.ID.fieldName(), "1");
        Assert.assertNull((Object)doc);
        tu1new = Helper.createTU(this.locEN, this.locKR, "Joe", "NewJo2", "4");
        this.tmWriter.indexTranslationUnit(tu1new, false);
        this.writer.commit();
        doc = this.findDocument(MetadataType.ID.fieldName(), "4");
        Assert.assertEquals((String)"source text", (Object)"Joe", (Object)doc.getField(TranslationUnitField.SOURCE_EXACT.name()).stringValue());
        Assert.assertEquals((String)"target text", (Object)"NewJo2", (Object)doc.getField(TranslationUnitField.TARGET.name()).stringValue());
        doc = this.findDocument(MetadataType.ID.fieldName(), "3");
        Assert.assertEquals((String)"source text", (Object)"Joe", (Object)doc.getField(TranslationUnitField.SOURCE_EXACT.name()).stringValue());
        Assert.assertEquals((String)"target text", (Object)"NewJo", (Object)doc.getField(TranslationUnitField.TARGET.name()).stringValue());
    }

    @Test
    public void indexTranslationUnitWithOverwriteOptionAndCodes() throws IOException {
        TranslationUnit tu1 = Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1");
        tu1.getSource().getContent().append(TextFragment.TagType.PLACEHOLDER, "code", "data1");
        this.tmWriter.indexTranslationUnit(tu1);
        this.writer.commit();
        TranslationUnit tu1new = Helper.createTU(this.locEN, this.locKR, "Joe", "NewJo", "2");
        tu1new.getSource().getContent().append(TextFragment.TagType.PLACEHOLDER, "code", "data2");
        this.tmWriter.indexTranslationUnit(tu1new, true);
        this.writer.commit();
        Document doc = this.findDocument(MetadataType.ID.fieldName(), "2");
        Assert.assertEquals((String)"target text", (Object)"NewJo", (Object)doc.getField(TranslationUnitField.TARGET.name()).stringValue());
        doc = this.findDocument(MetadataType.ID.fieldName(), "1");
        Assert.assertEquals((String)"target text", (Object)"Jo", (Object)doc.getField(TranslationUnitField.TARGET.name()).stringValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteNullId() {
        this.tmWriter.delete(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void deleteEmptyId() {
        this.tmWriter.delete("");
    }

    @Test
    public void deleteWithId() throws IOException {
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Joe", "Jo", "1"));
        this.tmWriter.indexTranslationUnit(Helper.createTU(this.locEN, this.locKR, "Jane", "Jaen", "2"));
        this.writer.commit();
        this.tmWriter.delete("1");
        this.writer.commit();
        Assert.assertEquals((String)"# of docs found for id=1", (long)0L, (long)this.getNumOfHitsFor(MetadataType.ID.fieldName(), "1"));
        Assert.assertEquals((String)"# of docs found for id=2", (long)1L, (long)this.getNumOfHitsFor(MetadataType.ID.fieldName(), "2"));
    }

    @Test
    public void addMetadataToDocument() {
        Metadata md = new Metadata();
        md.put((Object)MetadataType.FILE_NAME, (Object)"some/file");
        md.put((Object)MetadataType.GROUP_NAME, (Object)"some group");
        md.put((Object)MetadataType.ID, (Object)"someId");
        md.put((Object)MetadataType.TYPE, (Object)"someType");
        Document doc = new Document();
        this.tmWriter.addMetadataToDocument(doc, md);
        Assert.assertEquals((String)"Document's file name field", (Object)"some/file", (Object)this.getFieldValue(doc, MetadataType.FILE_NAME.fieldName()));
        Assert.assertEquals((String)"Document's group name field", (Object)"some group", (Object)this.getFieldValue(doc, MetadataType.GROUP_NAME.fieldName()));
        Assert.assertEquals((String)"Document's id field", (Object)"someId", (Object)this.getFieldValue(doc, MetadataType.ID.fieldName()));
        Assert.assertEquals((String)"Document's type field", (Object)"someType", (Object)this.getFieldValue(doc, MetadataType.TYPE.fieldName()));
    }

    @Test
    public void constructorCreatesWriter() {
        Assert.assertNotNull((String)"the tmWriter tmWriter was not created as expected", (Object)this.tmWriter);
    }

    @Test
    public void constructorUsesExpectedDirectory() {
        Assert.assertTrue((String)"The index directory should end with 'target/test-classes'", (boolean)(this.writer.getDirectory() instanceof RAMDirectory));
    }

    public void endIndexHandlesIOException() throws Exception {
    }

    @Test(expected=AlreadyClosedException.class)
    public void endIndexClosesWriter() throws IOException {
        this.tmWriter.close();
        this.tmWriter.getIndexWriter().commit();
    }

    @Test
    public void endIndexThrowsNoException() {
        this.tmWriter.close();
        this.tmWriter.close();
    }

    @Test
    public void endIndexCommits() throws IOException {
        this.tmWriter.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment("dax")), new TranslationUnitVariant(this.locKR, new TextFragment("is funny (sometimes)"))));
        this.tmWriter.close();
        IndexReader reader = IndexReader.open((Directory)this.dir, (boolean)true);
        Assert.assertEquals((String)"num of docs indexed after endIndex", (long)1L, (long)reader.maxDoc());
    }

    @Test
    public void getDocumentNoSourceContent() {
        Assert.assertNull((Object)this.tmWriter.createDocument(new TranslationUnit(null, new TranslationUnitVariant(this.locEN, new TextFragment("some target")))));
    }

    @Test
    public void getDocumentEmptySourceContent() {
        Assert.assertNull((Object)this.tmWriter.createDocument(new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment("")), new TranslationUnitVariant(this.locEN, new TextFragment("some target")))));
    }

    @Test(expected=NullPointerException.class)
    public void getDocumentNullTU() {
        this.tmWriter.createDocument(null);
    }

    @Test
    public void getDocumentValues() {
        String text = "blah blah blah";
        TranslationUnit tu = new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment(text)), new TranslationUnitVariant(this.locFR, new TextFragment("someone")));
        Metadata md = tu.getMetadata();
        md.put((Object)MetadataType.ID, (Object)"someId");
        Document doc = this.tmWriter.createDocument(tu);
        Assert.assertEquals((String)"Document's content field", (Object)"blah blah blah", (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE.name()));
        Assert.assertEquals((String)"Document's content exact field", (Object)"blah blah blah", (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE_EXACT.name()));
        Assert.assertEquals((String)"Document's target field", (Object)"someone", (Object)this.getFieldValue(doc, TranslationUnitField.TARGET.name()));
        Assert.assertEquals((String)"Document's source lang field", (Object)this.locEN.toBCP47(), (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE_LANG.name()));
        Assert.assertEquals((String)"Document's target lang field", (Object)this.locFR.toBCP47(), (Object)this.getFieldValue(doc, TranslationUnitField.TARGET_LANG.name()));
        Assert.assertEquals((String)"Document's id field", (Object)"someId", (Object)this.getFieldValue(doc, MetadataType.ID.fieldName()));
    }

    @Test
    public void testCreateDocument() {
        TextFragment srcFrag = new TextFragment("blah ");
        srcFrag.append(TextFragment.TagType.OPENING, "b", "<b>");
        srcFrag.append("bold");
        srcFrag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        String srcCT = srcFrag.getCodedText();
        String srcCodes = Code.codesToString((List)srcFrag.getCodes());
        TextFragment trgFrag = new TextFragment("blah ");
        trgFrag.append(TextFragment.TagType.OPENING, "i", "<i>");
        trgFrag.append("gras");
        trgFrag.append(TextFragment.TagType.CLOSING, "i", "</i>");
        String trgCT = trgFrag.getCodedText();
        String trgCodes = Code.codesToString((List)trgFrag.getCodes());
        TranslationUnit tu = new TranslationUnit(new TranslationUnitVariant(this.locEN, srcFrag), new TranslationUnitVariant(this.locFR, trgFrag));
        Metadata md = tu.getMetadata();
        md.put((Object)MetadataType.ID, (Object)"someId");
        Document doc = this.tmWriter.createDocument(tu);
        Assert.assertEquals((String)"Document's content field", (Object)srcCT, (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE_EXACT.name()));
        Assert.assertEquals((String)"Document's content exact field", (Object)srcCT, (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE_EXACT.name()));
        Assert.assertEquals((String)"Document's target field", (Object)trgCT, (Object)this.getFieldValue(doc, TranslationUnitField.TARGET.name()));
        Assert.assertEquals((String)"Document's source lang field", (Object)this.locEN.toBCP47(), (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE_LANG.name()));
        Assert.assertEquals((String)"Document's target lang field", (Object)this.locFR.toBCP47(), (Object)this.getFieldValue(doc, TranslationUnitField.TARGET_LANG.name()));
        Assert.assertEquals((String)"Document's id field", (Object)"someId", (Object)this.getFieldValue(doc, MetadataType.ID.fieldName()));
        Assert.assertEquals((String)"Document's source codes", (Object)srcCodes, (Object)this.getFieldValue(doc, TranslationUnitField.SOURCE_CODES.name()));
        Assert.assertEquals((String)"Document's target codes", (Object)trgCodes, (Object)this.getFieldValue(doc, TranslationUnitField.TARGET_CODES.name()));
    }

    @Test
    public void getDocumentNoTarget() {
        Document doc = this.tmWriter.createDocument(new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment("blah blah blah")), null));
        Assert.assertNull((String)"Document's target field should be null", (Object)doc.getField(TranslationUnitField.TARGET.name()));
    }

    @Test(expected=NullPointerException.class)
    public void indexTranslationUnitNull() {
        this.tmWriter.indexTranslationUnit(null);
    }

    @Test(expected=NullPointerException.class)
    public void indexTranslationUnitNull2() {
        this.tmWriter.indexTranslationUnit(null);
    }

    @Test
    public void indexTranslationUnitNoIndexedDocsBeforeCall() throws IOException {
        Assert.assertEquals((String)"num of docs indexed", (long)0L, (long)this.tmWriter.getIndexWriter().numDocs());
    }

    @Test(expected=IndexNotFoundException.class)
    public void indexTranslationUnitBeforeCommit() throws IOException {
        this.tmWriter.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment("dax")), new TranslationUnitVariant(this.locEN, new TextFragment("is funny (sometimes)"))));
        IndexReader.open((Directory)this.dir, (boolean)true);
    }

    @Test
    public void indexTextUnit() throws IOException {
        this.tmWriter.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment("joe")), new TranslationUnitVariant(this.locEN, new TextFragment("schmoe"))));
        Assert.assertEquals((String)"num of docs indexed", (long)1L, (long)this.tmWriter.getIndexWriter().numDocs());
    }

    @Test
    public void indexTextUnit2() throws IOException {
        this.tmWriter.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(this.locEN, new TextFragment("joe")), new TranslationUnitVariant(this.locEN, new TextFragment("schmoe"))));
        Assert.assertEquals((String)"num of docs indexed", (long)1L, (long)this.tmWriter.getIndexWriter().numDocs());
    }

    private String getFieldValue(Document doc, String fieldName) {
        return doc.getField(fieldName).stringValue();
    }

    private int getNumOfHitsFor(String fieldName, String fieldValue) throws IOException {
        IndexSearcher is = new IndexSearcher((Directory)this.dir, true);
        PhraseQuery q = new PhraseQuery();
        q.add(new Term(fieldName, fieldValue));
        int numOfHits = is.search((Query)q, (int)10).scoreDocs.length;
        is.close();
        return numOfHits;
    }

    private Document findDocument(String fieldName, String fieldValue) throws IOException {
        IndexSearcher is = new IndexSearcher((Directory)this.dir, true);
        PhraseQuery q = new PhraseQuery();
        q.add(new Term(fieldName, fieldValue));
        TopDocs hits = is.search((Query)q, 1);
        if (hits.totalHits == 0) {
            is.close();
            return null;
        }
        ScoreDoc scoreDoc = hits.scoreDocs[0];
        Document documentFound = is.doc(scoreDoc.doc);
        is.close();
        return documentFound;
    }
}

