/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TranslationUnitTest {
    TranslationUnit tu;
    static final TranslationUnitVariant SOURCE = new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("Joe McMac"));
    static final TranslationUnitVariant CONTENT = new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("Some content that isn't very long"));

    @Before
    public void setUp() {
        this.tu = new TranslationUnit();
    }

    @Test
    public void getMetadataValueNullKey() {
        this.tu.setMetadataValue(MetadataType.ID, "test");
        Assert.assertNull((String)"The ID metadata should not exist", (Object)this.tu.getMetadataValue(null));
    }

    @Test
    public void getMetadataValueKey() {
        this.tu.setMetadataValue(MetadataType.ID, "test");
        Assert.assertEquals((String)"The ID metadata", (Object)"test", (Object)this.tu.getMetadataValue(MetadataType.ID));
    }

    @Test
    public void setMetadataValueNull() {
        this.tu.setMetadataValue(MetadataType.ID, null);
        Assert.assertFalse((String)"The ID metadata should not exist", (boolean)this.tu.getMetadata().containsKey((Object)MetadataType.ID));
    }

    @Test
    public void setMetadataValueEmpty() {
        this.tu.setMetadataValue(MetadataType.ID, "");
        Assert.assertFalse((String)"The ID metadata should not exist", (boolean)this.tu.getMetadata().containsKey((Object)MetadataType.ID));
    }

    @Test
    public void setMetadataValue() {
        this.tu.setMetadataValue(MetadataType.ID, "yipee");
        Assert.assertEquals((String)"The ID metadata", (Object)"yipee", (Object)this.tu.getMetadata().get((Object)MetadataType.ID));
    }

    @Test
    public void noArgConstructor() {
        this.tu = new TranslationUnit();
        Assert.assertNull((String)"source", (Object)this.tu.getSource());
        Assert.assertNull((String)"content", (Object)this.tu.getTarget());
        Assert.assertEquals((String)"metadata entries", (long)0L, (long)this.tu.getMetadata().size());
    }

    @Test
    public void constructor_allParamsPassed() {
        this.tu = new TranslationUnit(SOURCE, CONTENT);
        Assert.assertEquals((String)"source", (Object)SOURCE, (Object)this.tu.getSource());
        Assert.assertEquals((String)"content", (Object)CONTENT, (Object)this.tu.getTarget());
        Assert.assertEquals((String)"metadata entries", (long)0L, (long)this.tu.getMetadata().size());
    }

    @Test
    public void metaDataSetter() {
        this.tu = new TranslationUnit(SOURCE, CONTENT);
        Metadata md = new Metadata();
        this.tu.setMetadata(md);
        Assert.assertSame((String)"metadata should be the same", (Object)md, (Object)this.tu.getMetadata());
    }

    @Test
    public void isSourceEmptyNull() {
        Assert.assertTrue((String)"source should be empty", (boolean)this.tu.isSourceEmpty());
    }

    @Test
    public void isSourceEmptyEmpty() {
        this.tu.setSource(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("")));
        Assert.assertTrue((String)"source should be empty", (boolean)this.tu.isSourceEmpty());
    }

    @Test
    public void isSourceEmptyNotEmpty() {
        this.tu.setSource(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("this is not empty")));
        Assert.assertFalse((String)"source should not be empty", (boolean)this.tu.isSourceEmpty());
    }

    @Test
    public void isTargetEmptyNull() {
        Assert.assertTrue((String)"target should be empty", (boolean)this.tu.isTargetEmpty());
    }

    @Test
    public void isTargetEmptyEmpty() {
        this.tu.setTarget(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("")));
        Assert.assertTrue((String)"target should be empty", (boolean)this.tu.isTargetEmpty());
    }

    @Test
    public void isTargetEmptyNotEmpty() {
        this.tu.setTarget(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("this is not empty")));
        Assert.assertFalse((String)"target should not be empty", (boolean)this.tu.isTargetEmpty());
    }
}

