/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.tm.pensieve.Helper;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.PensieveUtil;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PensieveUtilTest {
    @Test
    public void stupidTestOnlyForCoverage() throws Exception {
        Helper.genericTestConstructor(PensieveUtil.class);
    }

    @Test
    public void convertToTranslationUnitMetadata() {
        TextUnit textUnit = new TextUnit("someId", "some great text");
        textUnit.setTargetContent(LocaleId.fromString((String)"kr"), new TextFragment("some great text in Korean"));
        textUnit.setProperty(new Property(MetadataType.FILE_NAME.fieldName(), "sumdumfilename"));
        TranslationUnit tu = PensieveUtil.convertToTranslationUnit((LocaleId)LocaleId.fromString((String)"en"), (LocaleId)LocaleId.fromString((String)"kr"), (ITextUnit)textUnit);
        Assert.assertEquals((String)"# of meetadaatas", (long)1L, (long)tu.getMetadata().size());
        Assert.assertEquals((String)"file name meta data", (Object)"sumdumfilename", (Object)tu.getMetadataValue(MetadataType.FILE_NAME));
    }

    @Test
    public void convertToTranslationUnitNonMatchingProperty() {
        TextUnit textUnit = new TextUnit("someId", "some great text");
        textUnit.setTargetContent(LocaleId.fromString((String)"kr"), new TextFragment("some great text in Korean"));
        textUnit.setProperty(new Property(MetadataType.FILE_NAME.fieldName(), "sumdumfilename"));
        textUnit.setProperty(new Property("somedumbkey", "sumdumvalue"));
        TranslationUnit tu = PensieveUtil.convertToTranslationUnit((LocaleId)LocaleId.fromString((String)"en"), (LocaleId)LocaleId.fromString((String)"kr"), (ITextUnit)textUnit);
        Assert.assertEquals((String)"# of meetadaatas", (long)1L, (long)tu.getMetadata().size());
    }

    @Test
    public void convertToTranslationUnit() {
        TextUnit textUnit = new TextUnit("someId", "some great text");
        textUnit.setTargetContent(LocaleId.fromString((String)"kr"), new TextFragment("some great text in Korean"));
        TranslationUnit tu = PensieveUtil.convertToTranslationUnit((LocaleId)LocaleId.fromString((String)"en"), (LocaleId)LocaleId.fromString((String)"kr"), (ITextUnit)textUnit);
        Assert.assertEquals((String)"sourceLang", (Object)"en", (Object)tu.getSource().getLanguage().toString());
        Assert.assertEquals((String)"source content", (Object)"some great text", (Object)tu.getSource().getContent().toText());
        Assert.assertEquals((String)"targetLang", (Object)"kr", (Object)tu.getTarget().getLanguage().toString());
        Assert.assertEquals((String)"target content", (Object)"some great text in Korean", (Object)tu.getTarget().getContent().toText());
    }

    @Test
    public void convertToTextUnitNullId() {
        TranslationUnit tu = Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), "bipity bopity boo", "something in korean", null);
        tu.setMetadataValue(MetadataType.GROUP_NAME, "groupie");
        ITextUnit textUnit = PensieveUtil.convertToTextUnit((TranslationUnit)tu);
        Assert.assertEquals((String)"source content", (Object)"bipity bopity boo", (Object)textUnit.getSource().getFirstContent().toText());
        Assert.assertEquals((String)"target content", (Object)"something in korean", (Object)textUnit.getTarget(LocaleId.fromString((String)"KR")).getFirstContent().toText());
        Assert.assertEquals((String)"tuid", null, (Object)textUnit.getId());
        Assert.assertEquals((String)"name", null, (Object)textUnit.getName());
        Assert.assertEquals((String)"group attribute", (Object)"groupie", (Object)textUnit.getProperty(MetadataType.GROUP_NAME.fieldName()).getValue());
    }

    @Test
    public void convertToTextUnit() {
        TranslationUnit tu = Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), "bipity bopity boo", "something in korean", "1");
        tu.setMetadataValue(MetadataType.GROUP_NAME, "groupie");
        ITextUnit textUnit = PensieveUtil.convertToTextUnit((TranslationUnit)tu);
        Assert.assertEquals((String)"source content", (Object)"bipity bopity boo", (Object)textUnit.getSource().getFirstContent().toText());
        Assert.assertEquals((String)"target content", (Object)"something in korean", (Object)textUnit.getTarget(LocaleId.fromString((String)"KR")).getFirstContent().toText());
        Assert.assertEquals((String)"tuid", (Object)"1", (Object)textUnit.getId());
        Assert.assertEquals((String)"name", (Object)"1", (Object)textUnit.getName());
        Assert.assertEquals((String)"group attribute", (Object)"groupie", (Object)textUnit.getProperty(MetadataType.GROUP_NAME.fieldName()).getValue());
    }
}

