/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.seeker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.tm.pensieve.Helper;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitField;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class PensieveSeekerTest {
    static final Directory DIR = new RAMDirectory();
    static final TranslationUnitVariant TARGET = new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("target text"));
    static final String STR = "watch out for the killer rabbit";
    PensieveSeeker seeker;
    List<TmHit> tmhits;

    @Before
    public void setUp() {
        this.seeker = new PensieveSeeker(DIR);
    }

    @After
    public void tearDown() {
        this.seeker.close();
    }

    @Test
    public void shortEntries() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("abcd")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("abc")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("am")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("zq")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("zqq")), TARGET));
        writer.close();
        List list = this.seeker.searchFuzzy(new TextFragment("abcd"), 100, 1, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)list.size());
        list = this.seeker.searchFuzzy(new TextFragment("abc"), 100, 1, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)list.size());
        list = this.seeker.searchFuzzy(new TextFragment("zqq"), 100, 1, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)list.size());
        list = this.seeker.searchFuzzy(new TextFragment("am"), 100, 1, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)list.size());
        list = this.seeker.searchFuzzy(new TextFragment("zq"), 100, 1, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)list.size());
    }

    @Test
    public void penaltyDifferentSpaces() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("abcdef")), TARGET));
        writer.close();
        List list = this.seeker.searchFuzzy(new TextFragment("abCdef"), 100, 1, null);
        Assert.assertEquals((String)"number of docs found", (long)0L, (long)list.size());
    }

    @Test
    public void translationUnitIterator() throws Exception {
        PensieveWriter writer = this.getWriter();
        this.populateIndex(writer, 12, "patents are evil", "unittest");
        writer.close();
        Iterator tuIterator = this.seeker.iterator();
        ArrayList tus = new ArrayList();
        while (tuIterator.hasNext()) {
            tus.add(tuIterator.next());
        }
        Assert.assertEquals((String)"number of tus", (long)13L, (long)tus.size());
        Assert.assertEquals((String)"first document", (Object)"patents are evil0", (Object)((TranslationUnit)tus.get(0)).getSource().getContent().toText());
        Assert.assertEquals((String)"second document", (Object)"patents are evil1", (Object)((TranslationUnit)tus.get(1)).getSource().getContent().toText());
    }

    @Test
    public void translationUnitIteratorNextCallOnEmpty() throws Exception {
        PensieveWriter writer = this.getWriter();
        this.populateIndex(writer, 1, "patents are evil", "unittest");
        writer.close();
        Iterator tuIterator = this.seeker.iterator();
        tuIterator.next();
        TranslationUnit tu = (TranslationUnit)tuIterator.next();
        Assert.assertNotNull((Object)tu);
        Assert.assertFalse((boolean)tuIterator.hasNext());
        Assert.assertNull(tuIterator.next());
    }

    @Test(expected=OkapiIOException.class)
    public void iteratorInstantiationHandleIOException() throws IOException {
        PensieveSeeker spy = (PensieveSeeker)Mockito.spy((Object)this.seeker);
        ((PensieveSeeker)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("some exception")}).when((Object)spy)).openIndexReader();
        spy.iterator();
    }

    @Test(expected=OkapiIOException.class)
    public void iteratorInstantiationHandleCorruptedIndexException() throws IOException {
        PensieveSeeker spy = (PensieveSeeker)Mockito.spy((Object)this.seeker);
        ((PensieveSeeker)Mockito.doThrow((Throwable[])new Throwable[]{new CorruptIndexException("some exception")}).when((Object)spy)).openIndexReader();
        spy.iterator();
    }

    @Test(expected=OkapiIOException.class)
    public void iteratorNextIOException() throws Exception {
        PensieveWriter writer = this.getWriter();
        this.populateIndex(writer, 1, "patents are evil", "unittest");
        writer.close();
        Iterator iterator = this.seeker.iterator();
        IndexReader mockIndexReader = (IndexReader)Mockito.mock(IndexReader.class);
        ((IndexReader)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("some exception")}).when((Object)mockIndexReader)).document(Matchers.anyInt());
        Helper.setPrivateMember(iterator, "ir", mockIndexReader);
        iterator.next();
    }

    @Test(expected=OkapiIOException.class)
    public void iteratorNextCorruptedIndexException() throws Exception {
        PensieveWriter writer = this.getWriter();
        this.populateIndex(writer, 1, "patents are evil", "unittest");
        writer.close();
        Iterator iterator = this.seeker.iterator();
        IndexReader mockIndexReader = (IndexReader)Mockito.mock(IndexReader.class);
        ((IndexReader)Mockito.doThrow((Throwable[])new Throwable[]{new CorruptIndexException("some exception")}).when((Object)mockIndexReader)).document(Matchers.anyInt());
        Helper.setPrivateMember(iterator, "ir", mockIndexReader);
        iterator.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void iteratorUnsupportedRemove() {
        this.seeker.iterator().remove();
    }

    @Test
    public void getDirectory() {
        Assert.assertSame((String)"directory", (Object)DIR, (Object)this.seeker.getIndexDir());
    }

    @Test
    public void getFieldValueNoField() {
        Document doc = new Document();
        Assert.assertNull((String)"Null should be returned for an empty field", (Object)this.seeker.getFieldValue(doc, TranslationUnitField.SOURCE));
    }

    @Test
    public void getFieldValue() {
        Document doc = new Document();
        doc.add((Fieldable)new Field(TranslationUnitField.SOURCE.name(), "lk", Field.Store.NO, Field.Index.NOT_ANALYZED));
        Assert.assertEquals((String)"source field", (Object)"lk", (Object)this.seeker.getFieldValue(doc, TranslationUnitField.SOURCE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructorNullIndexDir() {
        PensieveSeeker forAutoClose = new PensieveSeeker((Directory)null);
        Throwable throwable = null;
        if (forAutoClose != null) {
            if (throwable != null) {
                try {
                    forAutoClose.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                forAutoClose.close();
            }
        }
    }

    @Test
    public void searchFuzzyMiddleMatch() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(STR)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch for the killer rabbit")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch out the killer rabbit")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(STR), 80, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)3L, (long)this.tmhits.size());
    }

    @Test
    public void searchOnInlineCodes() throws Exception {
        PensieveWriter writer = this.getWriter();
        TextFragment tf = new TextFragment("ABC");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), tf), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(tf, 99, 10, null);
        Assert.assertEquals((long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchOnNoiseAndShortWords() throws Exception {
        PensieveWriter writer = this.getWriter();
        String WORD = "from";
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(WORD)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("help")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(new TextFragment("Help"), 80, 10, null);
        Assert.assertEquals((long)1L, (long)this.tmhits.size());
        Assert.assertEquals((Object)"help", (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(WORD), 80, 10, null);
        Assert.assertEquals((long)1L, (long)this.tmhits.size());
        Assert.assertEquals((Object)"from", (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
    }

    @Test
    public void searchFuzzyWordOrder80Percent() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch rabbit")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(STR)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("rabbit killer the for out watch")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch for the killer rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(STR), 80, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)2L, (long)this.tmhits.size());
        Assert.assertEquals((String)"1st match", (Object)STR, (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
        Assert.assertEquals((String)"2nd match", (Object)"watch for the killer rabbit", (Object)this.tmhits.get(1).getTu().getSource().getContent().toText());
    }

    @Test(expected=IllegalArgumentException.class)
    public void searchFuzzyThresholdGreaterThan100() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch rabbit")), TARGET));
        writer.close();
        this.seeker.searchFuzzy(new TextFragment(STR), 101, 10, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void searchFuzzyThresholdLessThan0() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch rabbit")), TARGET));
        writer.close();
        this.seeker.searchFuzzy(new TextFragment(STR), -1, 10, null);
    }

    @Test
    public void searchFuzzyMiddleMatch80Percent() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch rabbit")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(STR)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch out the killer rabbit and some extra stuff")), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch for the killer rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(STR), 80, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)2L, (long)this.tmhits.size());
        Assert.assertEquals((String)"1st match", (Object)STR, (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
        Assert.assertEquals((String)"2nd match", (Object)"watch for the killer rabbit", (Object)this.tmhits.get(1).getTu().getSource().getContent().toText());
    }

    @Test
    public void searchFuzzy80PercentWithMetadata() throws Exception {
        PensieveWriter writer = this.getWriter();
        writer.indexTranslationUnit(Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), "watch rabbit", "something that is the same", "1", "some_file", "some_group", "nachotype"));
        writer.indexTranslationUnit(Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), STR, "something that is the same", "2", "some_file", "some_group", "nachotype"));
        writer.indexTranslationUnit(Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), "watch out the killer rabbit and some extra stuff", "something that is the same", "3", "some_file", "some_group", "nachotype"));
        writer.indexTranslationUnit(Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), "watch for the killer rabbit", "something that is the same", "4", "some_file", "some_group", "nachotype"));
        writer.indexTranslationUnit(Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), "watch for the killer rabbit", "something that is the same", "5", "nacho_file", "some_group", "nachotype"));
        writer.close();
        Metadata md = new Metadata();
        md.put((Object)MetadataType.FILE_NAME, (Object)"some_file");
        md.put((Object)MetadataType.GROUP_NAME, (Object)"some_group");
        md.put((Object)MetadataType.TYPE, (Object)"nachotype");
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(STR), 80, 10, md);
        Assert.assertEquals((String)"number of docs found", (long)2L, (long)this.tmhits.size());
        Assert.assertEquals((String)"1st match", (Object)STR, (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
        Assert.assertEquals((String)"2nd match", (Object)"watch for the killer rabbit", (Object)this.tmhits.get(1).getTu().getSource().getContent().toText());
    }

    @Test
    public void searchFuzzyScoreSortNoFuzzyThreshold() throws Exception {
        PensieveWriter writer = this.getWriter();
        String[] testStrings = new String[]{STR, "watch out for the killer rabbit 1", "watch out for the killer rabbit 2 words", "watch out for the killer rabbit 3 words now"};
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(testStrings[0])), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(testStrings[1])), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(testStrings[2])), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(testStrings[3])), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(STR), 0, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)4L, (long)this.tmhits.size());
        Assert.assertEquals((String)"first match", (Object)testStrings[0], (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
        Float previous = Float.valueOf(this.tmhits.get(0).getScore());
        for (int i = 1; i < this.tmhits.size(); ++i) {
            Float currentScore = Float.valueOf(this.tmhits.get(i).getScore());
            Assert.assertEquals((String)(i + " match"), (Object)testStrings[i], (Object)this.tmhits.get(i).getTu().getSource().getContent().toText());
            Assert.assertTrue((String)"results should be sorted descending by score", (currentScore.floatValue() < previous.floatValue() ? 1 : 0) != 0);
            previous = currentScore;
        }
    }

    @Test
    public void searchFuzzyEndMatch() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        int numOfIndices = 9;
        this.populateIndex(writer, 9, str, "two");
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(new TextFragment(str), 0, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)9L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactSingleMatch() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        int numOfIndices = 18;
        this.populateIndex(writer, 18, str, "two");
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment(str + 1), null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactSingleMatchWithMetadata() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        int numOfIndices = 18;
        this.populateIndex(writer, 18, str, "two", "ID", "FileORama", "groupie", "singletype");
        writer.close();
        Metadata metadata = new Metadata();
        metadata.put((Object)MetadataType.ID, (Object)"ID1");
        this.tmhits = this.seeker.searchExact(new TextFragment(str), metadata);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactMultipleMatchesWithMetadata() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        int numOfIndices = 18;
        this.populateIndex(writer, 18, str, "two", "ID", "FileORama", "groupie", "singletype");
        this.populateIndex(writer, 5, str, "two", "ID", "ORama", "groupx", "nachotype");
        writer.close();
        Metadata metadata = new Metadata();
        metadata.put((Object)MetadataType.TYPE, (Object)"nachotype");
        this.tmhits = this.seeker.searchExact(new TextFragment(str), metadata);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactMultipleMatches() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        for (int i = 0; i < 5; ++i) {
            writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        }
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment(str), null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactDifferentStopWords() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch out for the the killer rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment(str), null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchNoHits() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment(str), null);
        Assert.assertNotNull(this.tmhits);
        Assert.assertEquals((String)"number of docs found", (long)0L, (long)this.tmhits.size());
    }

    @Test
    public void searchNoScoreOver100() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = "Consistent with 48 C.F.R. \u00a712.212 or 48 C.F.R. \u00a7\u00a7227.7202-1 through 227.7202-4, as applicable, the Commercial Computer Software and Commercial Computer Software Documentation are being licensed to U.S. Government end users (a) only as Commercial Items and (b) with only those rights as are granted to all other end users pursuant to the terms and conditions herein.";
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch out for the the killer rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment(str), null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
        Assert.assertTrue((String)"score over 100%", (this.tmhits.get(0).getScore() == 100.0f ? 1 : 0) != 0);
    }

    @Test
    public void searchExactDifferentCases() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = "watch Out for The killEr rabbit";
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch out for the the killer rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment(str), null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactDifferentOrder() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("watch out for the the killer rabbit")), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchExact(new TextFragment("killer rabbit the for out watch"), null);
        Assert.assertEquals((String)"number of docs found", (long)0L, (long)this.tmhits.size());
    }

    @Test
    public void searchExactWithCodes() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        TextFragment frag = new TextFragment("watch out for ");
        frag.append(TextFragment.TagType.OPENING, "b", "<b>");
        frag.append("the killer");
        frag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        frag.append(" rabbit");
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), frag), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchExact(frag, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
        Assert.assertEquals((Object)"watch out for <b>the killer</b> rabbit", (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
    }

    @Test
    public void searchExactWithCodesQueryNoCodes() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str = STR;
        TextFragment frag = new TextFragment("watch out for ");
        frag.append(TextFragment.TagType.OPENING, "b", "<b>");
        frag.append("the killer");
        frag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        frag.append(" rabbit");
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), frag), TARGET));
        writer.close();
        frag = new TextFragment(STR);
        this.tmhits = this.seeker.searchExact(frag, null);
        Assert.assertEquals((String)"number of docs found", (long)1L, (long)this.tmhits.size());
        Assert.assertEquals((Object)STR, (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
    }

    @Test
    public void searchFuzzyWithCodes() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str1 = STR;
        String str2 = "something very different";
        TextFragment frag = new TextFragment("watch out for ");
        frag.append(TextFragment.TagType.OPENING, "b", "<b>");
        frag.append("the killer");
        frag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        frag.append(" rabbit");
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str1)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str2)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), frag), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchFuzzy(frag, 5, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)2L, (long)this.tmhits.size());
        Assert.assertEquals((Object)"watch out for <b>the killer</b> rabbit", (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
        Assert.assertEquals((Object)STR, (Object)this.tmhits.get(1).getTu().getSource().getContent().toText());
    }

    @Test
    public void searchSimpleConcordance() throws Exception {
        PensieveWriter writer = this.getWriter();
        String str1 = STR;
        String str2 = "something very different about killer rabbits";
        TextFragment frag = new TextFragment("watch out for ");
        frag.append(TextFragment.TagType.OPENING, "b", "<b>");
        frag.append("the killer");
        frag.append(TextFragment.TagType.CLOSING, "b", "</b>");
        frag.append(" rabbit");
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str1)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(str2)), TARGET));
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), frag), TARGET));
        writer.close();
        this.tmhits = this.seeker.searchSimpleConcordance(" killer rabbits ", 70, 10, null);
        Assert.assertEquals((String)"number of docs found", (long)3L, (long)this.tmhits.size());
        Assert.assertEquals((Object)str2, (Object)this.tmhits.get(0).getTu().getSource().getContent().toText());
    }

    @Test
    public void getTranslationUnitFields() throws Exception {
        String source = STR;
        String target = "j";
        LocaleId targetLang = LocaleId.fromString((String)"KR");
        LocaleId sourceLang = LocaleId.fromString((String)"EN");
        Document doc = new Document();
        doc.add((Fieldable)new Field(TranslationUnitField.SOURCE_EXACT.name(), STR, Field.Store.NO, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.SOURCE.name(), STR, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.SOURCE_LANG.name(), sourceLang.toString(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.TARGET.name(), "j", Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.TARGET_LANG.name(), targetLang.toString(), Field.Store.YES, Field.Index.ANALYZED));
        TranslationUnit tu = this.seeker.getTranslationUnit(doc);
        Assert.assertEquals((String)"source field", (Object)STR, (Object)tu.getSource().getContent().toText());
        Assert.assertEquals((String)"source lang", (Object)sourceLang, (Object)tu.getSource().getLanguage());
        Assert.assertEquals((String)"target field", (Object)"j", (Object)tu.getTarget().getContent().toText());
        Assert.assertEquals((String)"target lang", (Object)targetLang, (Object)tu.getTarget().getLanguage());
    }

    @Test
    public void getTranslationUnitMeta() throws Exception {
        String source = STR;
        String target = "j";
        String id = "1";
        String filename = "fname";
        String groupname = "gname";
        String type = "typeA";
        String targetLang = "KR";
        String sourceLang = "EN";
        Document doc = new Document();
        doc.add((Fieldable)new Field(TranslationUnitField.SOURCE.name(), STR, Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.SOURCE_LANG.name(), "EN", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.TARGET.name(), "j", Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(TranslationUnitField.TARGET_LANG.name(), "KR", Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(MetadataType.ID.fieldName(), "1", Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(MetadataType.FILE_NAME.fieldName(), "fname", Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(MetadataType.GROUP_NAME.fieldName(), "gname", Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(MetadataType.TYPE.fieldName(), "typeA", Field.Store.YES, Field.Index.NOT_ANALYZED));
        TranslationUnit tu = this.seeker.getTranslationUnit(doc);
        Assert.assertEquals((String)"id field", (Object)"1", (Object)tu.getMetadata().get((Object)MetadataType.ID));
        Assert.assertEquals((String)"filename field", (Object)"fname", (Object)tu.getMetadata().get((Object)MetadataType.FILE_NAME));
        Assert.assertEquals((String)"groupname field", (Object)"gname", (Object)tu.getMetadata().get((Object)MetadataType.GROUP_NAME));
        Assert.assertEquals((String)"type field", (Object)"typeA", (Object)tu.getMetadata().get((Object)MetadataType.TYPE));
    }

    PensieveWriter getWriter() throws Exception {
        return new PensieveWriter(DIR, true);
    }

    void populateIndex(PensieveWriter writer, int numOfEntries, String source, String target) throws Exception {
        for (int i = 0; i < numOfEntries; ++i) {
            writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(source + i)), new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment(target))));
        }
        writer.indexTranslationUnit(new TranslationUnit(new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("something that in no way should ever match")), new TranslationUnitVariant(LocaleId.fromString((String)"EN"), new TextFragment("unittesttarget"))));
    }

    void populateIndex(PensieveWriter writer, int numOfEntries, String source, String target, String id, String filename, String groupname, String type) throws Exception {
        for (int i = 0; i < numOfEntries; ++i) {
            writer.indexTranslationUnit(Helper.createTU(LocaleId.fromString((String)"EN"), LocaleId.fromString((String)"KR"), source, target, id + i, filename, groupname, type));
        }
    }
}

