/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.seeker;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.search.lucene.analysis.NgramAnalyzer;
import net.sf.okapi.lib.search.lucene.query.SimpleConcordanceFuzzyQuery;
import net.sf.okapi.lib.search.lucene.query.TmFuzzyQuery;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitField;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PensieveSeeker
implements ITmSeeker,
Iterable<TranslationUnit> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final NgramAnalyzer defaultFuzzyAnalyzer = new NgramAnalyzer(Locale.ENGLISH, 4);
    private static final float MAX_HITS_RATIO = 0.01f;
    private static final int MIN_MAX_HITS = 500;
    private static float SINGLE_CODE_DIFF_PENALTY = 0.5f;
    private static float WHITESPACE_OR_CASE_PENALTY = 2.0f;
    private int maxTopDocuments;
    private Directory indexDir;
    private IndexReader indexReader;
    private IndexWriter indexWriter;
    private IndexSearcher indexSearcher;
    private boolean nrtMode;

    public PensieveSeeker(Directory indexDir) throws IllegalArgumentException {
        if (indexDir == null) {
            throw new IllegalArgumentException("'indexDir' cannot be null!");
        }
        this.indexDir = indexDir;
        this.nrtMode = false;
    }

    public PensieveSeeker(IndexWriter indexWriter) throws IllegalArgumentException {
        if (indexWriter == null) {
            throw new IllegalArgumentException("'indexWriter' cannot be null!");
        }
        this.indexWriter = indexWriter;
        this.nrtMode = true;
    }

    @Override
    public Iterator<TranslationUnit> iterator() {
        return new TranslationUnitIterator();
    }

    public Directory getIndexDir() {
        return this.indexDir;
    }

    private BooleanQuery createQuery(Metadata metadata) {
        return this.createQuery(metadata, null);
    }

    private BooleanQuery createQuery(Metadata metadata, Query q) {
        BooleanQuery bQuery = new BooleanQuery();
        if (q != null) {
            bQuery.add(q, BooleanClause.Occur.MUST);
        }
        if (metadata != null) {
            for (MetadataType type : metadata.keySet()) {
                bQuery.add((Query)new TermQuery(new Term(type.fieldName(), (String)metadata.get((Object)type))), BooleanClause.Occur.MUST);
            }
        }
        return bQuery;
    }

    TranslationUnit getTranslationUnit(Document doc) {
        TranslationUnit tu = new TranslationUnit(new TranslationUnitVariant(this.getLocaleValue(doc, TranslationUnitField.SOURCE_LANG), new TextFragment(this.getFieldValue(doc, TranslationUnitField.SOURCE))), new TranslationUnitVariant(this.getLocaleValue(doc, TranslationUnitField.TARGET_LANG), new TextFragment(this.getFieldValue(doc, TranslationUnitField.TARGET))));
        for (MetadataType type : MetadataType.values()) {
            tu.setMetadataValue(type, this.getFieldValue(doc, type));
        }
        return tu;
    }

    String getFieldValue(Document doc, TranslationUnitField field) {
        return this.getFieldValue(doc, field.name());
    }

    String getFieldValue(Document doc, MetadataType type) {
        return this.getFieldValue(doc, type.fieldName());
    }

    String getFieldValue(Document doc, String fieldName) {
        String fieldValue = null;
        Field tempField = doc.getField(fieldName);
        if (tempField != null) {
            fieldValue = tempField.stringValue();
        }
        return fieldValue;
    }

    LocaleId getLocaleValue(Document doc, TranslationUnitField field) {
        return LocaleId.fromString((String)this.getFieldValue(doc, field.name()));
    }

    protected IndexSearcher createIndexSearcher() throws CorruptIndexException, IOException {
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
        }
        return new IndexSearcher(this.openIndexReader());
    }

    protected IndexSearcher getIndexSearcher() throws CorruptIndexException, IOException {
        if (this.indexSearcher != null && !this.nrtMode) {
            return this.indexSearcher;
        }
        this.indexSearcher = this.createIndexSearcher();
        return this.indexSearcher;
    }

    protected IndexReader openIndexReader() throws CorruptIndexException, IOException {
        if (this.indexReader == null) {
            this.indexReader = this.nrtMode ? IndexReader.open((IndexWriter)this.indexWriter, (boolean)true) : IndexReader.open((Directory)this.indexDir, (boolean)true);
            this.maxTopDocuments = (int)((float)this.indexReader.maxDoc() * 0.01f);
            if (this.maxTopDocuments < 500) {
                this.maxTopDocuments = 500;
            }
        } else if (this.nrtMode) {
            this.indexReader = this.indexReader.reopen();
        }
        return this.indexReader;
    }

    private List<TmHit> getTopHits(Query query, Metadata metadata) throws IOException {
        TopScoreDocCollector topCollector;
        IndexSearcher is = this.getIndexSearcher();
        QueryWrapperFilter filter = null;
        int maxHits = 0;
        ArrayList<TmHit> tmHitCandidates = new ArrayList<TmHit>(this.maxTopDocuments);
        if (metadata != null && !metadata.isEmpty()) {
            filter = new QueryWrapperFilter((Query)this.createQuery(metadata));
        }
        do {
            topCollector = TopScoreDocCollector.create((int)(maxHits += this.maxTopDocuments), (boolean)true);
            is.search(query, (Filter)filter, (Collector)topCollector);
        } while (topCollector.getTotalHits() >= maxHits);
        TopDocs topDocs = topCollector.topDocs();
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = topDocs.scoreDocs[i];
            TmHit tmHit = new TmHit();
            tmHit.setDocId(scoreDoc.doc);
            tmHit.setScore(Float.valueOf(scoreDoc.score));
            List tmCodes = Code.stringToCodes((String)this.getFieldValue(this.getIndexSearcher().doc(tmHit.getDocId()), TranslationUnitField.SOURCE_CODES));
            String tmCodedText = this.getFieldValue(this.getIndexSearcher().doc(tmHit.getDocId()), TranslationUnitField.SOURCE_EXACT);
            tmHit.setTu(this.createTranslationUnit(this.getIndexSearcher().doc(tmHit.getDocId()), tmCodedText, tmCodes));
            tmHitCandidates.add(tmHit);
        }
        ArrayList<TmHit> noDups = new ArrayList<TmHit>(new LinkedHashSet(tmHitCandidates));
        return noDups;
    }

    @Override
    public List<TmHit> searchExact(TextFragment query, Metadata metadata) {
        List<TmHit> tmHitCandidates;
        TermQuery termQuery = new TermQuery(new Term(TranslationUnitField.SOURCE_EXACT.name(), query.getCodedText()));
        BooleanQuery bQuery = this.createQuery(metadata, (Query)termQuery);
        try {
            tmHitCandidates = this.getTopHits((Query)bQuery, metadata);
            for (TmHit tmHit : tmHitCandidates) {
                tmHit.setScore(Float.valueOf(100.0f));
                tmHit.setMatchType(MatchType.EXACT);
            }
            Collections.sort(tmHitCandidates);
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not complete query.", (Throwable)e);
        }
        return tmHitCandidates;
    }

    @Override
    public List<TmHit> searchFuzzy(TextFragment query, int threshold, int max, Metadata metadata) {
        if (threshold < 0 || threshold > 100) {
            throw new IllegalArgumentException("");
        }
        float searchThreshold = threshold;
        if (threshold < 0) {
            searchThreshold = 0.0f;
        }
        if (threshold > 100) {
            searchThreshold = 100.0f;
        }
        String queryText = query.getText();
        TokenStream queryTokenStream = defaultFuzzyAnalyzer.tokenStream(TranslationUnitField.SOURCE.name(), (Reader)new StringReader(queryText));
        TermAttribute termAtt = (TermAttribute)queryTokenStream.addAttribute(TermAttribute.class);
        TmFuzzyQuery fQuery = new TmFuzzyQuery(searchThreshold, TranslationUnitField.SOURCE.name());
        try {
            queryTokenStream.reset();
            while (queryTokenStream.incrementToken()) {
                Term t = new Term(TranslationUnitField.SOURCE.name(), termAtt.term());
                fQuery.add(t);
            }
            queryTokenStream.end();
            queryTokenStream.close();
        }
        catch (IOException e) {
            throw new OkapiIOException(e.getMessage(), (Throwable)e);
        }
        return this.getFuzzyHits(max, searchThreshold, (Query)fQuery, query, metadata);
    }

    @Override
    public List<TmHit> searchSimpleConcordance(String query, int threshold, int max, Metadata metadata) {
        if (threshold < 0 || threshold > 100) {
            throw new IllegalArgumentException("");
        }
        float searchThreshold = threshold;
        if (threshold < 0) {
            searchThreshold = 0.0f;
        }
        if (threshold > 100) {
            searchThreshold = 100.0f;
        }
        TokenStream queryTokenStream = defaultFuzzyAnalyzer.tokenStream(TranslationUnitField.SOURCE.name(), (Reader)new StringReader(query));
        TermAttribute termAtt = (TermAttribute)queryTokenStream.addAttribute(TermAttribute.class);
        SimpleConcordanceFuzzyQuery fQuery = new SimpleConcordanceFuzzyQuery(searchThreshold);
        try {
            queryTokenStream.reset();
            while (queryTokenStream.incrementToken()) {
                Term t = new Term(TranslationUnitField.SOURCE.name(), termAtt.term());
                fQuery.add(t);
            }
            queryTokenStream.end();
            queryTokenStream.close();
        }
        catch (IOException e) {
            throw new OkapiIOException(e.getMessage(), (Throwable)e);
        }
        return this.getConcordanceHits(max, (Query)fQuery, query, metadata);
    }

    List<TmHit> getFuzzyHits(int max, float threshold, Query query, TextFragment queryFrag, Metadata metadata) {
        List<TmHit> tmHitCandidates;
        LinkedList<TmHit> tmHitsToRemove = new LinkedList<TmHit>();
        List queryCodes = queryFrag.getCodes();
        try {
            tmHitCandidates = this.getTopHits(query, metadata);
            for (TmHit tmHit : tmHitCandidates) {
                List tmCodes = Code.stringToCodes((String)this.getFieldValue(this.getIndexSearcher().doc(tmHit.getDocId()), TranslationUnitField.SOURCE_CODES));
                String tmCodedText = this.getFieldValue(this.getIndexSearcher().doc(tmHit.getDocId()), TranslationUnitField.SOURCE_EXACT);
                String sourceTextOnly = TextFragment.getText((String)tmCodedText);
                MatchType matchType = MatchType.FUZZY;
                Float score = Float.valueOf(tmHit.getScore());
                tmHit.setCodeMismatch(false);
                if (queryCodes.size() != tmCodes.size()) {
                    tmHit.setCodeMismatch(true);
                }
                if (score.floatValue() >= 100.0f && tmCodedText.equals(queryFrag.getCodedText())) {
                    matchType = MatchType.EXACT;
                } else if (score.floatValue() >= 100.0f && sourceTextOnly.equals(queryFrag.getText())) {
                    matchType = MatchType.EXACT_TEXT_ONLY;
                } else if (score.floatValue() >= 100.0f) {
                    score = Float.valueOf(score.floatValue() - WHITESPACE_OR_CASE_PENALTY);
                }
                if (queryCodes.size() != tmCodes.size()) {
                    score = Float.valueOf(score.floatValue() - SINGLE_CODE_DIFF_PENALTY * Math.abs((float)queryCodes.size() - (float)tmCodes.size()));
                }
                tmHit.setScore(score);
                tmHit.setMatchType(matchType);
                if (!(tmHit.getScore() < threshold)) continue;
                tmHitsToRemove.add(tmHit);
            }
            tmHitCandidates.removeAll(tmHitsToRemove);
            Collections.sort(tmHitCandidates);
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not complete query.", (Throwable)e);
        }
        int lastHitIndex = max;
        if (max >= tmHitCandidates.size()) {
            lastHitIndex = tmHitCandidates.size();
        }
        return tmHitCandidates.subList(0, lastHitIndex);
    }

    List<TmHit> getConcordanceHits(int max, Query query, String queryFrag, Metadata metadata) {
        List<TmHit> tmHitCandidates;
        try {
            tmHitCandidates = this.getTopHits(query, metadata);
            for (TmHit tmHit : tmHitCandidates) {
                tmHit.setScore(Float.valueOf(tmHit.getScore()));
                tmHit.setMatchType(MatchType.CONCORDANCE);
            }
            Collections.sort(tmHitCandidates);
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not complete query.", (Throwable)e);
        }
        int lastHitIndex = max;
        if (max >= tmHitCandidates.size()) {
            lastHitIndex = tmHitCandidates.size();
        }
        return tmHitCandidates.subList(0, lastHitIndex);
    }

    private TranslationUnit createTranslationUnit(Document doc, String srcCodedText, List<Code> srcCodes) {
        TextFragment frag = new TextFragment();
        frag.setCodedText(srcCodedText, srcCodes, false);
        TranslationUnitVariant srcTuv = new TranslationUnitVariant(this.getLocaleValue(doc, TranslationUnitField.SOURCE_LANG), frag);
        frag = new TextFragment();
        List codes = Code.stringToCodes((String)this.getFieldValue(doc, TranslationUnitField.TARGET_CODES));
        String codedText = this.getFieldValue(doc, TranslationUnitField.TARGET);
        frag.setCodedText(codedText == null ? "" : codedText, codes, false);
        TranslationUnitVariant trgTuv = new TranslationUnitVariant(this.getLocaleValue(doc, TranslationUnitField.TARGET_LANG), frag);
        TranslationUnit tu = new TranslationUnit(srcTuv, trgTuv);
        for (MetadataType type : MetadataType.values()) {
            tu.setMetadataValue(type, this.getFieldValue(doc, type));
        }
        return tu;
    }

    private TranslationUnit createTranslationUnit(Document doc) {
        TextFragment frag = new TextFragment();
        List codes = Code.stringToCodes((String)this.getFieldValue(doc, TranslationUnitField.SOURCE_CODES));
        frag.setCodedText(this.getFieldValue(doc, TranslationUnitField.SOURCE_EXACT), codes, false);
        TranslationUnitVariant srcTuv = new TranslationUnitVariant(this.getLocaleValue(doc, TranslationUnitField.SOURCE_LANG), frag);
        frag = new TextFragment();
        codes = Code.stringToCodes((String)this.getFieldValue(doc, TranslationUnitField.TARGET_CODES));
        String codedText = this.getFieldValue(doc, TranslationUnitField.TARGET);
        frag.setCodedText(codedText == null ? "" : codedText, codes, false);
        TranslationUnitVariant trgTuv = new TranslationUnitVariant(this.getLocaleValue(doc, TranslationUnitField.TARGET_LANG), frag);
        TranslationUnit tu = new TranslationUnit(srcTuv, trgTuv);
        for (MetadataType type : MetadataType.values()) {
            tu.setMetadataValue(type, this.getFieldValue(doc, type));
        }
        return tu;
    }

    @Override
    public void close() {
        try {
            if (this.indexSearcher != null) {
                this.indexSearcher.close();
            }
            if (this.indexReader != null) {
                this.indexReader.close();
            }
        }
        catch (IOException e) {
            this.LOGGER.warn("Exception closing Pensieve index.", (Throwable)e);
        }
    }

    private class TranslationUnitIterator
    implements Iterator<TranslationUnit> {
        private int currentIndex;
        private int maxIndex;
        private IndexReader ir;

        TranslationUnitIterator() {
            try {
                this.ir = PensieveSeeker.this.openIndexReader();
            }
            catch (CorruptIndexException cie) {
                throw new OkapiIOException(cie.getMessage(), (Throwable)cie);
            }
            catch (IOException ioe) {
                throw new OkapiIOException(ioe.getMessage(), (Throwable)ioe);
            }
            this.currentIndex = 0;
            this.maxIndex = this.ir.maxDoc();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.maxIndex;
        }

        @Override
        public TranslationUnit next() {
            TranslationUnit tu = null;
            if (this.hasNext()) {
                try {
                    tu = PensieveSeeker.this.createTranslationUnit(this.ir.document(this.currentIndex++));
                }
                catch (CorruptIndexException cie) {
                    throw new OkapiIOException(cie.getMessage(), (Throwable)cie);
                }
                catch (IOException ioe) {
                    throw new OkapiIOException(ioe.getMessage(), (Throwable)ioe);
                }
            }
            return tu;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Will not support remove method - Please remove items via ITmSeeker interface");
        }
    }
}

