/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.writer;

import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.tm.pensieve.Helper;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.apache.lucene.store.FSDirectory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TmWriterFactoryTest {
    @Test
    public void createFileBasedTmWriter() {
        PensieveWriter writer = (PensieveWriter)TmWriterFactory.createFileBasedTmWriter((String)"target/test-classes/", (boolean)true);
        Assert.assertTrue((String)"indexDir should be filebased", (boolean)(writer.getIndexWriter().getDirectory() instanceof FSDirectory));
    }

    @Test(expected=OkapiIOException.class)
    public void createFileBasedTmWriterNotDirectory() {
        TmWriterFactory.createFileBasedTmWriter((String)"pom.xml", (boolean)true);
    }

    @Test(expected=OkapiIOException.class)
    public void createFileBasedTmWriterBadDirectory() {
        TmWriterFactory.createFileBasedTmWriter((String)"prettymuch/a/non/existent/directory", (boolean)true);
    }

    @Test(expected=OkapiIOException.class)
    public void createFileBasedTmWriterNullDirectory() {
        TmWriterFactory.createFileBasedTmWriter(null, (boolean)true);
    }

    @Test
    public void stupidCoberturaPrivateConstructorTest() throws Exception {
        Helper.genericTestConstructor(TmWriterFactory.class);
    }
}

