/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxImporter;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class OkapiTmxImporterTest {
    URI sampleTMX;
    OkapiTmxImporter tmxImporter;
    ITmWriter mockTmWriter;
    IFilter mockFilter;
    LocaleId locEN = LocaleId.fromString((String)"EN");
    LocaleId locFR = LocaleId.fromString((String)"FR");
    LocaleId locIT = LocaleId.fromString((String)"IT");

    @Before
    public void setUp() throws URISyntaxException, IOException {
        this.mockTmWriter = (ITmWriter)Mockito.mock(ITmWriter.class);
        String[][] properties = new String[][]{{"tuid", "helloid"}, {"datatype", "plaintext"}, {"Txt::FileName", "StringInfoForTest3.info"}, {"Txt::GroupName", "APCCalibrateTimeoutAction0"}};
        this.mockFilter = (IFilter)Mockito.mock(IFilter.class);
        Mockito.when((Object)this.mockFilter.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)this.mockFilter.next()).thenReturn((Object)this.createEvent("1", "hello", "ciao", this.locIT, properties)).thenReturn((Object)this.createEvent("2", "world", "mondo", this.locIT, null)).thenReturn((Object)new Event(EventType.DOCUMENT_PART, (IResource)new TextUnit("holy cow")));
        this.sampleTMX = new URI("test.tmx");
        this.tmxImporter = new OkapiTmxImporter(this.locEN, this.mockFilter);
    }

    @Test
    public void importTMXMetadataWithData() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locIT, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"ID", (Object)"helloid", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getMetadata().get((Object)MetadataType.ID));
        Assert.assertEquals((String)"TYPE", (Object)"plaintext", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getMetadata().get((Object)MetadataType.TYPE));
        Assert.assertEquals((String)"FILE_NAME", (Object)"StringInfoForTest3.info", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getMetadata().get((Object)MetadataType.FILE_NAME));
        Assert.assertEquals((String)"GROUP_NAME", (Object)"APCCalibrateTimeoutAction0", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getMetadata().get((Object)MetadataType.GROUP_NAME));
        Assert.assertEquals((String)"# of metadata", (long)0L, (long)((TranslationUnit)tuCapture.getAllValues().get(1)).getMetadata().size());
    }

    @Test
    public void importTMXMetadataWithoutData() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locIT, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"# of metadata", (long)0L, (long)((TranslationUnit)tuCapture.getAllValues().get(1)).getMetadata().size());
    }

    @Test
    public void importTmxNullFile() throws IOException {
        String errMsg = null;
        try {
            this.tmxImporter.importTmx(null, this.locFR, this.mockTmWriter);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'tmxUri' was not set", (Object)errMsg);
    }

    @Test
    public void importTmxNullTarget() throws IOException {
        String errMsg = null;
        try {
            this.tmxImporter.importTmx(this.sampleTMX, null, this.mockTmWriter);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'targetLang' was not set", (Object)errMsg);
    }

    @Test
    public void importTmxNullTmWriter() throws IOException {
        String errMsg = null;
        try {
            this.tmxImporter.importTmx(this.sampleTMX, this.locFR, null);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'tmWriter' was not set", (Object)errMsg);
    }

    @Test
    public void constructorEmptySourceLang() {
        String errMsg = null;
        try {
            new OkapiTmxImporter(LocaleId.EMPTY, this.mockFilter);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'sourceLang' must be set", (Object)errMsg);
    }

    @Test
    public void constructorEmptyFilter() {
        String errMsg = null;
        try {
            new OkapiTmxImporter(this.locEN, null);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'filter' must be set", (Object)errMsg);
    }

    @Test(expected=IllegalArgumentException.class)
    public void importTMXEmptyTargetLang() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, LocaleId.EMPTY, this.mockTmWriter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void importTMXNullTargetLang() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, null, this.mockTmWriter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void importTMXNullTMWriter() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locFR, null);
    }

    @Test
    public void importTmxExistingLang() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locIT, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"number of TUs", (long)2L, (long)tuCapture.getAllValues().size());
    }

    @Test
    public void importTmxNonExistingLang() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locFR, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"number of TUs", (long)2L, (long)tuCapture.getAllValues().size());
        Assert.assertNull((String)"targets content should be null", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getTarget().getContent());
        Assert.assertEquals((String)"target lang", (Object)this.locFR, (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getTarget().getLanguage());
    }

    @Test
    public void sourceAndTargetForExistingLang() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locIT, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"first match source", (Object)"hello", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getSource().getContent().toText());
        Assert.assertEquals((String)"first match target", (Object)"ciao", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getTarget().getContent().toText());
    }

    @Test
    public void sourceAndTargetForNonExistingLang() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locFR, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"first match source", (Object)"hello", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getSource().getContent().toText());
        Assert.assertNull((String)"target for non-existant language should be null", (Object)((TranslationUnit)tuCapture.getAllValues().get(0)).getTarget().getContent());
    }

    @Test
    public void importTMXDocCount() throws IOException {
        this.tmxImporter.importTmx(this.sampleTMX, this.locEN, this.mockTmWriter);
        ArgumentCaptor<TranslationUnit> tuCapture = this.verifyIndexTU();
        Assert.assertEquals((String)"entries indexed", (long)2L, (long)tuCapture.getAllValues().size());
    }

    private ArgumentCaptor<TranslationUnit> verifyIndexTU() throws IOException {
        ArgumentCaptor tuCapture = ArgumentCaptor.forClass(TranslationUnit.class);
        ((ITmWriter)Mockito.verify((Object)this.mockTmWriter, (VerificationMode)Mockito.times((int)2))).indexTranslationUnit((TranslationUnit)tuCapture.capture());
        return tuCapture;
    }

    private Event createEvent(String id, String source, String target, LocaleId targetLang, String[][] properties) {
        TextUnit tu = new TextUnit(id, source);
        tu.setTargetContent(targetLang, new TextFragment(target));
        if (properties != null) {
            for (String[] prop : properties) {
                tu.setProperty(new Property(prop[0], prop[1]));
            }
        }
        return new Event(EventType.TEXT_UNIT, (IResource)tu);
    }
}

