/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.tm.pensieve.Helper;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxExporter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class OkapiTmxExporterTest {
    URI sampleTMX;
    OkapiTmxExporter handler;
    TMXWriter mockTmxWriter;
    Iterator<TranslationUnit> mockIterator;
    PensieveSeeker mockSeeker;
    LocaleId locEN = LocaleId.fromString((String)"en");
    LocaleId locFR = LocaleId.fromString((String)"fr");
    LocaleId locKR = LocaleId.fromString((String)"kr");
    LocaleId locProps = LocaleId.fromString((String)"Props");
    ArgumentCaptor<ITextUnit> tuCapture;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        this.tuCapture = ArgumentCaptor.forClass(ITextUnit.class);
        this.mockIterator = (Iterator)Mockito.mock(Iterator.class);
        this.mockTmxWriter = (TMXWriter)Mockito.mock(TMXWriter.class);
        this.sampleTMX = new URI("test.tmx");
        this.handler = new OkapiTmxExporter();
        this.mockSeeker = (PensieveSeeker)Mockito.mock(PensieveSeeker.class);
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        TranslationUnit tuWithMetadata = Helper.createTU(this.locEN, this.locProps, "props_source", "props_target", "props_sourceid");
        tuWithMetadata.setMetadataValue(MetadataType.GROUP_NAME, "PropsGroupName");
        tuWithMetadata.setMetadataValue(MetadataType.FILE_NAME, "PropsFileName");
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)Helper.createTU(this.locEN, this.locFR, "source", "target", "sourceid")).thenReturn((Object)Helper.createTU(this.locEN, this.locFR, "source2", "target2", "sourceid2")).thenReturn((Object)Helper.createTU(this.locEN, this.locKR, "kr_source", "kr_target", "kr_sourceid")).thenReturn((Object)tuWithMetadata).thenReturn(null);
        Mockito.when((Object)this.mockSeeker.iterator()).thenReturn(this.mockIterator);
    }

    @Test
    public void exportTmxBehavior() throws IOException {
        this.handler.exportTmx(this.locEN, this.locFR, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter)).writeStartDocument(this.locEN, this.locFR, "pensieve", "0.0.1", "sentence", "pensieve", "unknown");
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter, (VerificationMode)Mockito.times((int)2))).writeTUFull((ITextUnit)Matchers.anyObject());
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter)).writeEndDocument();
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter)).close();
    }

    @Test
    public void exportTmxTextUnitContentNoProps() throws IOException {
        this.handler.exportTmx(this.locEN, this.locFR, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter, (VerificationMode)Mockito.times((int)2))).writeTUFull((ITextUnit)this.tuCapture.capture());
        Assert.assertEquals((String)"source of first tu written", (Object)"source", (Object)((ITextUnit)this.tuCapture.getAllValues().get(0)).getSource().getFirstContent().toText());
        Assert.assertEquals((String)"target of first tu written", (Object)"target", (Object)((ITextUnit)this.tuCapture.getAllValues().get(0)).getTarget(this.locFR).getFirstContent().toText());
        Assert.assertEquals((String)"target of first tu written", (Object)"sourceid", (Object)((ITextUnit)this.tuCapture.getAllValues().get(0)).getName());
        Assert.assertEquals((String)"source of second tu written", (Object)"source2", (Object)((ITextUnit)this.tuCapture.getAllValues().get(1)).getSource().getFirstContent().toText());
        Assert.assertEquals((String)"target of second tu written", (Object)"target2", (Object)((ITextUnit)this.tuCapture.getAllValues().get(1)).getTarget(this.locFR).getFirstContent().toText());
        Assert.assertEquals((String)"target of second tu written", (Object)"sourceid2", (Object)((ITextUnit)this.tuCapture.getAllValues().get(1)).getName());
    }

    @Test
    public void exportTmxTextUnitContentWithProps() throws IOException {
        this.handler.exportTmx(this.locEN, this.locProps, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter, (VerificationMode)Mockito.times((int)1))).writeTUFull((ITextUnit)this.tuCapture.capture());
        ITextUnit capturedTU = (ITextUnit)this.tuCapture.getValue();
        Assert.assertEquals((String)"source of first tu written", (Object)"props_source", (Object)capturedTU.getSource().getFirstContent().toText());
        Assert.assertEquals((String)"target of first tu written", (Object)"props_target", (Object)capturedTU.getTarget(this.locProps).getFirstContent().toText());
        Assert.assertEquals((String)"target of first tu written", (Object)"props_sourceid", (Object)capturedTU.getName());
        Assert.assertEquals((String)"groupname metadata", (Object)"PropsGroupName", (Object)capturedTU.getProperty("Txt::GroupName").getValue());
        Assert.assertEquals((String)"filename metadata", (Object)"PropsFileName", (Object)capturedTU.getProperty("Txt::FileName").getValue());
        Assert.assertEquals((String)"metadata size", (long)2L, (long)capturedTU.getPropertyNames().size());
    }

    @Test
    public void exportTmxAllTargetLang() throws IOException {
        this.handler.exportTmx(this.locEN, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter, (VerificationMode)Mockito.times((int)4))).writeTUFull((ITextUnit)Matchers.anyObject());
    }

    @Test
    public void exportTmxNoMatchingSourceLang() throws IOException {
        this.handler.exportTmx(this.locKR, this.locFR, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter, (VerificationMode)Mockito.never())).writeTUFull((ITextUnit)Matchers.anyObject());
    }

    @Test
    public void exportTmxSpecificTargetLang() throws IOException {
        this.handler.exportTmx(this.locEN, this.locKR, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        ((TMXWriter)Mockito.verify((Object)this.mockTmxWriter, (VerificationMode)Mockito.times((int)1))).writeTUFull((ITextUnit)this.tuCapture.capture());
        Assert.assertEquals((String)"target of first tu written", (Object)"kr_sourceid", (Object)((ITextUnit)this.tuCapture.getValue()).getName());
    }

    @Test
    public void exportTmxSeekerNull() throws IOException {
        String errMsg = null;
        try {
            this.handler.exportTmx(LocaleId.EMPTY, LocaleId.EMPTY, null, this.mockTmxWriter);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'tmSeeker' was not set", (Object)errMsg);
    }

    @Test
    public void exportTmxWriterNull() throws IOException {
        String errMsg = null;
        try {
            this.handler.exportTmx(LocaleId.EMPTY, LocaleId.EMPTY, (ITmSeeker)this.mockSeeker, null);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'tmxWriter' was not set", (Object)errMsg);
    }

    @Test
    public void exportTmxSourceLangNull() throws IOException {
        String errMsg = null;
        try {
            this.handler.exportTmx(null, LocaleId.EMPTY, (ITmSeeker)this.mockSeeker, this.mockTmxWriter);
        }
        catch (IllegalArgumentException iae) {
            errMsg = iae.getMessage();
        }
        Assert.assertEquals((String)"Error message", (Object)"'sourceLang' was not set", (Object)errMsg);
    }
}

