/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.sf.okapi.common.BOMAwareInputStream;
import org.junit.Assert;
import org.slf4j.Logger;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;

final class XmlDocumentsComparison {
    private final Path inputRoot;
    private final Path outputRoot;
    private final Logger logger;

    XmlDocumentsComparison(Path inputRoot, Path outputRoot, Logger logger) {
        this.inputRoot = inputRoot;
        this.outputRoot = outputRoot;
        this.logger = logger;
    }

    void compareWithGold(String directory, String outputFileName, String goldFileName) throws Exception {
        File gold = this.inputRoot.resolve(goldFileName).toFile();
        File out = this.outputRoot.resolve(directory).resolve(outputFileName).toFile();
        BOMAwareInputStream goldS = new BOMAwareInputStream((InputStream)new FileInputStream(gold), "UTF-8");
        goldS.detectEncoding();
        BOMAwareInputStream outS = new BOMAwareInputStream((InputStream)new FileInputStream(out), "UTF-8");
        outS.detectEncoding();
        try (InputStreamReader goldR = new InputStreamReader((InputStream)goldS, StandardCharsets.UTF_8);
             InputStreamReader outR = new InputStreamReader((InputStream)outS, StandardCharsets.UTF_8);){
            this.compareXML(goldR, outR, gold.getAbsolutePath(), out.getAbsolutePath());
        }
    }

    private void compareXML(Reader goldR, Reader outR, String goldName, String outName) throws Exception {
        Diff diff = DiffBuilder.compare((Object)Input.fromReader((Reader)goldR)).withTest((Object)Input.fromReader((Reader)outR)).checkForIdentical().build();
        if (diff.hasDifferences()) {
            this.logger.warn("Differences between {} and {}:", (Object)goldName, (Object)outName);
            for (Difference d : diff.getDifferences()) {
                this.logger.warn("- {}", (Object)d.toString());
            }
            Assert.fail();
        }
    }
}

