/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.Util;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitter;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitterParameters;
import net.sf.okapi.steps.xliffsplitter.XmlDocumentsComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class XliffWCSplitterTest {
    private FileLocation root;
    private String splitDir;

    @Before
    public void setUp() throws Exception {
        this.root = FileLocation.fromClass(this.getClass());
        this.splitDir = this.root.out("split-wc").toString() + "/";
        Util.createDirectories((String)this.splitDir);
    }

    @Test
    public void test5Words() throws IOException {
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(5);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = this.root.in("input1.xlf").asInputStream();){
            Util.deleteDirectory((String)this.splitDir, (boolean)true);
            Map res = spltr.process(is, this.splitDir + "output5w", "en-US");
            Assert.assertEquals((long)3L, (long)res.size());
            Assert.assertEquals((long)7L, (long)((Integer)res.get("output5w_PART001.xlf")).intValue());
            Assert.assertEquals((long)8L, (long)((Integer)res.get("output5w_PART002.xlf")).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)res.get("output5w_PART003.xlf")).intValue());
        }
    }

    @Test
    public void test3Words() throws IOException {
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(3);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = this.root.in("input1.xlf").asInputStream();){
            Util.deleteDirectory((String)this.splitDir, (boolean)true);
            Map res = spltr.process(is, this.splitDir + "output3w", "en-US");
            Assert.assertEquals((long)5L, (long)res.size());
            Assert.assertEquals((long)4L, (long)((Integer)res.get("output3w_PART001.xlf")).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)res.get("output3w_PART002.xlf")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)res.get("output3w_PART003.xlf")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)res.get("output3w_PART004.xlf")).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)res.get("output3w_PART005.xlf")).intValue());
        }
    }

    @Test
    public void test9999Words() throws IOException {
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(9999);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = this.root.in("input1.xlf").asInputStream();){
            Util.deleteDirectory((String)this.splitDir, (boolean)true);
            Map res = spltr.process(is, this.splitDir + "output9999w", "en-US");
            Assert.assertEquals((long)1L, (long)res.size());
            Assert.assertEquals((long)15L, (long)((Integer)res.get("output9999w_PART001.xlf")).intValue());
        }
    }

    @Test
    public void contextGroupsCopiedOnSplitting() throws Exception {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Path input = this.root.in("context-group").asPath();
        Path output = Path.of(this.splitDir, new String[0]);
        XliffWCSplitterParameters p = new XliffWCSplitterParameters();
        p.setThreshold(2);
        XliffWCSplitter spltr = new XliffWCSplitter(p);
        try (InputStream is = input.resolve("context-group.xlf").toUri().toURL().openStream();){
            Util.deleteDirectory((String)output.toString(), (boolean)true);
            Map res = spltr.process(is, output + "/out", "en-US");
            Assert.assertEquals((long)3L, (long)res.size());
            Assert.assertEquals((long)2L, (long)((Integer)res.get("out_PART001.xlf")).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)res.get("out_PART002.xlf")).intValue());
        }
        XmlDocumentsComparison dc = new XmlDocumentsComparison(input, output, logger);
        dc.compareWithGold(output.toString(), "out_PART001.xlf", "context-group_PART001.xlf");
        dc.compareWithGold(output.toString(), "out_PART002.xlf", "context-group_PART002.xlf");
    }
}

