/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffJoinerStep;
import net.sf.okapi.steps.xliffsplitter.XmlDocumentsComparison;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class XliffJoinerTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pipeline pipeline;
    private Path inputRoot;
    private Path outputRoot;
    private XliffJoinerStep joiner;

    @Before
    public void setUp() throws Exception {
        this.inputRoot = FileLocation.fromClass(XliffJoinerTest.class).in("").asPath();
        this.outputRoot = FileLocation.fromClass(XliffJoinerTest.class).out("").asPath();
        this.pipeline = new Pipeline();
        this.joiner = new XliffJoinerStep();
        this.pipeline.addStep((IPipelineStep)this.joiner);
    }

    @After
    public void tearDown() throws Exception {
        this.pipeline.destroy();
    }

    @Test
    public void joinXliffWithMultipleInputFiles() throws Exception {
        String[] fileList = this.initialize("to_join", String::compareTo);
        this.runPipeline(fileList);
        XmlDocumentsComparison dc = new XmlDocumentsComparison(this.inputRoot, this.outputRoot, this.logger);
        dc.compareWithGold("to_join", "tasks_Test_SDL_XLIFF_18961_es_ES_xliff_CONCAT.xlf", "tasks_Test_SDL_XLIFF_18961_es_ES_xliff_singleFile_CONCAT.gold.xlf");
    }

    @Test
    public void joinXliffWithSingleFileElement() throws Exception {
        String[] fileList = this.initialize("to_join_large_file", String::compareTo);
        this.runPipeline(fileList);
        XmlDocumentsComparison dc = new XmlDocumentsComparison(this.inputRoot, this.outputRoot, this.logger);
        dc.compareWithGold("to_join_large_file", "400.html_CONCAT.xlf", "400.html_CONCAT.gold.xlf");
    }

    @Test
    public void joinXliffThatWasTriviallySplitIntoOnePart() throws Exception {
        String[] fileList = this.initialize("to_join_singlefile", String::compareTo);
        this.runPipeline(fileList);
        XmlDocumentsComparison dc = new XmlDocumentsComparison(this.inputRoot, this.outputRoot, this.logger);
        dc.compareWithGold("to_join_singlefile", "input1_CONCAT.xlf", "input1.xlf");
    }

    @Test
    public void joinXliffContainingMultipleFileElementsSplitIntoMultipleParts() throws Exception {
        String[] fileList = this.initialize("to_join_multiple_files", String::compareTo);
        this.runPipeline(fileList);
        XmlDocumentsComparison dc = new XmlDocumentsComparison(this.inputRoot, this.outputRoot, this.logger);
        dc.compareWithGold("to_join_multiple_files", "multiple_files_CONCAT.xlf", "multiple_files.xlf");
    }

    @Test
    public void multipleFilesWithCRLFJLineEndingsJoinedTheSameWay() throws Exception {
        String[] fileList = this.initialize("to_join_multiple_files_with_cr_lf", String::compareTo);
        this.runPipeline(fileList);
        XmlDocumentsComparison dc = new XmlDocumentsComparison(this.inputRoot, this.outputRoot, this.logger);
        dc.compareWithGold("to_join_multiple_files_with_cr_lf", "multiple_files_CONCAT.xlf", "multiple_files.xlf");
    }

    private void runPipeline(String[] fileList) throws IOException {
        this.pipeline.startBatch();
        for (String file : fileList) {
            Path inputFile = this.inputRoot.resolve(file);
            Path outputFile = this.outputRoot.resolve(file);
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            this.joiner.setOutputURI(outputFile.toUri());
            this.pipeline.process(new RawDocument(inputFile.toUri(), "UTF-8", LocaleId.ENGLISH));
        }
        this.pipeline.endBatch();
    }

    private String[] initialize(String directory, Comparator<String> c) throws Exception {
        Path testDir = this.inputRoot.resolve(directory);
        String[] testFileList = this.getTestFiles(testDir, ".xlf").toArray(new String[0]);
        Arrays.sort(testFileList, c);
        return testFileList;
    }

    private List<String> getTestFiles(Path testDir, String suffix) {
        File dir = testDir.toFile();
        FilenameFilter filter = (dir1, name) -> name.endsWith(suffix);
        return Arrays.stream(dir.listFiles(filter)).map(f -> testDir.getFileName() + File.separator + f.getName()).collect(Collectors.toList());
    }
}

