/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffSplitterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=XliffSplitterParameters.class)
public class XliffSplitterStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private XliffSplitterParameters params = new XliffSplitterParameters();
    private boolean done = false;
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public String getDescription() {
        return "Split an XLIFF document into separate files for each <file> element. Expects: raw document. Sends back: raw document.";
    }

    public String getName() {
        return "XLIFF Splitter";
    }

    public XliffSplitterParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (XliffSplitterParameters)params;
    }

    protected Event handleStartBatch(Event event) {
        this.done = true;
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        this.done = false;
        return event;
    }

    public boolean isDone() {
        return this.done;
    }

    protected Event handleRawDocument(Event event) {
        XMLEventReader eventReader;
        RawDocument rawDoc = event.getRawDocument();
        if (!this.params.isBigFile()) {
            Source source;
            try {
                source = new Source(rawDoc.getReader());
            }
            catch (IOException e) {
                throw new OkapiIOException("Error creating Jericho Source object", (Throwable)e);
            }
            ArrayList fileElements = new ArrayList(source.getAllElements("file"));
            int insertPosition = ((Element)fileElements.get(0)).getBegin();
            int count = 1;
            for (Element element : fileElements) {
                OutputDocument skeletonDocument = new OutputDocument(source);
                skeletonDocument.remove(fileElements);
                String file = this.params.isUpdateSDLTranslationStatus() ? this.updateTranslationStatus(element.toString()) : element.toString();
                skeletonDocument.insert(insertPosition, (CharSequence)file);
                String original = this.params.getRestoreOriginalNames() ? element.getAttributeValue("original") : null;
                StringBuilder sb = new StringBuilder(Util.getDirectoryName((String)this.outputURI.getPath()) + File.separator);
                if (original != null) {
                    sb.append(original).append(".xlf");
                } else {
                    sb.append(Util.getFilename((String)this.outputURI.getPath(), (boolean)false));
                    sb.append(".").append(count++).append(Util.getExtension((String)this.outputURI.getPath()));
                }
                String filename = sb.toString();
                PrintWriter writer = null;
                try {
                    Util.createDirectories((String)filename);
                    BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(filename));
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));
                    skeletonDocument.writeTo((Writer)writer);
                }
                catch (IOException e) {
                    throw new OkapiIOException((Throwable)e);
                }
                catch (NullPointerException e) {
                    throw new OkapiFileNotFoundException((Throwable)e);
                }
                finally {
                    this.done = true;
                    if (writer == null) continue;
                    writer.close();
                    writer = null;
                }
            }
            return event;
        }
        String outputDir = Util.getDirectoryName((String)this.outputURI.getPath());
        String inputFileName = Util.getFilename((String)rawDoc.getInputURI().getPath(), (boolean)false);
        String inputFileExtension = Util.getExtension((String)rawDoc.getInputURI().getPath());
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(rawDoc.getStream(), "utf-8");
        detector.detectBom();
        String encoding = detector.getEncoding();
        boolean hasUTF8BOM = detector.hasUtf8Bom();
        String lineBreak = detector.getNewlineType().toString();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            if (detector.isAutodetected()) {
                eventReader = inputFactory.createXMLEventReader(rawDoc.getStream(), encoding);
            } else {
                this.logger.info("Encoding could not be auto-detected. Using default encoding: {}", (Object)encoding);
                eventReader = inputFactory.createXMLEventReader(rawDoc.getStream());
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiBadStepInputException((Throwable)e);
        }
        boolean collectBeforeFirstFileElem = true;
        int fileCount = 0;
        ArrayList<XMLEvent> elemsBeforeFirstFileElem = new ArrayList<XMLEvent>();
        while (eventReader.hasNext()) {
            XMLEvent xmlEvent;
            try {
                xmlEvent = eventReader.nextEvent();
            }
            catch (XMLStreamException e) {
                throw new OkapiBadStepInputException((Throwable)e);
            }
            if (xmlEvent.getEventType() == 7) {
                elemsBeforeFirstFileElem.add(xmlEvent);
                elemsBeforeFirstFileElem.add(eventFactory.createSpace(lineBreak));
                continue;
            }
            if (xmlEvent.getEventType() == 1 && xmlEvent.asStartElement().getName().getLocalPart().equals("file")) {
                String outputFileUri = outputDir + File.separator + inputFileName + this.params.getFileMarker() + String.format("%04d", ++fileCount) + inputFileExtension;
                collectBeforeFirstFileElem = false;
                this.writeFilePart(xmlEvent, eventReader, fileCount, outputFileUri, elemsBeforeFirstFileElem, outputFactory, eventFactory, lineBreak, encoding, hasUTF8BOM);
            }
            if (collectBeforeFirstFileElem) {
                elemsBeforeFirstFileElem.add(xmlEvent);
            }
            this.done = true;
        }
        return event;
    }

    private String updateTranslationStatus(String file) {
        Source s = new Source((CharSequence)file);
        OutputDocument outputFile = new OutputDocument(s);
        List segment_metadataElements = s.getAllElements("iws:segment-metadata");
        for (Element segment_metadata : segment_metadataElements) {
            List statusTags = segment_metadata.getAllStartTags("iws:status");
            for (StartTag statusTag : statusTags) {
                Attributes attributes = statusTag.getAttributes();
                Map attributesMap = outputFile.replace(attributes, true);
                attributesMap.put("translation_type", this.params.getTranslationTypeValue());
                attributesMap.put("translation_status", this.params.getTranslationStatusValue());
                attributesMap.remove("target_content");
            }
        }
        return outputFile.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFilePart(XMLEvent startFileEvent, XMLEventReader eventReader, int fileCount, String outputFileUri, ArrayList<XMLEvent> elemsBeforeFirstFileElem, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String lineBreak, String encoding, boolean hasUTF8BOM) {
        XMLEventWriter eventWriter = null;
        BufferedWriter bw = null;
        try {
            XMLEvent xmlEvent;
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileUri), encoding));
            Util.writeBOMIfNeeded((Writer)bw, (boolean)hasUTF8BOM, (String)encoding);
            eventWriter = outputFactory.createXMLEventWriter(bw);
            boolean insideSegmentMetadata = false;
            for (XMLEvent ev : elemsBeforeFirstFileElem) {
                eventWriter.add(ev);
            }
            eventWriter.add(startFileEvent);
            do {
                if (!eventReader.hasNext()) return;
                xmlEvent = eventReader.nextEvent();
                if (this.params.isUpdateSDLTranslationStatus()) {
                    if (xmlEvent.getEventType() == 1 && xmlEvent.asStartElement().getName().getLocalPart().equals("segment-metadata") && xmlEvent.asStartElement().getName().getPrefix().equals("iws")) {
                        insideSegmentMetadata = true;
                    } else if (xmlEvent.getEventType() == 2 && xmlEvent.asEndElement().getName().getLocalPart().equals("segment-metadata") && xmlEvent.asEndElement().getName().getPrefix().equals("iws")) {
                        insideSegmentMetadata = false;
                    } else if (xmlEvent.getEventType() == 1 && xmlEvent.asStartElement().getName().getLocalPart().equals("status") && xmlEvent.asStartElement().getName().getPrefix().equals("iws") && insideSegmentMetadata) {
                        ArrayList<Attribute> modifiedList = new ArrayList<Attribute>();
                        StartElement se = xmlEvent.asStartElement();
                        Iterator<Attribute> attributes = se.getAttributes();
                        while (attributes.hasNext()) {
                            Attribute attr = attributes.next();
                            if (attr.getName().getLocalPart().equals("target_content") || attr.getName().getLocalPart().equals("translation_type") || attr.getName().getLocalPart().equals("translation_status")) continue;
                            modifiedList.add(attr);
                        }
                        modifiedList.add(eventFactory.createAttribute("translation_type", this.params.getTranslationTypeValue()));
                        modifiedList.add(eventFactory.createAttribute("translation_status", this.params.getTranslationStatusValue()));
                        xmlEvent = eventFactory.createStartElement(se.getName().getPrefix(), se.getName().getNamespaceURI(), se.getName().getLocalPart(), modifiedList.iterator(), se.getNamespaces());
                    }
                }
                eventWriter.add(xmlEvent);
            } while (xmlEvent.getEventType() != 2 || !xmlEvent.asEndElement().getName().getLocalPart().equals("file"));
            eventWriter.add(eventFactory.createSpace(lineBreak));
            eventWriter.add(eventFactory.createEndDocument());
            eventWriter.flush();
            eventWriter.close();
            return;
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new OkapiBadStepInputException((Throwable)e);
        }
        finally {
            if (eventWriter != null) {
                try {
                    try {
                        eventWriter.close();
                        eventWriter = null;
                    }
                    catch (XMLStreamException e) {
                        throw new OkapiBadStepInputException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    eventWriter = null;
                    throw throwable;
                }
            }
        }
    }
}

