/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffJoinerStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;

@RunWith(value=JUnit4.class)
public class XliffJoinerTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Pipeline pipeline;
    private Path inputRoot;
    private Path outputRoot;
    private XliffJoinerStep joiner;

    @Before
    public void setUp() throws Exception {
        this.inputRoot = FileLocation.fromClass(XliffJoinerTest.class).in("").asPath();
        this.outputRoot = FileLocation.fromClass(XliffJoinerTest.class).out("").asPath();
        this.pipeline = new Pipeline();
        this.joiner = new XliffJoinerStep();
        this.pipeline.addStep((IPipelineStep)this.joiner);
    }

    @After
    public void tearDown() throws Exception {
        this.pipeline.destroy();
    }

    @Test
    public void joinXliffWithMultipleInputFiles() throws Exception {
        String[] fileList = this.initialize("to_join", String::compareTo);
        this.runPipeline(fileList);
        this.compareWithGold("to_join", "tasks_Test_SDL_XLIFF_18961_es_ES_xliff_CONCAT.xlf", "tasks_Test_SDL_XLIFF_18961_es_ES_xliff_singleFile_CONCAT.gold.xlf");
    }

    @Test
    public void joinXliffWithSingleFileElement() throws Exception {
        String[] fileList = this.initialize("to_join_large_file", String::compareTo);
        this.runPipeline(fileList);
        this.compareWithGold("to_join_large_file", "400.html_CONCAT.xlf", "400.html_CONCAT.gold.xlf");
    }

    @Test
    public void joinXliffThatWasTriviallySplitIntoOnePart() throws Exception {
        String[] fileList = this.initialize("to_join_singlefile", String::compareTo);
        this.runPipeline(fileList);
        this.compareWithGold("to_join_singlefile", "input1_CONCAT.xlf", "input1.xlf");
    }

    @Test
    public void joinXliffContainingMultipleFileElementsSplitIntoMultipleParts() throws Exception {
        String[] fileList = this.initialize("to_join_multiple_files", String::compareTo);
        this.runPipeline(fileList);
        this.compareWithGold("to_join_multiple_files", "multiple_files_CONCAT.xlf", "multiple_files.xlf");
    }

    private void runPipeline(String[] fileList) throws IOException {
        this.pipeline.startBatch();
        for (String file : fileList) {
            Path inputFile = this.inputRoot.resolve(file);
            Path outputFile = this.outputRoot.resolve(file);
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            this.joiner.setOutputURI(outputFile.toUri());
            this.pipeline.process(new RawDocument(inputFile.toUri(), "UTF-8", LocaleId.ENGLISH));
        }
        this.pipeline.endBatch();
    }

    private void compareWithGold(String directory, String outputFileName, String goldFileName) throws Exception {
        File gold = this.inputRoot.resolve(goldFileName).toFile();
        File out = this.outputRoot.resolve(directory).resolve(outputFileName).toFile();
        BOMAwareInputStream goldS = new BOMAwareInputStream((InputStream)new FileInputStream(gold), "UTF-8");
        goldS.detectEncoding();
        BOMAwareInputStream outS = new BOMAwareInputStream((InputStream)new FileInputStream(out), "UTF-8");
        outS.detectEncoding();
        try (InputStreamReader goldR = new InputStreamReader((InputStream)goldS, StandardCharsets.UTF_8);
             InputStreamReader outR = new InputStreamReader((InputStream)outS, StandardCharsets.UTF_8);){
            this.compareXML(goldR, outR, gold.getAbsolutePath(), out.getAbsolutePath());
        }
    }

    private void compareXML(Reader goldR, Reader outR, String goldName, String outName) throws Exception {
        Diff diff = DiffBuilder.compare((Object)Input.fromReader((Reader)goldR)).withTest((Object)Input.fromReader((Reader)outR)).checkForIdentical().build();
        if (diff.hasDifferences()) {
            this.logger.warn("Differences between {} and {}:", (Object)goldName, (Object)outName);
            for (Difference d : diff.getDifferences()) {
                this.logger.warn("- {}", (Object)d.toString());
            }
            Assert.fail();
        }
    }

    private String[] initialize(String directory, Comparator<String> c) throws Exception {
        Path testDir = this.inputRoot.resolve(directory);
        String[] testFileList = this.getTestFiles(testDir, ".xlf").toArray(new String[0]);
        Arrays.sort(testFileList, c);
        return testFileList;
    }

    private List<String> getTestFiles(Path testDir, String suffix) {
        File dir = testDir.toFile();
        FilenameFilter filter = (dir1, name) -> name.endsWith(suffix);
        return Arrays.stream(dir.listFiles(filter)).map(f -> testDir.getFileName() + File.separator + f.getName()).collect(Collectors.toList());
    }
}

