/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitter;
import net.sf.okapi.steps.xliffsplitter.XliffWCSplitterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=XliffWCSplitterParameters.class)
public class XliffWCSplitterStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private XliffWCSplitterParameters params = new XliffWCSplitterParameters();

    public String getDescription() {
        return "Split an XLIFF document into separate documents based on word count.Expects: raw document. Sends back: raw document.";
    }

    public String getName() {
        return "XLIFF Word-Count Splitter";
    }

    public XliffWCSplitterParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (XliffWCSplitterParameters)params;
    }

    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        XliffWCSplitter splitter = new XliffWCSplitter(this.params);
        splitter.process(rawDoc);
        return event;
    }
}

