/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.writer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.persistence.PersistenceSession;
import net.sf.okapi.steps.xliffkit.codec.CodecUtil;
import net.sf.okapi.steps.xliffkit.codec.DummyEncoder;
import net.sf.okapi.steps.xliffkit.codec.ICodec;
import net.sf.okapi.steps.xliffkit.opc.OPCPackageReader;
import net.sf.okapi.steps.xliffkit.writer.Parameters;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.StreamHelper;
import org.apache.poi.openxml4j.opc.TargetMode;

@UsingParameters(value=Parameters.class)
public class XLIFFKitWriterStep
extends BasePipelineStep {
    private XLIFFWriter writer;
    private ICodec codec;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String docMimeType;
    private String docName;
    private String inputEncoding;
    private String configId;
    private Parameters params;
    private URI outputURI;
    private String resourcesFileExt = ".json";
    private String originalFileName;
    private String sourceFileName;
    private String xliffFileName;
    private String skeletonFileName;
    private String resourcesFileName;
    private String originalPartName;
    private String sourcePartName;
    private String xliffPartName;
    private String skeletonPartName;
    private String resourcesPartName;
    private String filterWriterClassName;
    private OPCPackage pack;
    private File tempXliff;
    private File tempResources;
    private PersistenceSession session;
    private List<String> sources = new ArrayList<String>();
    private List<String> originals = new ArrayList<String>();

    public XLIFFKitWriterStep() {
        this.params = new Parameters();
        this.session = new OkapiJsonSession(false);
        this.writer = new XLIFFWriter();
        this.writer.getXLIFFContent().setCharsetEncoder((CharsetEncoder)new DummyEncoder());
        this.codec = OPCPackageReader.CODEC;
    }

    public String getDescription() {
        return "Generate an XLIFF translation kit. Expects: filter events. Sends back: filter events.";
    }

    public String getName() {
        return "XLIFF Kit Writer";
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case NO_OP: {
                return event;
            }
            case START_BATCH: {
                this.processStartBatch();
                break;
            }
            case END_BATCH: {
                this.processEndBatch();
                break;
            }
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case END_BATCH_ITEM: {
                this.processEndBatchItem(event.getEnding());
                this.close();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event.getStartSubDocument());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument(event.getEnding());
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event.getStartGroup());
                break;
            }
            case START_SUBFILTER: {
                this.processStartGroup((StartGroup)event.getStartSubfilter());
                break;
            }
            case END_GROUP: 
            case END_SUBFILTER: {
                this.processEndGroup(event.getEnding());
                break;
            }
            case TEXT_UNIT: {
                ITextUnit tu = event.getTextUnit();
                Event ev = new Event(EventType.TEXT_UNIT, (IResource)tu.clone());
                this.session.serialize((Object)event);
                this.processTextUnit(tu);
                return ev;
            }
        }
        this.session.serialize((Object)event);
        return event;
    }

    private void processStartBatch() {
        File outFile;
        if (this.params != null && !Util.isEmpty((String)this.params.getOutputURI())) {
            this.outputURI = Util.toURI((String)this.params.getOutputURI());
        }
        if ((outFile = new File(this.outputURI)).exists()) {
            outFile.delete();
        }
        Util.createDirectories((String)outFile.getAbsolutePath());
        try {
            this.pack = OPCPackage.openOrCreate((File)outFile);
        }
        catch (InvalidFormatException e1) {
            throw new OkapiException((Throwable)e1);
        }
        XLIFFWriterParameters paramsXliff = this.writer.getParameters();
        paramsXliff.setCopySource(this.params.isCopySource());
        paramsXliff.setPlaceholderMode(this.params.isPlaceholderMode());
        paramsXliff.setIncludeCodeAttrs(this.params.isIncludeCodeAttrs());
        this.session.setDescription(this.params.getMessage());
    }

    private void processEndBatch() {
        this.sources.clear();
        this.originals.clear();
        try {
            this.pack.close();
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
    }

    private void processStartDocument(StartDocument resource) {
        this.close();
        if (resource.getAnnotations() instanceof Annotations) {
            Annotations anns = (Annotations)resource.getAnnotations();
            for (IAnnotation ann : anns) {
                if (ann instanceof Serializable) {
                    this.session.setAnnotation(ann);
                }
                anns.remove(ann.getClass());
            }
        }
        this.srcLoc = resource.getLocale();
        this.docMimeType = resource.getMimeType();
        this.docName = resource.getName();
        if (Util.isEmpty((String)this.docName)) {
            this.docName = "noname.noext";
        }
        this.inputEncoding = resource.getEncoding();
        IParameters fparams = resource.getFilterParameters();
        this.configId = fparams == null ? null : fparams.getPath();
        this.originalFileName = Util.getFilename((String)this.docName, (boolean)true);
        this.sourceFileName = Util.getFilename((String)this.docName, (boolean)true);
        this.xliffFileName = this.originalFileName + ".xlf";
        this.resourcesFileName = this.originalFileName + this.resourcesFileExt;
        this.skeletonFileName = String.format("resources/%s/%s", this.sourceFileName, this.resourcesFileName);
        this.filterWriterClassName = resource.getFilterWriter().getClass().getName();
        try {
            this.tempXliff = File.createTempFile("~okapi-54_" + this.xliffFileName + "_", null);
            this.tempResources = File.createTempFile("~okapi-55_" + this.resourcesFileName + "_", null);
            this.writer.create(this.tempXliff.getAbsolutePath(), this.skeletonFileName, resource.getLocale(), this.trgLoc, resource.getMimeType(), this.sourceFileName, this.params.getMessage());
        }
        catch (IOException e) {
            throw new OkapiIOException((Throwable)e);
        }
        try {
            this.session.start((OutputStream)new FileOutputStream(this.tempResources));
        }
        catch (FileNotFoundException e) {
            throw new OkapiIOException((Throwable)e);
        }
    }

    private PackagePart createPart(OPCPackage pack, PackagePart corePart, String name, File file, String contentType, String relationshipType) {
        PackagePart part = null;
        try {
            PackagePartName partName = PackagingURIHelper.createPartName((String)("/" + name));
            if (pack.containPart(partName)) {
                return null;
            }
            part = pack.createPart(partName, contentType);
            if (corePart != null) {
                corePart.addRelationship(partName, TargetMode.INTERNAL, relationshipType);
            } else {
                pack.addRelationship(partName, TargetMode.INTERNAL, relationshipType);
            }
            try {
                FileInputStream is = new FileInputStream(file);
                OutputStream os = part.getOutputStream();
                StreamHelper.copyStream((InputStream)is, (OutputStream)os);
                try {
                    ((InputStream)is).close();
                    os.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException((Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                throw new OkapiIOException((Throwable)e);
            }
        }
        catch (InvalidFormatException e) {
            throw new OkapiException((Throwable)e);
        }
        return part;
    }

    private void processEndBatchItem(Ending ending) {
        if (ending != null) {
            for (IAnnotation ann : ending.getAnnotations()) {
                if (!(ann instanceof Serializable)) continue;
                this.session.setAnnotation(ann);
            }
        }
        this.session.end();
        this.writer.close();
        this.originalPartName = this.encodePartName(String.format("content/original/%s/%s", this.srcLoc.toString(), this.originalFileName));
        this.sourcePartName = this.encodePartName(String.format("content/source/%s/%s", this.srcLoc.toString(), this.sourceFileName));
        this.xliffPartName = this.encodePartName(String.format("content/target/%s.%s/%s", this.srcLoc.toString(), this.trgLoc.toString(), this.xliffFileName));
        this.resourcesPartName = this.encodePartName(String.format("content/target/%s.%s/resources/%s/%s", this.srcLoc.toString(), this.trgLoc.toString(), this.sourceFileName, this.resourcesFileName));
        PackagePart corePart = this.createPart(this.pack, null, this.xliffPartName, this.tempXliff, "application/x-xliff+xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        this.createPart(this.pack, corePart, this.resourcesPartName, this.tempResources, this.session.getMimeType(), "http://schemas.okapi.org/2010/relationships/resources");
        if (this.params.isIncludeSource() && !this.sources.contains(this.docName)) {
            this.createPart(this.pack, corePart, this.sourcePartName, new File(this.docName), this.docMimeType, "http://schemas.okapi.org/2010/relationships/source");
            this.sources.add(this.docName);
        }
        if (this.params.isIncludeOriginal() && !this.originals.contains(this.docName)) {
            this.createPart(this.pack, corePart, this.originalPartName, new File(this.docName), this.docMimeType, "http://schemas.okapi.org/2010/relationships/original");
            this.originals.add(this.docName);
        }
    }

    private String encodePartName(String partName) {
        partName = partName.replaceAll("\\s", "_");
        partName = Normalizer.normalize(partName, Normalizer.Form.NFD);
        return partName.replaceAll("[^\\p{ASCII}]", "");
    }

    private void processStartSubDocument(StartSubDocument resource) {
        this.writer.writeStartFile(resource.getName(), resource.getMimeType(), this.skeletonFileName);
    }

    private void processEndSubDocument(Ending resource) {
        this.writer.writeEndFile();
    }

    private void processStartGroup(StartGroup resource) {
        this.writer.writeStartGroup(resource);
    }

    private void processEndGroup(Ending resource) {
        this.writer.writeEndGroup();
    }

    private void processTextUnit(ITextUnit tu) {
        tu = tu.clone();
        tu.setPreserveWhitespaces(true);
        CodecUtil.encodeTextUnit(tu, this.codec);
        this.writer.writeTextUnit(tu);
    }

    public IParameters getParameters() {
        return this.params;
    }

    protected PersistenceSession getSession() {
        return this.session;
    }

    protected void setSession(PersistenceSession session) {
        this.session = session;
    }

    public String getResourcesFileExt() {
        return this.resourcesFileExt;
    }

    public void setResourcesFileExt(String resourcesFileExt) {
        this.resourcesFileExt = resourcesFileExt;
    }

    protected XLIFFWriter getWriter() {
        return this.writer;
    }
}

