/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.reader;

import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;
import net.sf.okapi.lib.persistence.PersistenceSession;
import net.sf.okapi.steps.xliffkit.opc.OPCPackageReader;
import net.sf.okapi.steps.xliffkit.reader.Parameters;

@UsingParameters
public class XLIFFKitReaderStep
extends BasePipelineStep {
    private OPCPackageReader reader;
    private boolean isDone = true;
    private URI inputURI;
    private URI outputURI;
    private String outputEncoding;
    private Parameters params = new Parameters();
    private TextUnitMerger merger = new TextUnitMerger();
    private RawDocument rd;

    public XLIFFKitReaderStep() {
        this.reader = new OPCPackageReader(this.merger);
    }

    public String getDescription() {
        return "Reads XLIFF translation kit. Expects: Raw document for T-kit. Sends back: filter events.";
    }

    public String getName() {
        return "XLIFF Kit Reader";
    }

    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.reader.setTrgLoc(targetLocale);
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public Event handleEvent(Event event) {
        event = super.handleEvent(event);
        switch (event.getEventType()) {
            case START_BATCH: {
                this.isDone = true;
                break;
            }
            case START_BATCH_ITEM: {
                this.isDone = false;
                return event;
            }
            case END_DOCUMENT: {
                if (this.rd != null) {
                    this.rd.close();
                    this.rd = null;
                }
            }
            case RAW_DOCUMENT: {
                this.isDone = false;
                if (event.isRawDocument()) {
                    this.rd = event.getRawDocument();
                } else if (event.isStartDocument()) {
                    StartDocument sd = event.getStartDocument();
                    this.rd = new RawDocument(this.inputURI, sd.getEncoding(), sd.getLocale());
                }
                net.sf.okapi.lib.merge.merge.Parameters mParams = new net.sf.okapi.lib.merge.merge.Parameters();
                mParams.setApprovedOnly(this.params.getBoolean("useApprovedOnly"));
                this.merger.setParameters(mParams);
                if (this.params.isGenerateTargets()) {
                    this.reader.setGeneratorOptions(this.outputEncoding, this.outputURI.getPath(), this.params.isGroupByPackagePath());
                }
                this.reader.open(this.rd);
                Event e = this.reader.next();
                if (e.isStartDocument()) {
                    StartDocument sd = e.getStartDocument();
                    for (IAnnotation annotation : this.getSession().getAnnotations()) {
                        sd.setAnnotation(annotation);
                    }
                }
                return e;
            }
        }
        if (this.isDone) {
            return event;
        }
        Event e = this.reader.next();
        this.isDone = !this.reader.hasNext();
        return e;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void destroy() {
        this.reader.close();
    }

    public void cancel() {
        this.reader.cancel();
    }

    public IParameters getParameters() {
        return this.params;
    }

    protected PersistenceSession getSession() {
        return this.reader.getSession();
    }

    protected OPCPackageReader getReader() {
        return this.reader;
    }

    protected TextUnitMerger getMerger() {
        return this.merger;
    }
}

