/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.opc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;
import net.sf.okapi.lib.persistence.PersistenceSession;
import net.sf.okapi.steps.xliffkit.codec.CodecUtil;
import net.sf.okapi.steps.xliffkit.codec.ICodec;
import net.sf.okapi.steps.xliffkit.codec.PackageSymCodec;
import net.sf.okapi.steps.xliffkit.opc.OPCPackageUtil;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;

public class OPCPackageReader
extends AbstractFilter {
    public static final ICodec CODEC = new PackageSymCodec();
    private OPCPackage pack;
    private OkapiJsonSession session = new OkapiJsonSession(false);
    private Event event;
    private LinkedList<PackagePart> coreParts = new LinkedList();
    private PackagePart activePart;
    private PackagePart resourcesPart;
    private XLIFFFilter xliffReader;
    private TextUnitMerger merger;
    private LocaleId srcLoc;
    private String outputEncoding;
    private IFilterWriter filterWriter;
    private boolean generateTargets = false;
    private String outputPath;
    private boolean groupByPackagePath = true;
    private boolean cacheEvents = false;
    private LinkedList<Event> events = new LinkedList();
    private ICodec codec;

    public OPCPackageReader(TextUnitMerger merger) {
        this.merger = merger;
        this.codec = CODEC;
    }

    protected boolean isUtf8Bom() {
        return false;
    }

    protected boolean isUtf8Encoding() {
        return false;
    }

    private void writeEvent(Event event) {
        if (!this.generateTargets) {
            return;
        }
        if (this.filterWriter == null) {
            return;
        }
        if (this.events == null) {
            return;
        }
        if (this.cacheEvents) {
            this.events.add(event);
        } else {
            while (this.events.size() > 0) {
                this.filterWriter.handleEvent(this.events.poll());
            }
            this.filterWriter.handleEvent(event);
        }
    }

    public void close() {
        this.clearParts();
        this.session.end();
        try {
            this.pack.close();
        }
        catch (IOException e) {
            throw new OkapiIOException("OPCPackageReader: cannot close package");
        }
    }

    private void clearParts() {
        this.coreParts.clear();
        this.activePart = null;
        this.resourcesPart = null;
    }

    public IParameters getParameters() {
        return null;
    }

    public boolean hasNext() {
        return this.event != null;
    }

    public Event next() {
        Event prev = this.event;
        this.event = this.deserializeEvent();
        return prev;
    }

    private Event deserializeEvent() {
        Event event = null;
        if (this.activePart == null) {
            this.activePart = this.coreParts.poll();
            if (this.activePart == null) {
                return null;
            }
            this.resourcesPart = OPCPackageUtil.getResourcesPart(this.activePart);
            try {
                if (this.resourcesPart != null) {
                    this.session.start(this.resourcesPart.getInputStream());
                }
            }
            catch (IOException e) {
                throw new OkapiIOException("OPCPackageReader: cannot get resources from package", (Throwable)e);
            }
            if (this.xliffReader != null) {
                this.xliffReader.close();
                this.xliffReader = null;
            }
            this.xliffReader = new XLIFFFilter();
            Parameters params = this.xliffReader.getParameters();
            params.setBalanceCodes(false);
            try {
                this.xliffReader.open(new RawDocument(this.activePart.getInputStream(), "UTF-8", this.srcLoc, this.getTrgLoc()));
            }
            catch (IOException e) {
                throw new OkapiException(String.format("OPCPackageReader: cannot open input stream for %s", this.activePart.getPartName().getName()), (Throwable)e);
            }
        }
        if ((event = (Event)this.session.deserialize(Event.class)) == null) {
            this.session.end();
            this.activePart = null;
            return this.deserializeEvent();
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case START_SUBDOCUMENT: 
            case START_GROUP: 
            case END_SUBDOCUMENT: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: 
            case DOCUMENT_PART: {
                this.writeEvent(event);
            }
        }
        return event;
    }

    public void open(RawDocument input) {
        this.open(input, false);
    }

    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.srcLoc = input.getSourceLocale();
            this.pack = OPCPackage.open((InputStream)input.getStream());
        }
        catch (Exception e) {
            throw new OkapiIOException("OPCPackageReader: cannot open package", (Throwable)e);
        }
        this.clearParts();
        this.coreParts.addAll(OPCPackageUtil.getCoreParts(this.pack));
        this.event = this.deserializeEvent();
    }

    public void setParameters(IParameters params) {
    }

    private ITextUnit getNextXliffTu() {
        if (this.xliffReader == null) {
            throw new OkapiException("OPCPackageReader: xliffReader is not initialized");
        }
        Event ev = null;
        while (this.xliffReader.hasNext()) {
            StartSubDocument startSubDoc;
            Property prop;
            ev = this.xliffReader.next();
            if (ev == null) {
                return null;
            }
            if (ev.getEventType() == EventType.START_SUBDOCUMENT && (prop = (startSubDoc = (StartSubDocument)ev.getResource()).getProperty("targetLanguage")) != null) {
                LocaleId trgLoc = LocaleId.fromString((String)prop.getValue());
                this.merger.setTargetLocale(trgLoc);
                this.filterWriter.setOptions(trgLoc, this.outputEncoding);
                this.cacheEvents = false;
            }
            if (ev.getEventType() != EventType.TEXT_UNIT) continue;
            return ev.getTextUnit();
        }
        return null;
    }

    private void processStartDocument(Event event) {
        StartDocument startDoc = event.getStartDocument();
        String srcName = startDoc.getName();
        String partName = this.activePart.getPartName().toString();
        this.filterWriter = startDoc.getFilterWriter();
        this.filterWriter.setParameters(startDoc.getFilterParameters());
        if (this.generateTargets) {
            String outFileName = this.groupByPackagePath ? Util.buildPath((String[])new String[]{this.outputPath, Util.getDirectoryName((String)partName), Util.getFilename((String)srcName, (boolean)true)}) : Util.buildPath((String[])new String[]{this.outputPath, Util.getFilename((String)srcName, (boolean)true)});
            File outputFile = new File(outFileName);
            Util.createDirectories((String)outputFile.getAbsolutePath());
            this.filterWriter.setOutput(outputFile.getAbsolutePath());
            this.cacheEvents = true;
            this.writeEvent(event);
        }
    }

    private void processEndDocument(Event event) {
        this.writeEvent(event);
        if (this.generateTargets) {
            this.filterWriter.close();
        }
    }

    private void processTextUnit(Event event) {
        TextContainer target;
        if (this.merger == null) {
            return;
        }
        ITextUnit tu = event.getTextUnit();
        ITextUnit xtu = this.getNextXliffTu();
        if (xtu == null) {
            return;
        }
        CodecUtil.decodeTextUnit(xtu, this.codec);
        this.merger.mergeTargets(tu, xtu);
        if (this.generateTargets && (target = tu.getTarget(this.merger.getTargetLocale())) != null) {
            target.getSegments().joinAll();
        }
        this.writeEvent(event);
    }

    public void setGeneratorOptions(String outputEncoding, String outputPath, boolean groupByPackagePath) {
        this.outputEncoding = outputEncoding;
        this.generateTargets = !Util.isEmpty((String)outputPath);
        this.outputPath = outputPath;
        this.groupByPackagePath = groupByPackagePath;
    }

    public PersistenceSession getSession() {
        return this.session;
    }
}

