/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.codec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.steps.xliffkit.codec.BasePackageCodec;

public class PackageSymCodec
extends BasePackageCodec {
    private static final String[] LOOKUP = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US", "DEL"};
    private static final String MASK = "[%s]";
    private static Pattern[] patterns;
    private String mask;

    public PackageSymCodec() {
        this(MASK);
    }

    public PackageSymCodec(String mask) {
        this.mask = mask;
        patterns = new Pattern[LOOKUP.length];
        for (int i = 0; i < LOOKUP.length; ++i) {
            String st = String.format(mask, LOOKUP[i]);
            PackageSymCodec.patterns[i] = Pattern.compile(RegexUtil.escape((String)st));
        }
    }

    @Override
    protected String doEncode(int codePoint) {
        if (codePoint == 127) {
            codePoint = 32;
        }
        if (codePoint <= 32) {
            String st = String.format(this.mask, LOOKUP[codePoint]);
            return st;
        }
        return new String(Character.toChars(codePoint));
    }

    @Override
    protected String doDecode(String text) {
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            String replacement = this.getReplacement(i);
            text = pattern.matcher(text).replaceAll(replacement);
        }
        return text;
    }

    private String getReplacement(int index) {
        if (index == 32) {
            index = 127;
        }
        return new String(Character.toChars(index));
    }
}

