/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.codec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.steps.xliffkit.codec.BasePackageCodec;

public class PackageHexCodec
extends BasePackageCodec {
    private static final String MASK = "_#x%04X;";
    private static final Pattern PATTERN = Pattern.compile("_#x(\\p{XDigit}+?);");
    private static final int GROUP = 1;

    @Override
    protected String doEncode(int codePoint) {
        return String.format(MASK, codePoint);
    }

    @Override
    protected String doDecode(String text) {
        Matcher matcher = PATTERN.matcher(text);
        StringBuilder buf = new StringBuilder();
        int start = 0;
        int end = 0;
        while (matcher.find()) {
            start = matcher.start();
            if (start == -1) continue;
            buf.append(text.substring(end, start));
            int codePoint = Integer.parseInt(matcher.group(1), 16);
            char[] replacement = Character.toChars(codePoint);
            buf.append(replacement);
            end = matcher.end();
        }
        buf.append(text.substring(end));
        return buf.toString();
    }
}

