/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.codec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.steps.xliffkit.codec.BasePackageCodec;

public class PackageEscCodec
extends BasePackageCodec {
    private static final String[] LOOKUP = new String[]{"\\0", "^A", "^B", "^C", "^D", "^E", "^F", "\\a", "\\b", "\\t", "\\n", "\\v", "\\f", "\\r", "^N", "^O", "^P", "^Q", "^R", "^S", "^T", "^U", "^V", "^W", "^X", "^Y", "^Z", "\\e", "^\\", "^]", "^^", "^_", "^?"};
    private static final String PREFIX = new String(Character.toChars(65520));
    private static Pattern[] patterns;

    public PackageEscCodec() {
        patterns = new Pattern[LOOKUP.length];
        for (int i = 0; i < LOOKUP.length; ++i) {
            String st = PREFIX + LOOKUP[i];
            PackageEscCodec.patterns[i] = Pattern.compile(RegexUtil.escape((String)st));
        }
    }

    @Override
    protected String doEncode(int codePoint) {
        if (codePoint == 127) {
            codePoint = 32;
        }
        if (codePoint <= 32) {
            return PREFIX + LOOKUP[codePoint];
        }
        return new String(Character.toChars(codePoint));
    }

    @Override
    protected String doDecode(String text) {
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            String replacement = this.getReplacement(i);
            text = pattern.matcher(text).replaceAll(replacement);
        }
        return text;
    }

    private String getReplacement(int index) {
        if (index == 32) {
            index = 127;
        }
        return new String(Character.toChars(index));
    }
}

