/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.codec;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.xliffkit.codec.ICodec;

public class CodecUtil {
    private static void processTC(TextContainer tc, Operation op, ICodec codec) {
        for (TextPart textPart : tc) {
            if (!textPart.isSegment()) continue;
            TextFragment tf = textPart.getContent();
            String codedText = tf.getCodedText();
            switch (op) {
                case ENCODE: {
                    codedText = codec.encode(codedText);
                    break;
                }
                case DECODE: {
                    codedText = codec.decode(codedText);
                    break;
                }
            }
            tf.setCodedText(codedText);
            for (Code code : tf.getCodes()) {
                if (code.hasOuterData()) {
                    code.setOuterData(code.getOuterData());
                }
                if (!code.hasData()) continue;
                code.setData(code.getData());
            }
        }
    }

    private static void processTU(ITextUnit tu, Operation op, ICodec codec) {
        CodecUtil.processTC(tu.getSource(), op, codec);
        for (LocaleId trgLoc : tu.getTargetLocales()) {
            CodecUtil.processTC(tu.getTarget(trgLoc), op, codec);
        }
    }

    public static void encodeTextUnit(ITextUnit tu, ICodec codec) {
        CodecUtil.processTU(tu, Operation.ENCODE, codec);
    }

    public static void decodeTextUnit(ITextUnit tu, ICodec codec) {
        CodecUtil.processTU(tu, Operation.DECODE, codec);
    }

    private static enum Operation {
        ENCODE,
        DECODE;

    }
}

