/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.codec;

import net.sf.okapi.steps.xliffkit.codec.ICodec;

public abstract class BaseCodec
implements ICodec {
    @Override
    public final String encode(String text) {
        text = this.doEncodePreprocess(text);
        text = this.doEncode(text);
        return this.doEncodePostprocess(text);
    }

    @Override
    public final String decode(String text) {
        text = this.doDecodePreprocess(text);
        text = this.doDecode(text);
        return this.doDecodePostprocess(text);
    }

    protected String doEncode(String text) {
        int codePoint;
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(offset);
            if (this.canEncode(codePoint)) {
                sb.append(this.doEncode(codePoint));
                continue;
            }
            sb.append(Character.toChars(codePoint));
        }
        return sb.toString();
    }

    protected String doEncode(int codePoint) {
        return new String(Character.toChars(codePoint));
    }

    protected String doDecode(String text) {
        int codePoint;
        StringBuilder sb = new StringBuilder();
        int length = text.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(offset);
            sb.append(this.doDecode(codePoint));
        }
        return sb.toString();
    }

    protected String doDecode(int codePoint) {
        return new String(Character.toChars(codePoint));
    }

    protected String doEncodePreprocess(String text) {
        return text;
    }

    protected String doEncodePostprocess(String text) {
        return text;
    }

    protected String doDecodePreprocess(String text) {
        return text;
    }

    protected String doDecodePostprocess(String text) {
        return text;
    }
}

