/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.writer;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.lib.beans.sessions.OkapiXstreamSession;
import net.sf.okapi.lib.beans.v0.TestEvent;
import net.sf.okapi.lib.beans.v0.TestEventBean;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XParameter;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.lib.persistence.PersistenceSession;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.xliffkit.writer.Parameters;
import net.sf.okapi.steps.xliffkit.writer.XLIFFKitWriterStep;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class XstreamWriterTest {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private static final LocaleId FRFR = new LocaleId("fr", "fr");
    private static final LocaleId DEDE = new LocaleId("de", "de");
    private static final LocaleId ITIT = new LocaleId("it", "it");

    @Test
    public void test() {
    }

    public void testPackageFormat4xstream() throws URISyntaxException, MalformedURLException {
        boolean loops = true;
        long start = System.currentTimeMillis();
        String pathBase = Util.getDirectoryName((String)this.getClass().getResource("test2.txt").getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        OkapiXstreamSession session = new OkapiXstreamSession();
        writerStep.setSession((PersistenceSession)session);
        writerStep.setResourcesFileExt(".xml");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new URL("file", null, src1Path + "BoldWorld.docx").toURI(), "UTF-8", "okf_openxml", null, "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)writerStep, new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new URL("file", null, pathBase + "testPackageFormat4.xstream.kit").toURI().toString())})}).execute();
        this.log(" Total: " + (System.currentTimeMillis() - start) + " milliseconds.");
    }

    private void log(String str) {
        Logger localLogger = LoggerFactory.getLogger(this.getClass());
        localLogger.debug(str);
    }

    public void testPackageFormat5xstream() throws URISyntaxException, MalformedURLException {
        int loops = 10;
        long start = System.currentTimeMillis();
        String pathBase = Util.getDirectoryName((String)this.getClass().getResource("test2.txt").getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        OkapiXstreamSession session = new OkapiXstreamSession();
        writerStep.setSession((PersistenceSession)session);
        writerStep.setResourcesFileExt(".xml");
        for (int i = 0; i < loops; ++i) {
            new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new URL("file", null, src1Path + "test5.txt"), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)writerStep, new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new URL("file", null, pathBase + "testPackageFormat5.xstream.kit").toURI().toString())})}).execute();
        }
        this.log(" Total: " + (System.currentTimeMillis() - start) + " milliseconds.");
    }

    @Test
    public void testReferences3xstream() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        OkapiXstreamSession session = new OkapiXstreamSession();
        writerStep.setSession((PersistenceSession)session);
        writerStep.setResourcesFileExt(".xml");
        String pathBase = Util.getDirectoryName((String)this.getClass().getResource("test2.txt").getPath()) + "/";
        writerStep.setOutputURI(new URL("file", null, pathBase + "testReferences3.xstream.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        session.registerBean(TestEvent.class, TestEventBean.class);
        TestEvent e1 = new TestEvent("e1");
        TestEvent e2 = new TestEvent("e2");
        e2.setParent(e1);
        e1.setParent(e2);
        writerStep.handleEvent(new Event(EventType.START_BATCH));
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs3.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        writerStep.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        writerStep.handleEvent((Event)e1);
        writerStep.handleEvent((Event)e2);
        writerStep.handleEvent(new Event(EventType.END_DOCUMENT));
        writerStep.handleEvent(new Event(EventType.END_BATCH));
    }
}

