/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.writer;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.filters.table.TableFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.beans.v0.TestEvent;
import net.sf.okapi.lib.beans.v0.TestEventBean;
import net.sf.okapi.lib.beans.v0.TestEventBean2;
import net.sf.okapi.lib.beans.v1.EventBean;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XParameter;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.lib.extra.steps.EventLogger;
import net.sf.okapi.lib.extra.steps.TuDpSsfLogger;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.PersistenceSession;
import net.sf.okapi.lib.persistence.beans.FactoryBean;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.xliffkit.writer.Parameters;
import net.sf.okapi.steps.xliffkit.writer.XLIFFKitWriterStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class XLIFFKitWriterTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String IN_NAME2 = "TestDocument01.odt";
    private final String IN_NAME3 = "test4.txt";
    WriteObserver writeObserver = new WriteObserver();
    List<IPersistenceBean<?>> beans = new ArrayList();
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private static final LocaleId FRFR = new LocaleId("fr", "fr");
    private static final LocaleId DEDE = new LocaleId("de", "de");
    private static final LocaleId ITIT = new LocaleId("it", "it");

    private XPipeline buildPipeline(String inPath1, String inPath2) throws URISyntaxException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        return new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource(inPath2), "UTF-8", Util.getDirectoryName((String)new File(this.getClass().getResource(inPath2).toURI()).getPath()) + "/" + inPath2 + ".en.fr.xliff.kit", "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true)})});
    }

    public void testOutputFile() throws URISyntaxException {
        this.buildPipeline("TestDocument01.odt", "test4.txt").execute();
    }

    public void testTempFile() {
    }

    public void testXLIFFFilterEvents() {
        XLIFFFilter filter = new XLIFFFilter();
        InputStream input = this.getClass().getResourceAsStream("TestDocument01.odt.xlf");
        filter.open(new RawDocument(input, "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH));
        Event event = null;
        ITextUnit tu = null;
        while (filter.hasNext() && ((event = filter.next()).getEventType() != EventType.TEXT_UNIT || !"2".equals((tu = event.getTextUnit()).getId()))) {
        }
        filter.close();
    }

    @Test
    public void testPackageFormat() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test1.xlf").toURI().toURL(), "UTF-8", ENUS, DEDE), new XBatchItem(new File(src2Path, "test9.odt").toURI().toURL(), "UTF-8", ENUS, DEDE), new XBatchItem(new File(src1Path, "test10.html").toURI().toURL(), "UTF-8", ENUS, DEDE), new XBatchItem(new File(src1Path, "aa324.html").toURI().toURL(), "UTF-8", ENUS, DEDE), new XBatchItem(new File(src1Path, "test11.docx").toURI(), "UTF-8", "okf_openxml", null, "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new EventLogger(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat.xliff.kit").toURI().toString())})}).execute();
    }

    @Test
    public void testXliffEvents() throws MalformedURLException, URISyntaxException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        RawDocumentToFilterEventsStep rd2fe = new RawDocumentToFilterEventsStep();
        rd2fe.setFilter((IFilter)new XLIFFFilter());
        new XPipeline("", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test1.xlf").toURI().toURL(), "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{rd2fe, new EventLogger(), new TuDpSsfLogger()}).execute();
    }

    @Test
    public void testPackageFormat2() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src2Path, "test5.txt").toURI().toURL(), "UTF-8", ENUS, FRFR), new XBatchItem(new File(src1Path, "test12.html").toURI().toURL(), "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat2.xliff.kit").toURI().toString())})}).execute();
    }

    public void testPackageFormat3() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        RawDocumentToFilterEventsStep rd2fe = new RawDocumentToFilterEventsStep();
        TableFilter filter = new TableFilter();
        rd2fe.setFilter((IFilter)filter);
        filter.getParameters().load(Util.URItoURL((URI)new File(src1Path, "okf_table@copy-of-csv_97.fprm").toURI()), true);
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src2Path, "CSVTest_97.txt").toURI(), "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{rd2fe, new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat3.xliff.kit").toURI().toString())})}).execute();
    }

    public void testPackageFormat4() throws URISyntaxException, MalformedURLException {
        boolean loops = true;
        long start = System.currentTimeMillis();
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "BoldWorld.docx").toURI(), "UTF-8", "okf_openxml", null, "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat4.xliff.kit").toURI().toString())})}).execute();
        this.log(" Total: " + (System.currentTimeMillis() - start) + " milliseconds.");
    }

    public void testPackageFormat5() throws URISyntaxException, MalformedURLException {
        int loops = 1;
        long start = System.currentTimeMillis();
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        for (int i = 0; i < loops; ++i) {
            new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test5.txt").toURI().toURL(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat5.xliff.kit").toURI().toString())})}).execute();
        }
        this.log(" Total: " + (System.currentTimeMillis() - start) + " milliseconds.");
    }

    private void log(String str) {
        this.logger.debug(str);
    }

    @Test
    public void testPackageFormat6() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test12.html").toURI().toURL(), "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat6.xliff.kit").toURI().toString())})}).execute();
    }

    @Test
    public void testPackageFormat7() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test11.docx").toURI(), "UTF-8", "okf_openxml", null, "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new EventLogger(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat.xliff.kit").toURI().toString())})}).execute();
    }

    @Test
    public void testPackageFormat8() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test_UTF-8.txt").toURI().toURL(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new EventLogger(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat8.xliff.kit").toURI().toString())})}).execute();
    }

    public void testReferences() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        String pathBase = Util.getDirectoryName((String)this.getClass().getResource("test2.txt").getPath()) + "/";
        writerStep.setOutputURI(new File(pathBase, "testReferences.xliff.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        ArrayList<Event> events = new ArrayList<Event>();
        Event e = new Event(EventType.START_BATCH);
        events.add(e);
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        e = new Event(EventType.START_DOCUMENT, (IResource)sd);
        events.add(e);
        ITextUnit tu1 = TextUnitUtil.buildTU((String)"source-text1\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu2 = TextUnitUtil.buildTU((String)"source-text2\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu3 = TextUnitUtil.buildTU((String)"source-text3\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu4 = TextUnitUtil.buildTU((String)"source-text4\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu5 = TextUnitUtil.buildTU((String)"source-text5\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu6 = TextUnitUtil.buildTU((String)"source-text6\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu7 = TextUnitUtil.buildTU((String)"source-text7\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        tu1.setTarget(FRFR, new TextContainer("french-text1"));
        tu1.setTarget(DEDE, new TextContainer("german-text1"));
        GenericSkeleton skel1 = new GenericSkeleton();
        GenericSkeleton skel2 = new GenericSkeleton();
        GenericSkeleton skel3 = new GenericSkeleton();
        GenericSkeleton skel4 = new GenericSkeleton();
        GenericSkeleton skel5 = new GenericSkeleton();
        GenericSkeleton skel6 = new GenericSkeleton();
        GenericSkeleton skel7 = new GenericSkeleton();
        tu1.setId("tu1");
        tu1.setSkeleton((ISkeleton)skel1);
        tu2.setId("tu2");
        tu2.setSkeleton((ISkeleton)skel2);
        tu3.setId("tu3");
        tu3.setSkeleton((ISkeleton)skel3);
        tu4.setId("tu4");
        tu4.setSkeleton((ISkeleton)skel4);
        tu5.setId("tu5");
        tu5.setSkeleton((ISkeleton)skel5);
        tu6.setId("tu6");
        tu6.setSkeleton((ISkeleton)skel6);
        tu7.setId("tu7");
        tu7.setSkeleton((ISkeleton)skel7);
        skel1.addContentPlaceholder(tu3);
        skel3.addContentPlaceholder(tu4);
        skel5.addContentPlaceholder(tu2);
        skel5.addContentPlaceholder(tu7);
        skel7.addContentPlaceholder(tu6);
        skel2.addContentPlaceholder(tu6);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu5);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu6);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu7);
        events.add(e);
        e = new Event(EventType.END_DOCUMENT);
        events.add(e);
        e = new Event(EventType.END_BATCH);
        events.add(e);
        for (Event event : events) {
            writerStep.handleEvent(event);
        }
    }

    public void testReferences2() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        writerStep.setOutputURI(new File(pathBase, "testReferences2.xliff.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        ArrayList<Event> events = new ArrayList<Event>();
        Event e = new Event(EventType.START_BATCH);
        events.add(e);
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        e = new Event(EventType.START_DOCUMENT, (IResource)sd);
        events.add(e);
        ITextUnit tu1 = TextUnitUtil.buildTU((String)"source-text1\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        ITextUnit tu2 = TextUnitUtil.buildTU((String)"source-text2\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        GenericSkeleton skel1 = new GenericSkeleton();
        GenericSkeleton skel2 = new GenericSkeleton();
        tu1.setId("tu1");
        tu1.setSkeleton((ISkeleton)skel1);
        tu2.setId("tu2");
        tu2.setSkeleton((ISkeleton)skel2);
        skel1.addContentPlaceholder(tu2);
        skel2.addContentPlaceholder(tu1);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        events.add(e);
        e = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        events.add(e);
        e = new Event(EventType.END_DOCUMENT);
        events.add(e);
        e = new Event(EventType.END_BATCH);
        events.add(e);
        for (Event event : events) {
            writerStep.handleEvent(event);
        }
    }

    @Test
    public void testReferences3() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        PersistenceSession session = writerStep.getSession();
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        writerStep.setOutputURI(new File(pathBase, "testReferences3.xliff.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        session.registerBean(TestEvent.class, TestEventBean.class);
        TestEvent e1 = new TestEvent("e1");
        TestEvent e2 = new TestEvent("e2");
        e2.setParent(e1);
        e1.setParent(e2);
        writerStep.handleEvent(new Event(EventType.START_BATCH));
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs3.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        writerStep.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        writerStep.handleEvent((Event)e1);
        writerStep.handleEvent((Event)e2);
        writerStep.handleEvent(new Event(EventType.END_DOCUMENT));
        writerStep.handleEvent(new Event(EventType.END_BATCH));
    }

    @Test
    public void testReferences4() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        PersistenceSession session = writerStep.getSession();
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        writerStep.setOutputURI(new File(pathBase, "testReferences4.xliff.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        session.registerBean(TestEvent.class, TestEventBean.class);
        TestEvent e1 = new TestEvent("e1");
        TestEvent e2 = new TestEvent("e2");
        TestEvent e3 = new TestEvent("e3");
        TestEvent e4 = new TestEvent("e4");
        TestEvent e5 = new TestEvent("e5");
        TestEvent e6 = new TestEvent("e6");
        TestEvent e7 = new TestEvent("e7");
        e1.setParent(e3);
        e3.setParent(e4);
        e2.setParent(e6);
        e7.setParent(e6);
        e5.setParent(e2);
        writerStep.handleEvent(new Event(EventType.START_BATCH));
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs4.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        writerStep.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        writerStep.handleEvent((Event)e1);
        writerStep.handleEvent((Event)e2);
        writerStep.handleEvent((Event)e3);
        writerStep.handleEvent((Event)e4);
        writerStep.handleEvent((Event)e5);
        writerStep.handleEvent((Event)e6);
        writerStep.handleEvent((Event)e7);
        writerStep.handleEvent(new Event(EventType.END_DOCUMENT));
        writerStep.handleEvent(new Event(EventType.END_BATCH));
    }

    @Test
    public void testReferences5() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        PersistenceSession session = writerStep.getSession();
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        writerStep.setOutputURI(new File(pathBase, "testReferences5.xliff.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        session.registerBean(TestEvent.class, TestEventBean2.class);
        TestEvent e1 = new TestEvent("e1");
        TestEvent e2 = new TestEvent("e2");
        e2.setParent(e1);
        e1.setParent(e2);
        writerStep.handleEvent(new Event(EventType.START_BATCH));
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs5.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        writerStep.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        writerStep.handleEvent((Event)e1);
        writerStep.handleEvent((Event)e2);
        writerStep.handleEvent(new Event(EventType.END_DOCUMENT));
        writerStep.handleEvent(new Event(EventType.END_BATCH));
    }

    @Test
    public void testReferences6() throws MalformedURLException, URISyntaxException {
        XLIFFKitWriterStep writerStep = new XLIFFKitWriterStep();
        PersistenceSession session = writerStep.getSession();
        this.beans.clear();
        writerStep.getSession().addObserver((IObserver)this.writeObserver);
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        writerStep.setOutputURI(new File(pathBase, "testReferences6.xliff.kit").toURI());
        writerStep.setTargetLocale(DEDE);
        Parameters params = (Parameters)writerStep.getParameters();
        params.setIncludeSource(false);
        params.setIncludeOriginal(false);
        session.registerBean(TestEvent.class, TestEventBean2.class);
        TestEvent e1 = new TestEvent("e1");
        TestEvent e2 = new TestEvent("e2");
        TestEvent e3 = new TestEvent("e3");
        TestEvent e4 = new TestEvent("e4");
        TestEvent e5 = new TestEvent("e5");
        TestEvent e6 = new TestEvent("e6");
        TestEvent e7 = new TestEvent("e7");
        e1.setParent(e3);
        e3.setParent(e4);
        e2.setParent(e6);
        e7.setParent(e6);
        e5.setParent(e2);
        writerStep.handleEvent(new Event(EventType.START_BATCH));
        StartDocument sd = new StartDocument("sd1");
        sd.setName("test_refs6.txt");
        sd.setLocale(ENUS);
        sd.setFilterWriter((IFilterWriter)new GenericFilterWriter(null, null));
        writerStep.handleEvent(new Event(EventType.START_DOCUMENT, (IResource)sd));
        writerStep.handleEvent((Event)e1);
        writerStep.handleEvent((Event)e2);
        writerStep.handleEvent((Event)e3);
        writerStep.handleEvent((Event)e4);
        writerStep.handleEvent((Event)e5);
        writerStep.handleEvent((Event)e6);
        writerStep.handleEvent((Event)e7);
        writerStep.handleEvent(new Event(EventType.END_DOCUMENT));
        writerStep.handleEvent(new Event(EventType.END_BATCH_ITEM));
        writerStep.handleEvent(new Event(EventType.END_BATCH));
        Assert.assertEquals((long)9L, (long)this.beans.size());
        Assert.assertTrue((boolean)(this.beans.get(0) instanceof EventBean));
        Assert.assertTrue((boolean)(this.beans.get(1) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(2) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(3) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(4) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(5) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(6) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(7) instanceof TestEventBean2));
        Assert.assertTrue((boolean)(this.beans.get(8) instanceof EventBean));
        TestEventBean2 bean = null;
        FactoryBean parent = null;
        bean = (TestEventBean2)this.beans.get(1);
        Assert.assertEquals((Object)"e1", (Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals((Object)parent.getClassName(), (Object)TestEvent.class.getName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        Assert.assertNotNull((Object)parent.getContent());
        Assert.assertTrue((boolean)(parent.getContent() instanceof TestEventBean2));
        TestEventBean2 c1 = (TestEventBean2)parent.getContent();
        bean = (TestEventBean2)parent.getContent();
        Assert.assertEquals((Object)"e3", (Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals((Object)TestEvent.class.getName(), (Object)parent.getClassName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        Assert.assertNotNull((Object)parent.getContent());
        Assert.assertTrue((boolean)(parent.getContent() instanceof TestEventBean2));
        TestEventBean2 c2 = (TestEventBean2)parent.getContent();
        bean = (TestEventBean2)parent.getContent();
        Assert.assertEquals((Object)"e4", (Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals(null, (Object)parent.getClassName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        bean = (TestEventBean2)this.beans.get(2);
        Assert.assertEquals((Object)"e2", (Object)bean.getId());
        long rid2 = bean.getRefId();
        parent = bean.getParent();
        Assert.assertEquals((Object)parent.getClassName(), (Object)TestEvent.class.getName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        Assert.assertNotNull((Object)parent.getContent());
        Assert.assertTrue((boolean)(parent.getContent() instanceof TestEventBean2));
        bean = (TestEventBean2)parent.getContent();
        Assert.assertEquals((Object)"e6", (Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals(null, (Object)parent.getClassName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        long rid6 = bean.getRefId();
        bean = (TestEventBean2)this.beans.get(3);
        Assert.assertNull((Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals(null, (Object)parent.getClassName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        Assert.assertNull((Object)parent.getContent());
        Assert.assertTrue((bean.getRefId() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((bean.getRefId() == -c1.getRefId() ? 1 : 0) != 0);
        bean = (TestEventBean2)this.beans.get(4);
        Assert.assertNull((Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals(null, (Object)parent.getClassName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        Assert.assertNull((Object)parent.getContent());
        Assert.assertTrue((bean.getRefId() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((bean.getRefId() == -c2.getRefId() ? 1 : 0) != 0);
        bean = (TestEventBean2)this.beans.get(5);
        Assert.assertEquals((Object)"e5", (Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals((Object)parent.getClassName(), (Object)TestEvent.class.getName());
        Assert.assertEquals((long)rid2, (long)parent.getReference());
        Assert.assertNull((Object)parent.getContent());
        bean = (TestEventBean2)this.beans.get(6);
        Assert.assertNull((Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals(null, (Object)parent.getClassName());
        Assert.assertEquals((long)0L, (long)parent.getReference());
        Assert.assertNull((Object)parent.getContent());
        Assert.assertTrue((bean.getRefId() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((bean.getRefId() == -rid6 ? 1 : 0) != 0);
        bean = (TestEventBean2)this.beans.get(7);
        Assert.assertEquals((Object)"e7", (Object)bean.getId());
        parent = bean.getParent();
        Assert.assertEquals((Object)parent.getClassName(), (Object)TestEvent.class.getName());
        Assert.assertEquals((long)rid6, (long)parent.getReference());
        Assert.assertNull((Object)parent.getContent());
    }

    @Test
    public void testStaxParser() throws XMLStreamException {
        XMLInputFactory fact = null;
        XMLStreamReader reader = null;
        this.logger.info("Factory class: {}", (Object)System.getProperty("javax.xml.stream.XMLInputFactory"));
        fact = XMLInputFactory.newInstance();
        reader = fact.createXMLStreamReader(this.getClass().getResourceAsStream("."));
        this.logger.info("Factory class: {}", (Object)ClassUtil.getQualifiedClassName((Object)fact));
        this.logger.info("Reader class: {}", (Object)ClassUtil.getQualifiedClassName((Object)reader));
    }

    @Test
    public void testStaxParser2() throws XMLStreamException {
        XMLInputFactory fact = null;
        XMLStreamReader reader = null;
        this.logger.info("Factory class: {}", (Object)System.getProperty("javax.xml.stream.XMLInputFactory"));
        fact = XMLInputFactory.newInstance();
        reader = fact.createXMLStreamReader(this.getClass().getResourceAsStream("."));
        this.logger.info("Factory class: {}", (Object)ClassUtil.getQualifiedClassName((Object)fact));
        this.logger.info("Reader class: {}", (Object)ClassUtil.getQualifiedClassName((Object)reader));
    }

    @Test
    public void testAnnotations() throws URISyntaxException, MalformedURLException {
        String pathBase = Util.getDirectoryName((String)new File(this.getClass().getResource("test2.txt").toURI()).getPath()) + "/";
        String src1Path = pathBase + "src1/";
        String src2Path = pathBase + "src2/";
        net.sf.okapi.connectors.pensieve.Parameters params = new net.sf.okapi.connectors.pensieve.Parameters();
        params.setDbDirectory(pathBase + "testtm");
        XLIFFKitWriterStep ws = new XLIFFKitWriterStep();
        AltTranslationsAnnotation ata = new AltTranslationsAnnotation();
        ws.getSession().setAnnotation((IAnnotation)ata);
        ata.add(LocaleId.ENGLISH, LocaleId.GERMAN, new TextFragment("original source"), new TextFragment("alternate source"), new TextFragment("alternate target"), MatchType.EXACT, 100, "tests", 100, 100);
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(src1Path, "test12.html").toURI().toURL(), "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep(), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 80), new XParameter("fillTarget", true)}), new XPipelineStep((IPipelineStep)ws, new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(pathBase, "testPackageFormat7.xliff.kit").toURI().toString())})}).execute();
    }

    private class WriteObserver
    implements IObserver {
        private WriteObserver() {
        }

        public void update(IObservable o, Object arg) {
            if (arg instanceof IPersistenceBean) {
                XLIFFKitWriterTest.this.beans.add((IPersistenceBean)arg);
            }
        }
    }
}

