/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.reader;

import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.beans.v0.TestEvent;
import net.sf.okapi.lib.beans.v0.TestEventBean;
import net.sf.okapi.lib.beans.v0.TestEventBean2;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XParameter;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.lib.extra.steps.EventLogger;
import net.sf.okapi.steps.xliffkit.reader.XLIFFKitReaderStep;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XLIFFKitReaderTest {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private static final LocaleId FRFR = new LocaleId("fr", "fr");
    private static final LocaleId DEDE = new LocaleId("de", "de");

    public void testReader() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testPackageFormat.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat").toURI(), "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XLIFFKitReaderStep(), new EventLogger()}).execute();
    }

    @Test
    public void testReader2() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testPackageFormat2.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat2").toURI(), "UTF-8", ENUS, DEDE)}), new IPipelineStep[]{new XLIFFKitReaderStep(), new EventLogger()}).execute();
    }

    @Ignore(value="OkapiMergeException: Added Codes in target='</w:t></w:r>,<w:r><w:rPr><w:b/><w:bCs/></w:rPr><w:t>'")
    public void testReader4() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testPackageFormat4.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat4").toURI(), "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XLIFFKitReaderStep(), new EventLogger()}).execute();
    }

    @Test
    public void testReader5() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testPackageFormat5.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat4").toURI(), "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XLIFFKitReaderStep(), new EventLogger()}).execute();
    }

    @Test
    public void testReader6() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testPackageFormat6.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat2").toURI(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new XLIFFKitReaderStep(), new EventLogger()}).execute();
    }

    @Test
    public void testReader7() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testPackageFormat7.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat2").toURI(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new XLIFFKitReaderStep(), new EventLogger()}).execute();
    }

    @Test
    public void testReader8() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("test07-subfilter.json_en.fr.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat8").toURI(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new XPipelineStep((IPipelineStep)new XLIFFKitReaderStep(), new XParameter[]{new XParameter("generateTargets", true), new XParameter("updateApprovedFlag", false)}), new EventLogger()}).execute();
    }

    @Test
    public void testReader9() throws URISyntaxException {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("Manual-12-AltTrans.xlf_en.fr.xliff.kit").toURI(), "UTF-8", new File(Util.getTempDirectory() + "/testPackageFormat9").toURI(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new XPipelineStep((IPipelineStep)new XLIFFKitReaderStep(), new XParameter[]{new XParameter("generateTargets", true), new XParameter("updateApprovedFlag", false)}), new EventLogger()}).execute();
    }

    public void testReferences() {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testReferences.xliff.kit"), "UTF-8", Util.getTempDirectory() + "/testReferences.xliff.kit", "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XPipelineStep((IPipelineStep)new XLIFFKitReaderStep(), new XParameter[]{new XParameter("generateTargets", false)}), new EventLogger()}).execute();
    }

    public void testReferences2() {
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(this.getClass().getResource("testReferences2.xliff.kit"), "UTF-8", Util.getTempDirectory() + "/testReferences2.xliff.kit", "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XPipelineStep((IPipelineStep)new XLIFFKitReaderStep(), new XParameter[]{new XParameter("generateTargets", false)}), new EventLogger()}).execute();
    }

    @Test
    public void testReferences3() {
        OkapiJsonSession session = new OkapiJsonSession(false);
        session.setItemClass(TestEvent.class);
        session.setItemLabel("event");
        InputStream inStream = this.getClass().getResourceAsStream("test_refs3.txt.json");
        session.start(inStream);
        session.registerBean(TestEvent.class, TestEventBean.class);
        TestEvent sd = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e1 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e2 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertTrue((boolean)"e1".equals(e1.getId()));
        Assert.assertTrue((boolean)"e2".equals(e2.getId()));
        Assert.assertTrue((boolean)"e2".equals(e1.getParent().getId()));
        Assert.assertTrue((boolean)"e1".equals(e2.getParent().getId()));
        TestEvent ed = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e4 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e4);
        TestEvent e5 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e5);
        TestEvent e6 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e6);
        session.end();
    }

    @Test
    public void testReferences4() {
        OkapiJsonSession session = new OkapiJsonSession(false);
        session.setItemClass(TestEvent.class);
        session.setItemLabel("event");
        InputStream inStream = this.getClass().getResourceAsStream("test_refs4.txt.json");
        session.start(inStream);
        session.registerBean(TestEvent.class, TestEventBean.class);
        TestEvent sd = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e1 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e2 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e3 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e4 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e5 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e6 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e7 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertTrue((boolean)"e1".equals(e1.getId()));
        Assert.assertTrue((boolean)"e2".equals(e2.getId()));
        Assert.assertTrue((boolean)"e3".equals(e3.getId()));
        Assert.assertTrue((boolean)"e4".equals(e4.getId()));
        Assert.assertTrue((boolean)"e5".equals(e5.getId()));
        Assert.assertTrue((boolean)"e6".equals(e6.getId()));
        Assert.assertTrue((boolean)"e7".equals(e7.getId()));
        Assert.assertTrue((boolean)"e3".equals(e1.getParent().getId()));
        Assert.assertTrue((boolean)"e4".equals(e3.getParent().getId()));
        Assert.assertTrue((boolean)"e6".equals(e2.getParent().getId()));
        Assert.assertTrue((boolean)"e6".equals(e7.getParent().getId()));
        Assert.assertTrue((boolean)"e2".equals(e5.getParent().getId()));
        TestEvent ed = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e8 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e8);
        TestEvent e9 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e9);
        TestEvent e10 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e10);
        session.end();
    }

    @Test
    public void testReferences5() {
        OkapiJsonSession session = new OkapiJsonSession(false);
        session.setItemClass(TestEvent.class);
        session.setItemLabel("event");
        InputStream inStream = this.getClass().getResourceAsStream("test_refs5.txt.json");
        session.start(inStream);
        session.registerBean(TestEvent.class, TestEventBean2.class);
        TestEvent sd = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e1 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e2 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertEquals((Object)"e1", (Object)e1.getId());
        Assert.assertEquals((Object)"e2", (Object)e2.getId());
        TestEvent p1 = e1.getParent();
        TestEvent p2 = e2.getParent();
        Assert.assertEquals((Object)e2, (Object)p1);
        Assert.assertEquals((Object)e1, (Object)p2);
        TestEvent ed = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e8 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e8);
        TestEvent e9 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e9);
        TestEvent e10 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e10);
        session.end();
    }

    @Test
    public void testReferences6() {
        OkapiJsonSession session = new OkapiJsonSession(false);
        session.setItemClass(TestEvent.class);
        session.setItemLabel("event");
        InputStream inStream = this.getClass().getResourceAsStream("test_refs6.txt.json");
        session.start(inStream);
        session.registerBean(TestEvent.class, TestEventBean2.class);
        TestEvent sd = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e1 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e2 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e3 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e4 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e5 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e6 = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e7 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertEquals((Object)"e1", (Object)e1.getId());
        Assert.assertEquals((Object)"e2", (Object)e2.getId());
        Assert.assertEquals((Object)"e3", (Object)e3.getId());
        Assert.assertEquals((Object)"e4", (Object)e4.getId());
        Assert.assertEquals((Object)"e5", (Object)e5.getId());
        Assert.assertEquals((Object)"e6", (Object)e6.getId());
        Assert.assertEquals((Object)"e7", (Object)e7.getId());
        TestEvent p1 = e1.getParent();
        TestEvent p2 = e2.getParent();
        TestEvent p3 = e3.getParent();
        TestEvent p4 = e4.getParent();
        TestEvent p5 = e5.getParent();
        TestEvent p6 = e6.getParent();
        TestEvent p7 = e7.getParent();
        Assert.assertEquals((Object)e3, (Object)p1);
        Assert.assertEquals((Object)e6, (Object)p2);
        Assert.assertEquals((Object)e4, (Object)p3);
        Assert.assertEquals(null, (Object)p4);
        Assert.assertEquals((Object)e2, (Object)p5);
        Assert.assertEquals(null, (Object)p6);
        Assert.assertEquals((Object)e6, (Object)p7);
        TestEvent ed = (TestEvent)session.deserialize(TestEvent.class);
        TestEvent e8 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e8);
        TestEvent e9 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e9);
        TestEvent e10 = (TestEvent)session.deserialize(TestEvent.class);
        Assert.assertNull((Object)e10);
        session.end();
    }
}

