/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit.codec;

import net.sf.okapi.steps.xliffkit.codec.PackageEscCodec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestPackageEscCodec {
    private PackageEscCodec codec = new PackageEscCodec();

    @Test
    public void testEncode() {
        String snippet = "text before \\b \t \b text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before \\b \ufff0\\t \ufff0\\b text after", (Object)res);
    }

    @Test
    public void testEncode2() {
        String snippet = "text before \\\\b \t \b text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before \\\\b \ufff0\\t \ufff0\\b text after", (Object)res);
    }

    @Test
    public void testEncode3() {
        String snippet = "text before \\\b \t \b text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before \\\ufff0\\b \ufff0\\t \ufff0\\b text after", (Object)res);
    }

    @Test
    public void testEncode4() {
        String snippet = "text before \\\\\b \t \b text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before \\\\\ufff0\\b \ufff0\\t \ufff0\\b text after", (Object)res);
    }

    @Test
    public void testEncode5() {
        String snippet = "text before ^A \t \u0001 text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before ^A \ufff0\\t \ufff0^A text after", (Object)res);
    }

    @Test
    public void testEncode6() {
        String snippet = "text before ^^A \t \u0001 text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before ^^A \ufff0\\t \ufff0^A text after", (Object)res);
    }

    @Test
    public void testEncode7() {
        String snippet = "text before \\\u0001 \t \u0001 text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before \\\ufff0^A \ufff0\\t \ufff0^A text after", (Object)res);
    }

    @Test
    public void testEncode8() {
        String snippet = "text before \\\\\u0001 \t \u0001 text after";
        String res = this.codec.encode(snippet);
        Assert.assertEquals((Object)"text before \\\\\ufff0^A \ufff0\\t \ufff0^A text after", (Object)res);
    }

    @Test
    public void testEncodeDecode() {
        String snippet = "text before \\b \t \b text after";
        Assert.assertEquals((Object)snippet, (Object)this.codec.decode(this.codec.encode(snippet)));
    }

    @Test
    public void testEncodeDecode2() {
        String snippet = "text before ^A \t \u0001 text after";
        Assert.assertEquals((Object)snippet, (Object)this.codec.decode(this.codec.encode(snippet)));
    }
}

