/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.lib.beans.v0.JSONPersistenceSession;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestVersions {
    @Test
    public void testDescription() {
        JSONPersistenceSession skelSession = new JSONPersistenceSession(Event.class);
        Assert.assertFalse((boolean)skelSession.isActive());
    }

    public void testOldPersistenceRoundtrip() throws IOException {
        Event event1 = new Event(EventType.TEXT_UNIT);
        ITextUnit tu1 = TextUnitUtil.buildTU((String)"source-text1\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        String zipName = this.getClass().getResource("sample1.en.fr.zip").getFile();
        tu1.setSkeleton((ISkeleton)new ZipSkeleton(new ZipFile(new File(zipName)), null));
        event1.setResource((IResource)tu1);
        tu1.setTarget(LocaleId.FRENCH, new TextContainer("french-text1"));
        tu1.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text1"));
        Event event2 = new Event(EventType.TEXT_UNIT);
        ITextUnit tu2 = TextUnitUtil.buildTU((String)"source-text2\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        tu2.setSkeleton((ISkeleton)new ZipSkeleton(null, new ZipEntry("aa1/content/content.gmx")));
        event2.setResource((IResource)tu2);
        tu2.setTarget(LocaleId.FRENCH, new TextContainer("french-text2"));
        tu2.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text2"));
        JSONPersistenceSession skelSession = new JSONPersistenceSession(Event.class);
        File tempSkeleton = null;
        tempSkeleton = File.createTempFile("~okapi-62_aaa_", ".txt");
        tempSkeleton.deleteOnExit();
        skelSession.start((OutputStream)new FileOutputStream(tempSkeleton));
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event1);
        events.add(event2);
        skelSession.serialize((Object)event1);
        skelSession.serialize((Object)event2);
        skelSession.end();
        FileInputStream fis = new FileInputStream(tempSkeleton);
        skelSession.start((InputStream)fis);
        Event event11 = (Event)skelSession.deserialize();
        Event event22 = (Event)skelSession.deserialize();
        skelSession.end();
        ArrayList<Event> events2 = new ArrayList<Event>();
        events2.add(event11);
        events2.add(event22);
        FilterTestDriver.compareEvents(events, events2);
        FilterTestDriver.laxCompareEvents(events, events2);
    }
}

