/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XParameter;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.lib.extra.steps.EventListBuilderStep;
import net.sf.okapi.lib.extra.steps.EventLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.xliffkit.reader.XLIFFKitReaderStep;
import net.sf.okapi.steps.xliffkit.writer.XLIFFKitWriterStep;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestRoundtrip {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private static final LocaleId FRFR = new LocaleId("fr", "fr");

    @Ignore(value="OpenXML skeleton is no longer serialiable")
    @Test
    public void testDoubleExtraction() throws MalformedURLException, URISyntaxException {
        String pathBase = new File(this.getClass().getResource("").toURI()).getPath() + "/";
        String src1Path = pathBase + "writer/src1/";
        String inPath = src1Path + "BoldWorld.docx";
        String midPath = pathBase + "testRoundtrip.xliff.kit";
        String outPath = pathBase + "out/";
        EventListBuilderStep elb1 = new EventListBuilderStep();
        EventListBuilderStep elb2 = new EventListBuilderStep();
        XPipeline pl = new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(inPath).toURI().toURL(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new OpenXMLFilter()), elb1, new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(midPath).toURI().toString())})});
        Assert.assertEquals((long)3L, (long)pl.getSteps().size());
        pl.execute();
        List list1 = elb1.getList();
        Assert.assertTrue((boolean)new File(midPath).exists());
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(midPath).toURI().toURL(), "UTF-8", Util.getDirectoryName((String)outPath), "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XLIFFKitReaderStep(), elb2, new TextUnitLogger(), new EventLogger()}).execute();
        List list2 = elb2.getList();
        if (!FilterTestDriver.compareEvents((List)list1, (List)list2, (boolean)true)) {
            throw new OkapiException("Events are different for " + inPath);
        }
    }

    @Test
    public void testDoubleExtraction2() throws MalformedURLException, URISyntaxException {
        String pathBase = new File(this.getClass().getResource("").toURI()).getPath() + "/";
        String src1Path = pathBase + "writer/src1/";
        String inPath = src1Path + "aa324.html";
        String midPath = pathBase + "testRoundtrip.xliff.kit";
        String outPath = pathBase + "out/";
        String outFilePath = outPath + "content/target/en-US.fr-FR/" + "aa324.html";
        EventListBuilderStep elb1 = new EventListBuilderStep();
        EventListBuilderStep elb2 = new EventListBuilderStep();
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(inPath).toURI().toURL(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), elb1, new XPipelineStep((IPipelineStep)new XLIFFKitWriterStep(), new XParameter[]{new XParameter("gMode", true), new XParameter("includeOriginal", true), new XParameter("message", "This document is a part of the test t-kit, generated from net.sf.okapi.steps.xliffkit.writer.testPackageFormat()"), new XParameter("outputURI", new File(midPath).toURI().toString())})}).execute();
        List list1 = elb1.getList();
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(midPath).toURI().toURL(), "UTF-8", Util.getDirectoryName((String)outPath), "UTF-8", ENUS, ENUS)}), new IPipelineStep[]{new XLIFFKitReaderStep(), elb2}).execute();
        List list2 = elb2.getList();
        if (!FilterTestDriver.compareEvents((List)list1, (List)list2, (boolean)true)) {
            throw new OkapiException("Events are different for " + inPath);
        }
        new XPipeline("Test pipeline for XLIFFKitWriterStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(inPath).toURI().toURL(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), elb1}).execute();
        list1 = elb1.getList();
        new XPipeline("Test pipeline for XLIFFKitReaderStep", new XBatch(new XBatchItem[]{new XBatchItem(new File(outFilePath).toURI().toURL(), "UTF-8", ENUS, FRFR)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), elb2, new TextUnitLogger()}).execute();
        list2 = elb2.getList();
        if (!FilterTestDriver.compareEvents((List)list1, (List)list2, (boolean)true)) {
            throw new OkapiException("Events are different for " + inPath);
        }
    }
}

