/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.beans.v1.PropertyBean;
import net.sf.okapi.lib.beans.v1.TextUnitBean;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestReflection {
    @Test
    public void dummyTest() {
    }

    private void log(String str) {
        Logger localLogger = LoggerFactory.getLogger(this.getClass());
        localLogger.debug(str);
    }

    private void log(int value) {
        this.log(String.valueOf(value));
    }

    private void log(long value) {
        this.log(String.valueOf(value));
    }

    public void testMethods() {
        Method[] methods = null;
        methods = TextUnitBean.class.getMethods();
        this.log(methods.length);
    }

    public void testFields() throws IllegalArgumentException, IllegalAccessException {
        TestClass testClass1 = new TestClass();
        TestClass2 testClass2 = new TestClass2();
        Field[] fields = null;
        fields = TestClass2.class.getDeclaredFields();
        this.log(fields.length);
        fields = TestClass2.class.getFields();
        this.log(fields.length);
        fields = TestClass.class.getDeclaredFields();
        this.log(fields.length);
        Field f1 = fields[3];
        this.log(f1.getName());
        PropertyBean b0 = (PropertyBean)f1.get(testClass1);
        this.log(b0.toString());
        testClass1.initBean1();
        b0 = (PropertyBean)f1.get(testClass1);
        this.log(b0.getRefId());
        PropertyBean bean = new PropertyBean();
        bean.setRefId(1011103L);
        f1.set(testClass1, bean);
        this.log(testClass1.bean1.getRefId());
        Field f2 = fields[5];
        this.log(f2.getName());
        this.log(f2.getType().toString());
        TypeVariable<Class<?>>[] params = f2.getType().getTypeParameters();
        this.log("params: " + params.length);
        Field f6 = fields[6];
        this.log(f6.getName());
        this.log(f6.getType().toString());
        TypeVariable<Class<?>>[] params6 = f6.getType().getTypeParameters();
        this.log("params: " + params6.length);
        this.log(params6[0].getName());
        this.log(params6[0].getClass().toString());
        this.log(params6[1].getName());
        List bb0 = (List)f2.get(testClass1);
        this.log(bb0.toString());
        testClass1.initBeans();
        bb0 = (List)f2.get(testClass1);
        this.log(bb0.toString());
    }

    public void testSpeed() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        long l;
        int i;
        TestClass testClass1 = new TestClass();
        Field[] fields = TestClass.class.getDeclaredFields();
        OkapiJsonSession session = new OkapiJsonSession(false);
        int loops = 0;
        long start = 0L;
        loops = 100000000;
        testClass1.initBean1();
        PropertyBean b0 = testClass1.bean1;
        start = System.currentTimeMillis();
        for (int i2 = 0; i2 < loops; ++i2) {
            long l2 = b0.getRefId();
        }
        this.log(loops + " regular: " + (System.currentTimeMillis() - start) + " milliseconds.");
        Field f1 = fields[3];
        b0 = (PropertyBean)f1.get(testClass1);
        start = System.currentTimeMillis();
        for (i = 0; i < loops; ++i) {
            l = b0.getRefId();
        }
        this.log(loops + " reflection: " + (System.currentTimeMillis() - start) + " milliseconds.");
        loops = 1000000;
        start = System.currentTimeMillis();
        for (i = 0; i < loops; ++i) {
            l = testClass1.bean1.getRefId();
        }
        this.log(loops + " regular: " + (System.currentTimeMillis() - start) + " milliseconds.");
        f1 = fields[3];
        start = System.currentTimeMillis();
        for (i = 0; i < loops; ++i) {
            b0 = (PropertyBean)f1.get(testClass1);
            l = b0.getRefId();
        }
        this.log(loops + " reflection: " + (System.currentTimeMillis() - start) + " milliseconds.");
        start = System.currentTimeMillis();
        for (i = 0; i < loops; ++i) {
            TextUnit textUnit = new TextUnit("tu1");
        }
        this.log("----" + loops + " TextUnit creation: " + (System.currentTimeMillis() - start) + " milliseconds.");
        start = System.currentTimeMillis();
        for (i = 0; i < loops; ++i) {
            Property property = new Property("name", "value");
        }
        this.log(loops + " Property creation: " + (System.currentTimeMillis() - start) + " milliseconds.");
        loops = 10000;
        start = System.currentTimeMillis();
        for (i = 0; i < loops; ++i) {
            session.registerBean(ITextUnit.class, TextUnitBean.class);
        }
        this.log(loops + " registerBean(): " + (System.currentTimeMillis() - start) + " milliseconds.");
    }

    public void testClasses() {
        HashMap map = new HashMap();
        ArrayList collection = new ArrayList();
        HashMap map1 = new HashMap();
        ArrayList list1 = new ArrayList();
        Assert.assertTrue((boolean)map1.getClass().isAssignableFrom(map.getClass()));
        Assert.assertTrue((boolean)map.getClass().isAssignableFrom(map1.getClass()));
        Assert.assertTrue((boolean)list1.getClass().isAssignableFrom(collection.getClass()));
        Assert.assertTrue((boolean)collection.getClass().isAssignableFrom(list1.getClass()));
        Assert.assertFalse((boolean)collection.getClass().isAssignableFrom(map1.getClass()));
        Field[] fields = BaseClasses.class.getDeclaredFields();
        Class<?> m1 = fields[0].getType();
        Class<?> c1 = fields[1].getType();
        Assert.assertTrue((boolean)m1.isAssignableFrom(map1.getClass()));
        Assert.assertFalse((boolean)map1.getClass().isAssignableFrom(m1));
        Assert.assertTrue((boolean)c1.isAssignableFrom(list1.getClass()));
        Assert.assertFalse((boolean)list1.getClass().isAssignableFrom(c1));
        Class<?> m2 = fields[2].getType();
        Class<?> m3 = fields[3].getType();
        Class<?> m4 = fields[4].getType();
    }

    private class BaseClasses {
        Map<Object, Object> map;
        Collection<Object> coll;
        Map<IPersistenceBean<?>, Object> map2;
        Map<Object, IPersistenceBean<?>> map3;
        Map<IPersistenceBean<?>, IPersistenceBean<?>> map4;

        private BaseClasses() {
        }
    }

    private class TestClass2
    extends TestClass {
        PropertyBean bean3;

        private TestClass2() {
        }

        public void initBean3() {
            this.bean3 = new PropertyBean();
            this.bean3.setRefId(33333L);
        }
    }

    private class TestClass {
        String data1;
        int data2;
        Character[] data3;
        PropertyBean bean1;
        PropertyBean bean2;
        List<PropertyBean> list;
        Map<Long, PropertyBean> map;

        private TestClass() {
        }

        public void initBean1() {
            this.bean1 = new PropertyBean();
            this.bean1.setRefId(111111L);
        }

        public void initBeans() {
            this.list = new ArrayList<PropertyBean>();
            PropertyBean b = new PropertyBean();
            b.setRefId(1L);
            this.list.add(b);
            b = new PropertyBean();
            b.setRefId(2L);
            this.list.add(b);
        }
    }
}

