/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit;

import java.io.UnsupportedEncodingException;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestJsonSession {
    private void log(String str) {
        Logger localLogger = LoggerFactory.getLogger(this.getClass());
        localLogger.debug(str);
    }

    @Test
    public void testReadWriteObject() throws UnsupportedEncodingException {
        OkapiJsonSession session = new OkapiJsonSession(false);
        session.setVersion("OKAPI 1.0");
        this.log("===== Annotation");
        InlineAnnotation annot1 = new InlineAnnotation();
        annot1.setData("test inline annotation");
        String st1 = session.writeObject((Object)annot1);
        this.log(st1 + "\n\n");
        this.log("===== TextUnit");
        ITextUnit tu1 = TextUnitUtil.buildTU((String)"source-text1\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        GenericSkeleton gs = new GenericSkeleton("before");
        gs.addContentPlaceholder(tu1);
        gs.append("after");
        this.log(gs.toString());
        tu1.setSkeleton((ISkeleton)gs);
        tu1.setTarget(LocaleId.FRENCH, new TextContainer("french-text1"));
        tu1.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text1"));
        String st2 = session.writeObject((Object)tu1);
        this.log(st2);
        session.setVersion("OKAPI 1.0");
        InlineAnnotation annot2 = (InlineAnnotation)session.readObject(st1, InlineAnnotation.class);
        Assert.assertEquals((Object)annot1.getData(), (Object)annot2.getData());
        ITextUnit tu2 = (ITextUnit)session.readObject(st2, TextUnit.class);
        Assert.assertEquals((Object)tu1.getSource().toString(), (Object)tu2.getSource().toString());
        session.setVersion("OKAPI 0.0");
        try {
            annot2 = (InlineAnnotation)session.readObject(st1, InlineAnnotation.class);
            Assert.assertEquals((Object)annot1.getData(), (Object)annot2.getData());
            tu2 = (ITextUnit)session.readObject(st2, TextUnit.class);
            Assert.assertEquals((Object)tu1.getSource().toString(), (Object)tu2.getSource().toString());
        }
        catch (RuntimeException e) {
            return;
        }
        Assert.fail((String)"RuntimeException should have been thrown");
    }
}

