/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffkit;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.lib.beans.sessions.OkapiJsonSession;
import net.sf.okapi.lib.beans.v1.EventBean;
import net.sf.okapi.lib.beans.v1.InputStreamBean;
import net.sf.okapi.lib.beans.v1.TextUnitBean;
import net.sf.okapi.lib.beans.v1.ZipSkeletonBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestJackson {
    private ObjectMapper mapper;
    private OkapiJsonSession session;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        this.mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.session = new OkapiJsonSession(false);
    }

    @Test
    public void testDescription() {
        this.session.setDescription("abc");
        Assert.assertEquals((Object)"abc", (Object)this.session.getDescription());
    }

    private void log(String str) {
        Logger localLogger = LoggerFactory.getLogger(this.getClass());
        localLogger.debug(str);
    }

    public void testTextUnit() throws JsonGenerationException, JsonMappingException, IOException, URISyntaxException {
        Event event = new Event(EventType.TEXT_UNIT);
        ITextUnit tu = TextUnitUtil.buildTU((String)"source-text\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        tu.setSkeleton((ISkeleton)new ZipSkeleton(null, new ZipEntry("")));
        event.setResource((IResource)tu);
        tu.setTarget(LocaleId.FRENCH, new TextContainer("french-text"));
        tu.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text"));
        TextUnitBean tub = new TextUnitBean();
        tub.set((Object)tu, (IPersistenceSession)this.session);
        EventBean evb = new EventBean();
        evb.set((Object)event, (IPersistenceSession)this.session);
        String st = this.mapper.writeValueAsString((Object)evb);
        this.log(st);
        st = this.mapper.writeValueAsString((Object)tub);
        tub = (TextUnitBean)this.mapper.readValue(st, TextUnitBean.class);
        tu = (ITextUnit)tub.get(ITextUnit.class, (IPersistenceSession)this.session);
    }

    public void testRawDocument() throws JsonGenerationException, JsonMappingException, IOException {
        Event event = new Event(EventType.RAW_DOCUMENT);
        event.setResource((IResource)new RawDocument((CharSequence)"raw doc", LocaleId.ENGLISH));
        EventBean evb = new EventBean();
        evb.set((Object)event, (IPersistenceSession)this.session);
        String st = this.mapper.writeValueAsString((Object)evb);
        this.log(st);
    }

    public void testMultipleRead1() throws IOException {
        OkapiJsonSession skelSession = new OkapiJsonSession(false);
        File tempSkeleton = null;
        tempSkeleton = File.createTempFile("~okapi-58_aaa_", ".txt");
        tempSkeleton.deleteOnExit();
        skelSession.start((OutputStream)new FileOutputStream(tempSkeleton));
        String st1 = "string1";
        String st2 = "string2";
        skelSession.serialize((Object)st1);
        skelSession.serialize((Object)st2);
        skelSession.end();
        FileInputStream fis = new FileInputStream(tempSkeleton);
        skelSession.start((InputStream)fis);
        skelSession.end();
    }

    public void testMultipleRead2() throws IOException {
        OkapiJsonSession skelSession = new OkapiJsonSession(false);
        File tempSkeleton = null;
        tempSkeleton = File.createTempFile("~okapi-59_aaa_", ".txt");
        tempSkeleton.deleteOnExit();
        skelSession.start((OutputStream)new FileOutputStream(tempSkeleton));
        Object st1 = new Object();
        Object st2 = new Object();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(st1);
        list.add(st2);
        skelSession.serialize(list);
        skelSession.end();
        skelSession.start((InputStream)new FileInputStream(tempSkeleton));
        skelSession.end();
    }

    public void testInputStream() {
        InputStream is = this.getClass().getResourceAsStream("test3.txt");
        this.log(is.markSupported() ? "true" : "false");
        String st = "";
        try {
            st = this.mapper.writeValueAsString((Object)is);
        }
        catch (JsonGenerationException e) {
            throw new OkapiException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new OkapiException((Throwable)e);
        }
        catch (IOException e) {
            throw new OkapiException((Throwable)e);
        }
        this.log(st);
    }

    public void testZipSkeleton() throws URISyntaxException, IOException {
        ZipFile zf = null;
        zf = new ZipFile(new File(this.getClass().getResource("sample1.en.fr.zip").toURI()));
        ZipSkeleton zs = new ZipSkeleton(zf, null);
        ZipSkeletonBean zsb = new ZipSkeletonBean();
        zsb.set((Object)zs, (IPersistenceSession)this.session);
        String st = this.mapper.writeValueAsString((Object)zsb);
        this.log(st);
        zf.close();
    }

    public void testInputStreamBean() throws URISyntaxException, JsonGenerationException, JsonMappingException, IOException {
        FileInputStream fis = new FileInputStream(new File(this.getClass().getResource("test3.txt").toURI()));
        InputStreamBean isb = new InputStreamBean();
        isb.set((Object)fis, (IPersistenceSession)this.session);
        String st = this.mapper.writeValueAsString((Object)isb);
        this.log(st);
    }

    public void testPersistenceRoundtrip() throws IOException {
        Event event1 = new Event(EventType.TEXT_UNIT);
        ITextUnit tu1 = TextUnitUtil.buildTU((String)"source-text1\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        String zipName = this.getClass().getResource("sample1.en.fr.zip").getFile();
        tu1.setSkeleton((ISkeleton)new ZipSkeleton(new ZipFile(new File(zipName)), null));
        event1.setResource((IResource)tu1);
        tu1.setTarget(LocaleId.FRENCH, new TextContainer("french-text1"));
        tu1.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text1"));
        Event event2 = new Event(EventType.TEXT_UNIT);
        ITextUnit tu2 = TextUnitUtil.buildTU((String)"source-text2\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        tu2.setSkeleton((ISkeleton)new ZipSkeleton(null, new ZipEntry("aa1/content/content.gmx")));
        event2.setResource((IResource)tu2);
        tu2.setTarget(LocaleId.FRENCH, new TextContainer("french-text2"));
        tu2.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text2"));
        tu1.getSource().append("part1");
        tu1.getSource().getSegments().append(new Segment("segId1", new TextFragment("seg1")));
        tu1.getSource().append("part2");
        tu1.getSource().getSegments().append(new Segment("segId2", new TextFragment("seg2")));
        OkapiJsonSession skelSession = new OkapiJsonSession(false);
        File tempSkeleton = null;
        tempSkeleton = File.createTempFile("~okapi-60_aaa_", ".txt");
        tempSkeleton.deleteOnExit();
        skelSession.start((OutputStream)new FileOutputStream(tempSkeleton));
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event1);
        events.add(event2);
        skelSession.serialize(events);
        skelSession.end();
    }

    public void testMultipleObject() throws IOException {
        Event event1 = new Event(EventType.TEXT_UNIT);
        ITextUnit tu1 = TextUnitUtil.buildTU((String)"source-text1\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        String zipName = this.getClass().getResource("sample1.en.fr.zip").getFile();
        tu1.setSkeleton((ISkeleton)new ZipSkeleton(new ZipFile(new File(zipName)), null));
        event1.setResource((IResource)tu1);
        tu1.setTarget(LocaleId.FRENCH, new TextContainer("french-text1"));
        tu1.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text1"));
        Event event2 = new Event(EventType.TEXT_UNIT);
        ITextUnit tu2 = TextUnitUtil.buildTU((String)"source-text2\u0002\" : \"{\"ssssss :\"ddddd}:<>sssddd: <>dsdd");
        tu2.setSkeleton((ISkeleton)new ZipSkeleton(null, new ZipEntry("aa1/content/content.gmx")));
        event2.setResource((IResource)tu2);
        tu2.setTarget(LocaleId.FRENCH, new TextContainer("french-text2"));
        tu2.setTarget(LocaleId.TAIWAN_CHINESE, new TextContainer("chinese-text2"));
        tu1.getSource().append("part1");
        tu1.getSource().getSegments().append(new Segment("segId1", new TextFragment("seg1")));
        tu1.getSource().append("part2");
        tu1.getSource().getSegments().append(new Segment("segId2", new TextFragment("seg2")));
        OkapiJsonSession skelSession = new OkapiJsonSession(false);
        File tempSkeleton = null;
        tempSkeleton = File.createTempFile("~okapi-61_aaa_", ".txt");
        tempSkeleton.deleteOnExit();
        skelSession.start((OutputStream)new FileOutputStream(tempSkeleton));
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event1);
        events.add(event2);
        skelSession.serialize((Object)event1);
        skelSession.serialize((Object)event2);
        skelSession.end();
        FileInputStream fis = new FileInputStream(tempSkeleton);
        skelSession.start((InputStream)fis);
        Event event11 = (Event)skelSession.deserialize(Event.class);
        Event event22 = (Event)skelSession.deserialize(Event.class);
        skelSession.end();
        ArrayList<Event> events2 = new ArrayList<Event>();
        events2.add(event11);
        events2.add(event22);
    }

    public void testDeserialization() {
        OkapiJsonSession skelSession = new OkapiJsonSession(false);
        skelSession.start(this.getClass().getResourceAsStream("test1.txt"));
        skelSession.end();
        skelSession.start(this.getClass().getResourceAsStream("test2.txt"));
        skelSession.end();
        skelSession.start(this.getClass().getResourceAsStream("test4.txt"));
        skelSession.end();
    }
}

