/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized.gmx;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXAlphanumericOnlyTextUnitCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXAlphanumericOnlyTextUnitWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXMeasurementOnlyTextUnitCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXMeasurementOnlyTextUnitWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXNumericOnlyTextUnitCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXNumericOnlyTextUnitWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXProtectedCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXProtectedWordCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCounter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestGMXCounts {
    private BaseCountStep bcs;
    private StartDocument sd;
    private Event sdEvent;
    private ITextUnit tu;
    private Event tuEvent;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private FileLocation root;

    @Before
    public void startup() {
        this.sd = new StartDocument("sd");
        this.sd.setLocale(LocaleId.ENGLISH);
        this.sdEvent = new Event(EventType.START_DOCUMENT, (IResource)this.sd);
        this.tu = new TextUnit("tu");
        this.tu.setSource(new TextContainer("12:00 is 15 minutes after 11:45. You can check at freetime@example.com 8-) for $300"));
        this.tuEvent = new Event(EventType.TEXT_UNIT, (IResource)this.tu);
        this.root = FileLocation.fromClass(this.getClass());
    }

    private void doSDEvent(LocaleId locale) {
        this.sd.setLocale(locale);
        this.bcs.handleEvent(this.sdEvent);
    }

    private void doTUEvent(String text) {
        this.tu.setSource(new TextContainer(text));
        this.bcs.handleEvent(this.tuEvent);
    }

    @Test
    public void testGMXAlphanumericOnlyTextUnitWordCountStep() {
        this.bcs = new GMXAlphanumericOnlyTextUnitWordCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"AlphanumericOnlyTextUnitWordCount"));
        this.doTUEvent("freetime@example.com 8-)");
        Assert.assertEquals((long)2L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"AlphanumericOnlyTextUnitWordCount"));
        this.doSDEvent(LocaleId.JAPANESE);
        this.doTUEvent("freetime@example.com 8-)");
        Assert.assertEquals((long)6L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"AlphanumericOnlyTextUnitWordCount"));
    }

    @Test
    public void testGMXAlphanumericOnlyTextUnitCharacterCountStep() {
        this.bcs = new GMXAlphanumericOnlyTextUnitCharacterCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"AlphanumericOnlyTextUnitCharacterCount"));
        this.doTUEvent("freetime@example.com 8-)");
        Assert.assertEquals((long)19L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"AlphanumericOnlyTextUnitCharacterCount"));
    }

    @Test
    public void testGMXMeasurementOnlyTextUnitWordCountStep() {
        this.bcs = new GMXMeasurementOnlyTextUnitWordCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"MeasurementOnlyTextUnitWordCount"));
        this.doTUEvent("11:45 12:00 12/1/1999 $300");
        Assert.assertEquals((long)4L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"MeasurementOnlyTextUnitWordCount"));
        this.doSDEvent(LocaleId.JAPANESE);
        this.doTUEvent("11:45 12:00 12/1/1999 $300");
        Assert.assertEquals((long)6L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"MeasurementOnlyTextUnitWordCount"));
    }

    @Test
    public void testGMXMeasurementOnlyTextUnitCharacterCountStep() {
        this.bcs = new GMXMeasurementOnlyTextUnitCharacterCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"MeasurementOnlyTextUnitCharacterCount"));
        this.doTUEvent("11:45 12:00 12/1/1999 $300");
        Assert.assertEquals((long)18L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"MeasurementOnlyTextUnitCharacterCount"));
    }

    @Test
    public void testGMXNumericOnlyTextUnitWordCountStep() {
        this.bcs = new GMXNumericOnlyTextUnitWordCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"NumericOnlyTextUnitWordCount"));
        this.doTUEvent("15 16 3.1415926536");
        Assert.assertEquals((long)3L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"NumericOnlyTextUnitWordCount"));
        this.doSDEvent(LocaleId.JAPANESE);
        this.doTUEvent("15 16 3.1415926536");
        Assert.assertEquals((long)5L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"NumericOnlyTextUnitWordCount"));
    }

    @Test
    public void testGMXNumericOnlyTextUnitCharacterCountStep() {
        this.bcs = new GMXNumericOnlyTextUnitCharacterCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"NumericOnlyTextUnitCharacterCount"));
        this.doTUEvent("15 16 3.1415926536");
        Assert.assertEquals((long)15L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"NumericOnlyTextUnitCharacterCount"));
    }

    @Test
    public void testGMXProtectedWordCountStep() {
        this.bcs = new GMXProtectedWordCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.tu.setIsTranslatable(false);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)11L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"ProtectedWordCount"));
        this.tu.setIsTranslatable(true);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"ProtectedWordCount"));
    }

    @Test
    public void testGMXProtectedCharacterCountStep() {
        this.bcs = new GMXProtectedCharacterCountStep();
        this.bcs.handleEvent(this.sdEvent);
        this.tu.setIsTranslatable(false);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)62L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"ProtectedCharacterCount"));
        this.tu.setIsTranslatable(true);
        this.bcs.handleEvent(this.tuEvent);
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"ProtectedCharacterCount"));
    }

    @Test
    public void testGMXRepetitionMatchedWordCountStep() {
    }
}

