/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import net.sf.okapi.common.Util;

public class Metrics
extends HashSet<String> {
    private static final long serialVersionUID = 4568824618144120407L;
    private final Hashtable<String, Long> metrics = new Hashtable();

    public void resetMetrics() {
        if (this.metrics == null) {
            return;
        }
        this.metrics.clear();
    }

    public boolean resetMetric(String name) {
        return this.setMetric(name, 0L);
    }

    public long getMetric(String name) {
        if (Util.isEmpty((String)name)) {
            return 0L;
        }
        if (this.metrics == null) {
            return 0L;
        }
        Long res = this.metrics.get(name);
        if (res == null) {
            res = 0L;
        }
        return res;
    }

    public boolean setMetric(String name, long value) {
        if (Util.isEmpty((String)name)) {
            return false;
        }
        if (this.metrics == null) {
            return false;
        }
        if (value == 0L) {
            return false;
        }
        this.metrics.put(name, value);
        return true;
    }

    public boolean registerMetric(String name) {
        if (Util.isEmpty((String)name)) {
            return false;
        }
        if (this.metrics == null) {
            return false;
        }
        if (this.metrics.containsKey(name)) {
            return false;
        }
        this.metrics.put(name, 0L);
        return true;
    }

    public boolean unregisterMetric(String name) {
        if (Util.isEmpty((String)name)) {
            return false;
        }
        if (this.metrics == null) {
            return false;
        }
        if (!this.metrics.containsKey(name)) {
            return false;
        }
        this.metrics.remove(name);
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this.metrics.keySet().iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.metrics.keySet()) {
            sb.append(String.format("%s=%d ", name, this.metrics.get(name)));
        }
        return sb.toString();
    }
}

