/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.steps.wordcount.CharacterCounter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestCharacterCount {
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locFR = LocaleId.FRENCH;
    private LocaleId locES005 = LocaleId.fromString((String)"es-005");

    @Test
    public void testStatics() {
        Assert.assertEquals((long)22L, (long)CharacterCounter.count((Object)"Test word count is correct.", (LocaleId)this.locEN));
        Assert.assertEquals((long)37L, (long)CharacterCounter.count((Object)"The quick (\"brown\") fox can't jump 32.3 feet, right?", (LocaleId)this.locEN));
        Assert.assertEquals((long)37L, (long)CharacterCounter.count((Object)"The quick (\u201cbrown\u201d) fox can\u2019t jump 32.3 feet, right?", (LocaleId)this.locEN));
        Assert.assertEquals((long)16L, (long)CharacterCounter.count((Object)"Words in a sentence", (LocaleId)this.locEN));
        Assert.assertEquals((long)16L, (long)CharacterCounter.count((Object)"Words in a sentence", (LocaleId)this.locES005));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)22L, (long)4L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Test word count is correct.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)37L, (long)8L, (long)7L), (Object)CharacterCounter.fullCount((Object)"The quick (\"brown\") fox can't jump 32.3 feet, right?", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)37L, (long)8L, (long)7L), (Object)CharacterCounter.fullCount((Object)"The quick (\u201cbrown\u201d) fox can\u2019t jump 32.3 feet, right?", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)16L, (long)3L, (long)0L), (Object)CharacterCounter.fullCount((Object)"Words in a sentence", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)16L, (long)3L, (long)0L), (Object)CharacterCounter.fullCount((Object)"Words in a sentence", (LocaleId)this.locES005));
    }

    @Test
    public void testCountApostrophe() {
        Assert.assertEquals((long)19L, (long)CharacterCounter.count((Object)"L'objectif est defini.", (LocaleId)this.locFR));
        Assert.assertEquals((long)19L, (long)CharacterCounter.count((Object)"L\u2019objectif est defini.", (LocaleId)this.locFR));
        Assert.assertEquals((long)48L, (long)CharacterCounter.count((Object)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d'une famille d'\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((long)48L, (long)CharacterCounter.count((Object)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d\u2019une famille d\u2019\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((long)18L, (long)CharacterCounter.count((Object)"He can't eat that fast.", (LocaleId)this.locEN));
        Assert.assertEquals((long)18L, (long)CharacterCounter.count((Object)"He can\u2019t eat that fast.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)19L, (long)2L, (long)1L), (Object)CharacterCounter.fullCount((Object)"L'objectif est defini.", (LocaleId)this.locFR));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)19L, (long)2L, (long)1L), (Object)CharacterCounter.fullCount((Object)"L\u2019objectif est defini.", (LocaleId)this.locFR));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)48L, (long)8L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d'une famille d'\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)48L, (long)8L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d\u2019une famille d\u2019\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)18L, (long)4L, (long)1L), (Object)CharacterCounter.fullCount((Object)"He can't eat that fast.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)18L, (long)4L, (long)1L), (Object)CharacterCounter.fullCount((Object)"He can\u2019t eat that fast.", (LocaleId)this.locEN));
    }

    @Test
    public void testCountDecomposed() {
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)48L, (long)8L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Elle a \u00e9t\u00e9 la premi\u00e8re Fran\u00e7aise d'une famille d'\u00e9migr\u00e9s.", (LocaleId)this.locFR));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)48L, (long)8L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Elle a e\u0301te\u0301 la premie\u0300re Franc\u0327aise d'une famille d'e\u0301migre\u0301s.", (LocaleId)this.locFR));
    }

    @Test
    public void testCountHyphen() {
        Assert.assertEquals((long)29L, (long)CharacterCounter.count((Object)"  Al Capone was an Italian-American.  ", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)29L, (long)8L, (long)1L), (Object)CharacterCounter.fullCount((Object)"  Al Capone was an Italian-American.  ", (LocaleId)this.locEN));
    }

    @Test
    public void testAstral() {
        Assert.assertEquals((long)21L, (long)CharacterCounter.count((Object)"Here is a present for you: \ud83c\udf81", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)21L, (long)6L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Here is a present for you: \ud83c\udf81", (LocaleId)this.locEN));
        Assert.assertEquals((long)21L, (long)CharacterCounter.count((Object)"\ud83c\udf81 <- Here is a present for you", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)21L, (long)7L, (long)2L), (Object)CharacterCounter.fullCount((Object)"\ud83c\udf81 <- Here is a present for you", (LocaleId)this.locEN));
    }

    @Test
    public void testCountGMXExamples() {
        Assert.assertEquals((long)33L, (long)CharacterCounter.count((Object)"This sentence has a word count of 9 words.", (LocaleId)this.locEN));
        Assert.assertEquals((long)42L, (long)CharacterCounter.count((Object)"This sentence/text unit has a word count of 11 words.", (LocaleId)this.locEN));
        Assert.assertEquals((long)90L, (long)CharacterCounter.count((Object)"In this example the in-line codes do not form\npart of the word or character counts but are counted separately.", (LocaleId)this.locEN));
        Assert.assertEquals((long)12L, (long)CharacterCounter.count((Object)"Start Text end.", (LocaleId)this.locEN));
        Assert.assertEquals((long)15L, (long)CharacterCounter.count((Object)"The black cat eats.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)33L, (long)8L, (long)1L), (Object)CharacterCounter.fullCount((Object)"This sentence has a word count of 9 words.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)42L, (long)9L, (long)2L), (Object)CharacterCounter.fullCount((Object)"This sentence/text unit has a word count of 11 words.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)90L, (long)19L, (long)1L), (Object)CharacterCounter.fullCount((Object)"In this example the in-line codes do not form\npart of the word or character counts but are counted separately.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)12L, (long)2L, (long)1L), (Object)CharacterCounter.fullCount((Object)"Start Text end.", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)15L, (long)3L, (long)1L), (Object)CharacterCounter.fullCount((Object)"The black cat eats.", (LocaleId)this.locEN));
    }

    @Test
    public void testCountTokens() {
        Assert.assertEquals((long)11L, (long)CharacterCounter.count((Object)"123 123.4 123,5", (LocaleId)this.locEN));
        Assert.assertEquals((long)0L, (long)CharacterCounter.count((Object)"( ) \" ' { } [ ] / % $ @ # ? ! * _ -", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)11L, (long)2L, (long)2L), (Object)CharacterCounter.fullCount((Object)"123 123.4 123,5", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)0L, (long)17L, (long)18L), (Object)CharacterCounter.fullCount((Object)"( ) \" ' { } [ ] / % $ @ # ? ! * _ -", (LocaleId)this.locEN));
    }

    @Test
    public void testCountEmpty() {
        Assert.assertEquals((long)0L, (long)CharacterCounter.count((Object)"", (LocaleId)this.locEN));
        Assert.assertEquals((long)0L, (long)CharacterCounter.count((Object)" \t\n\f\r ", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)0L, (long)0L, (long)0L), (Object)CharacterCounter.fullCount((Object)"", (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)0L, (long)6L, (long)0L), (Object)CharacterCounter.fullCount((Object)" \t\n\f\r ", (LocaleId)this.locEN));
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "b", "[b]");
        Assert.assertEquals((long)0L, (long)CharacterCounter.count((Object)tf, (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)0L, (long)0L, (long)0L), (Object)CharacterCounter.fullCount((Object)tf, (LocaleId)this.locEN));
    }

    @Test
    public void testCountFragments() {
        TextFragment tf = new TextFragment("abc");
        tf.append(TextFragment.TagType.PLACEHOLDER, "b", "[b]");
        tf.append("def");
        Assert.assertEquals((long)6L, (long)CharacterCounter.count((Object)tf, (LocaleId)this.locEN));
        Assert.assertEquals((Object)CharacterCounter.Counts.of((long)6L, (long)0L, (long)0L), (Object)CharacterCounter.fullCount((Object)tf, (LocaleId)this.locEN));
    }
}

