/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized.gmx;

import net.sf.okapi.steps.tokenization.Tokens;
import net.sf.okapi.steps.wordcount.categorized.CategoryGroup;
import net.sf.okapi.steps.wordcount.categorized.CategoryHandler;
import net.sf.okapi.steps.wordcount.common.TokenCharacterCountStep;

public class GMXMeasurementOnlyTextUnitCharacterCountStep
extends TokenCharacterCountStep
implements CategoryHandler {
    public static final String METRIC = "MeasurementOnlyTextUnitCharacterCount";

    @Override
    protected String[] getTokenNames() {
        return new String[]{"DATE", "TIME", "CURRENCY"};
    }

    @Override
    protected Tokens filterTokens(Tokens allTokens) {
        Tokens timeTokens = allTokens.getFilteredList(new String[]{"TIME"});
        Tokens singleTokens = allTokens.getFilteredList(new String[]{"DATE", "CURRENCY"});
        Tokens whiteSpace = allTokens.getFilteredList(new String[]{"WHITESPACE"});
        if (allTokens.size() - whiteSpace.size() - singleTokens.size() != timeTokens.size()) {
            return new Tokens();
        }
        return allTokens.getFilteredList(this.getTokenNames());
    }

    @Override
    public String getName() {
        return "GMX Measurement Only Character Count";
    }

    @Override
    public String getDescription() {
        return "An accumulation of the character count from measurement-only text units. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getMetric() {
        return METRIC;
    }

    @Override
    protected boolean countOnlyTranslatable() {
        return true;
    }

    @Override
    public CategoryGroup getCategoryGroup() {
        return CategoryGroup.GMX_CHARACTER_COUNTS;
    }
}

