/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.wordcount.categorized.CategoryHandler;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class CategoryResolver {
    private List<String> gmxWordCategories = new LinkedList<String>();
    private List<String> gmxCharacterCategories = new LinkedList<String>();
    private List<String> okapiWordCategories = new LinkedList<String>();
    private List<String> okapiCharacterCategories = new LinkedList<String>();
    private Map<String, Long> removedCategories = new HashMap<String, Long>();

    public CategoryResolver(List<IPipelineStep> steps) {
        for (IPipelineStep step : steps) {
            if (!(step instanceof CategoryHandler)) continue;
            CategoryHandler handler = (CategoryHandler)step;
            switch (handler.getCategoryGroup()) {
                case GMX_WORD_COUNTS: {
                    this.gmxWordCategories.add(handler.getMetric());
                    break;
                }
                case GMX_CHARACTER_COUNTS: {
                    this.gmxCharacterCategories.add(handler.getMetric());
                    break;
                }
                case OKAPI_WORD_COUNTS: {
                    this.okapiWordCategories.add(handler.getMetric());
                    break;
                }
                case OKAPI_CHARACTER_COUNTS: {
                    this.okapiCharacterCategories.add(handler.getMetric());
                }
            }
        }
    }

    public void reset() {
        this.removedCategories.clear();
    }

    public void resolve(MetricsAnnotation ma, boolean contributesInTotal) {
        if (ma == null) {
            return;
        }
        Metrics metrics = ma.getMetrics();
        LinkedList<String> m = new LinkedList<String>(metrics);
        for (String metric : m) {
            int i;
            int index = this.gmxWordCategories.indexOf(metric);
            if (index > -1) {
                for (i = index + 1; i < this.gmxWordCategories.size(); ++i) {
                    this.removeCategory(metrics, this.gmxWordCategories.get(i), contributesInTotal);
                }
                continue;
            }
            index = this.gmxCharacterCategories.indexOf(metric);
            if (index > -1) {
                for (i = index + 1; i < this.gmxCharacterCategories.size(); ++i) {
                    this.removeCategory(metrics, this.gmxCharacterCategories.get(i), contributesInTotal);
                }
                continue;
            }
            index = this.okapiWordCategories.indexOf(metric);
            if (index > -1) {
                for (i = index + 1; i < this.okapiWordCategories.size(); ++i) {
                    this.removeCategory(metrics, this.okapiWordCategories.get(i), contributesInTotal);
                }
            }
            if ((index = this.okapiCharacterCategories.indexOf(metric)) <= -1) continue;
            for (i = index + 1; i < this.okapiCharacterCategories.size(); ++i) {
                this.removeCategory(metrics, this.okapiCharacterCategories.get(i), contributesInTotal);
            }
        }
    }

    private void removeCategory(Metrics metrics, String name, boolean contributesInTotal) {
        long value = 0L;
        if (contributesInTotal) {
            value = (Long)Util.getValue(this.removedCategories, (Object)name, (Object)0L);
            if ((value += metrics.getMetric(name)) == 0L) {
                this.removedCategories.remove(name);
            } else {
                this.removedCategories.put(name, value);
            }
        }
        metrics.unregisterMetric(name);
    }

    private void resolveTU(ITextUnit tu) {
        MetricsAnnotation ma = (MetricsAnnotation)tu.getAnnotation(MetricsAnnotation.class);
        this.resolve(ma, true);
        TextContainer tc = tu.getSource();
        ma = (MetricsAnnotation)tc.getAnnotation(MetricsAnnotation.class);
        this.resolve(ma, false);
        for (Segment seg : tc.getSegments()) {
            ma = (MetricsAnnotation)seg.getAnnotation(MetricsAnnotation.class);
            this.resolve(ma, false);
        }
        for (LocaleId trgLoc : tu.getTargetLocales()) {
            tc = tu.getTarget(trgLoc);
            ma = (MetricsAnnotation)tc.getAnnotation(MetricsAnnotation.class);
            this.resolve(ma, false);
            for (Segment seg : tc.getSegments()) {
                ma = (MetricsAnnotation)seg.getAnnotation(MetricsAnnotation.class);
                this.resolve(ma, false);
            }
        }
    }

    public void resolve(IResource res, EventType eventType) {
        switch (eventType) {
            case TEXT_UNIT: {
                this.resolveTU((ITextUnit)res);
                break;
            }
            case END_BATCH_ITEM: {
                this.resolveEnding((Ending)res, false);
                break;
            }
            case END_BATCH: {
                this.resolveEnding((Ending)res, true);
                break;
            }
        }
    }

    private void resolveEnding(Ending res, boolean isEndBatch) {
        MetricsAnnotation ma = (MetricsAnnotation)res.getAnnotation(MetricsAnnotation.class);
        if (ma != null) {
            Metrics metrics = ma.getMetrics();
            if (isEndBatch) {
                this.resolve(ma, false);
                return;
            }
            LinkedList<String> m = new LinkedList<String>(metrics);
            for (String metric : m) {
                long value = metrics.getMetric(metric);
                if ((value -= ((Long)Util.getValue(this.removedCategories, (Object)metric, (Object)0L)).longValue()) <= 0L) {
                    metrics.unregisterMetric(metric);
                    continue;
                }
                metrics.setMetric(metric, value);
            }
        }
    }
}

