/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public abstract class BaseCounter {
    protected abstract long doCountImpl(String var1, LocaleId var2);

    public long doCount(Object text, LocaleId language) {
        if (text == null) {
            return 0L;
        }
        if (Util.isNullOrEmpty((LocaleId)language)) {
            return 0L;
        }
        if (text instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)text;
            return this.doCount(tu.getSource(), language);
        }
        if (text instanceof Segment) {
            Segment seg = (Segment)text;
            return this.doCount(seg.getContent(), language);
        }
        if (text instanceof TextContainer) {
            TextContainer tc = (TextContainer)text;
            long res = 0L;
            for (Segment seg : tc.getSegments()) {
                res += this.doCount(seg, language);
            }
            return res;
        }
        if (text instanceof TextFragment) {
            TextFragment tf = (TextFragment)text;
            return this.doCount(TextUnitUtil.getText((TextFragment)tf), language);
        }
        if (text instanceof String) {
            return this.doCountImpl((String)text, language);
        }
        return 0L;
    }

    private static long getValue(MetricsAnnotation ma, String metricName) {
        if (ma == null) {
            return 0L;
        }
        Metrics m = ma.getMetrics();
        if (m == null) {
            return 0L;
        }
        return m.getMetric(metricName);
    }

    protected abstract String getMetricNameForRetrieval();

    public static long getCount(Segment segment, String metricName) {
        return BaseCounter.getValue((MetricsAnnotation)segment.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public long doGetCount(Segment segment) {
        return BaseCounter.getCount(segment, this.getMetricNameForRetrieval());
    }

    public static long getCount(TextContainer tc, String metricName) {
        return BaseCounter.getValue((MetricsAnnotation)tc.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public long doGetCount(TextContainer tc) {
        return BaseCounter.getCount(tc, this.getMetricNameForRetrieval());
    }

    public static long getCount(IWithAnnotations res, String metricName) {
        return BaseCounter.getValue((MetricsAnnotation)res.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public long doGetCount(IWithAnnotations res) {
        return BaseCounter.getCount(res, this.getMetricNameForRetrieval());
    }
}

