/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.steps.tokenization.Tokenizer;
import net.sf.okapi.steps.tokenization.Tokens;
import net.sf.okapi.steps.wordcount.CharacterCounter;
import net.sf.okapi.steps.wordcount.common.BaseCounter;
import net.sf.okapi.steps.wordcount.common.GMX;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class WordCounter
extends BaseCounter {
    private static final WordCounter counter = new WordCounter();

    @Override
    protected long doCountImpl(String text, LocaleId language) {
        if (GMX.isLogographicScript(language)) {
            return WordCounter.countLogographicScript(text, language);
        }
        Tokens tokens = Tokenizer.tokenize((String)text, (LocaleId)language, (String[])new String[]{"WORD", "HYPHENATED_WORD", "NUMBER", "TIME"});
        if (tokens == null) {
            return 0L;
        }
        return tokens.size();
    }

    public static long countLogographicScript(Object text, LocaleId language) {
        long characterCount = CharacterCounter.count(text, language);
        return WordCounter.countFromLogographicCharacterCount(characterCount, language);
    }

    public static long countFromLogographicCharacterCount(long characterCount, LocaleId language) {
        if (!GMX.isLogographicScript(language)) {
            throw new IllegalArgumentException(language.toString() + " is not a logographic script");
        }
        double charCountFactor = GMX.getCharacterCountFactor(language);
        if (charCountFactor == -1.0) {
            return 0L;
        }
        return Math.round((double)characterCount / charCountFactor);
    }

    public static long count(ITextUnit textUnit, LocaleId language) {
        return counter.doCount(textUnit, language);
    }

    public static long count(TextContainer textContainer, LocaleId language) {
        return counter.doCount(textContainer, language);
    }

    public static long count(Segment segment, LocaleId language) {
        return counter.doCount(segment, language);
    }

    public static long count(TextFragment textFragment, LocaleId language) {
        return counter.doCount(textFragment, language);
    }

    public static long count(String string, LocaleId language) {
        return counter.doCount(string, language);
    }

    @Override
    protected String getMetricNameForRetrieval() {
        return "TotalWordCount";
    }

    public static long getCount(IWithAnnotations res) {
        return counter.doGetCount(res);
    }

    public static long getCount(ITextUnit tu) {
        return counter.doGetCount((IWithAnnotations)tu);
    }

    public static long getCount(TextContainer tc) {
        return counter.doGetCount(tc);
    }

    public static long getCount(ITextUnit tu, int segIndex) {
        ISegments segments = tu.getSource().getSegments();
        return WordCounter.getCount(segments.get(segIndex));
    }

    public static long getCount(Segment segment) {
        return counter.doGetCount(segment);
    }

    public static void setCount(IWithAnnotations res, long count) {
        MetricsAnnotation ma = (MetricsAnnotation)res.getAnnotation(MetricsAnnotation.class);
        if (ma == null) {
            ma = new MetricsAnnotation();
            res.setAnnotation((IAnnotation)ma);
        }
        Metrics m = ma.getMetrics();
        m.setMetric("TotalWordCount", count);
    }
}

