/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized.okapi;

import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.logger.TextUnitLogger;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactDocumentContextMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactDocumentContextMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactLocalContextMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactLocalContextMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactPreviousVersionMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactPreviousVersionMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactRepairedCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactRepairedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactStructuralMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactStructuralMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyPreviousVersionMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyPreviousVersionMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyUniqueIdMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyUniqueIdMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactUniqueIdMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactUniqueIdMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyPreviousVersionMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyPreviousVersionMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyRepairedCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyRepairedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyUniqueIdMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyUniqueIdMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.MTCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.MTWordCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCounter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestOkapiCounts {
    private BaseCountStep bcs;
    private StartDocument sd;
    private Event sdEvent;
    private ITextUnit tu;
    private Event tuEvent;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Before
    public void startup() {
        this.sd = new StartDocument("sd");
        this.sd.setLocale(LocaleId.ENGLISH);
        this.sdEvent = new Event(EventType.START_DOCUMENT, (IResource)this.sd);
        this.tu = new TextUnit("tu");
        this.tu.setSource(new TextContainer("Elephants cannot fly."));
        this.tuEvent = new Event(EventType.TEXT_UNIT, (IResource)this.tu);
        this.tu.setTarget(LocaleId.FRENCH, new TextContainer("Les \u00e9l\u00e9phants ne peuvent pas voler."));
        TextContainer target = this.tu.getTarget(LocaleId.FRENCH);
        target.setAnnotation((IAnnotation)new AltTranslationsAnnotation());
    }

    @Test
    public void testConcordanceWordCountStep() {
    }

    @Test
    public void testExactDocumentContextMatchWordCountStep() throws Exception {
        this.testCount(ExactDocumentContextMatchWordCountStep.class, MatchType.EXACT_DOCUMENT_CONTEXT, false);
    }

    @Test
    public void testExactDocumentContextMatchCharacterCountStep() throws Exception {
        this.testCount(ExactDocumentContextMatchCharacterCountStep.class, MatchType.EXACT_DOCUMENT_CONTEXT, true);
    }

    private void testCount(Class<? extends BaseCountStep> cls, MatchType matchType, boolean isCharacters) throws InstantiationException, IllegalAccessException {
        AltTranslationsAnnotation ata = (AltTranslationsAnnotation)this.tu.getTarget(LocaleId.FRENCH).getAnnotation(AltTranslationsAnnotation.class);
        ata.add(new AltTranslation(LocaleId.ENGLISH, LocaleId.FRENCH, this.tu.getSource().getFirstContent(), null, null, matchType, 100, null));
        this.bcs = (BaseCountStep)ClassUtil.instantiateClass(cls);
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        String metric = matchType.name() + (isCharacters ? "_CHARACTERS" : "");
        long count = isCharacters ? 18L : 3L;
        Assert.assertEquals((long)count, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)metric));
    }

    @Test
    public void testExactLocalContextMatchWordCountStep() throws Exception {
        this.testCount(ExactLocalContextMatchWordCountStep.class, MatchType.EXACT_LOCAL_CONTEXT, false);
    }

    @Test
    public void testExactLocalContextMatchCharacterCountStep() throws Exception {
        this.testCount(ExactLocalContextMatchCharacterCountStep.class, MatchType.EXACT_LOCAL_CONTEXT, true);
    }

    @Test
    public void testExactMatchWordCountStep() throws Exception {
        this.testCount(ExactMatchWordCountStep.class, MatchType.EXACT, false);
    }

    @Test
    public void testExactMatchCharacterCountStep() throws Exception {
        this.testCount(ExactMatchCharacterCountStep.class, MatchType.EXACT, true);
    }

    @Test
    public void testExactPreviousVersionMatchWordCountStep() throws Exception {
        this.testCount(ExactPreviousVersionMatchWordCountStep.class, MatchType.EXACT_PREVIOUS_VERSION, false);
    }

    @Test
    public void testExactPreviousVersionMatchCharacterCountStep() throws Exception {
        this.testCount(ExactPreviousVersionMatchCharacterCountStep.class, MatchType.EXACT_PREVIOUS_VERSION, true);
    }

    @Test
    public void testExactRepairedWordCountStep() throws Exception {
        this.testCount(ExactRepairedWordCountStep.class, MatchType.EXACT_REPAIRED, false);
    }

    @Test
    public void testExactRepairedCharacterCountStep() throws Exception {
        this.testCount(ExactRepairedCharacterCountStep.class, MatchType.EXACT_REPAIRED, true);
    }

    @Test
    public void testExactStructuralMatchWordCountStep() throws Exception {
        this.testCount(ExactStructuralMatchWordCountStep.class, MatchType.EXACT_STRUCTURAL, false);
    }

    @Test
    public void testExactStructuralMatchCharacterCountStep() throws Exception {
        this.testCount(ExactStructuralMatchCharacterCountStep.class, MatchType.EXACT_STRUCTURAL, true);
    }

    @Test
    public void testExactTextOnlyPreviousVersionMatchWordCountStep() throws Exception {
        this.testCount(ExactTextOnlyPreviousVersionMatchWordCountStep.class, MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION, false);
    }

    @Test
    public void testExactTextOnlyPreviousVersionMatchCharacterCountStep() throws Exception {
        this.testCount(ExactTextOnlyPreviousVersionMatchCharacterCountStep.class, MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION, true);
    }

    @Test
    public void testExactTextOnlyUniqueIdMatchWordCountStep() throws Exception {
        this.testCount(ExactTextOnlyUniqueIdMatchWordCountStep.class, MatchType.EXACT_TEXT_ONLY_UNIQUE_ID, false);
    }

    @Test
    public void testExactTextOnlyUniqueIdMatchCharacterCountStep() throws Exception {
        this.testCount(ExactTextOnlyUniqueIdMatchCharacterCountStep.class, MatchType.EXACT_TEXT_ONLY_UNIQUE_ID, true);
    }

    @Test
    public void testExactTextOnlyWordCountStep() throws Exception {
        this.testCount(ExactTextOnlyWordCountStep.class, MatchType.EXACT_TEXT_ONLY, false);
    }

    @Test
    public void testExactTextOnlyCharacterCountStep() throws Exception {
        this.testCount(ExactTextOnlyCharacterCountStep.class, MatchType.EXACT_TEXT_ONLY, true);
    }

    @Test
    public void testExactUniqueIdMatchWordCountStep() throws Exception {
        this.testCount(ExactUniqueIdMatchWordCountStep.class, MatchType.EXACT_UNIQUE_ID, false);
    }

    @Test
    public void testExactUniqueIdMatchCharacterCountStep() throws Exception {
        this.testCount(ExactUniqueIdMatchCharacterCountStep.class, MatchType.EXACT_UNIQUE_ID, true);
    }

    @Test
    public void testFuzzyMatchWordCountStep() throws Exception {
        this.testCount(FuzzyMatchWordCountStep.class, MatchType.FUZZY, false);
    }

    @Test
    public void testFuzzyMatchCharacterCountStep() throws Exception {
        this.testCount(FuzzyMatchCharacterCountStep.class, MatchType.FUZZY, true);
    }

    @Test
    public void testFuzzyPreviousVersionMatchWordCountStep() throws Exception {
        this.testCount(FuzzyPreviousVersionMatchWordCountStep.class, MatchType.FUZZY_PREVIOUS_VERSION, false);
    }

    @Test
    public void testFuzzyPreviousVersionMatchCharacterCountStep() throws Exception {
        this.testCount(FuzzyPreviousVersionMatchCharacterCountStep.class, MatchType.FUZZY_PREVIOUS_VERSION, true);
    }

    @Test
    public void testFuzzyRepairedWordCountStep() throws Exception {
        this.testCount(FuzzyRepairedWordCountStep.class, MatchType.FUZZY_REPAIRED, false);
    }

    @Test
    public void testFuzzyRepairedCharacterCountStep() throws Exception {
        this.testCount(FuzzyRepairedCharacterCountStep.class, MatchType.FUZZY_REPAIRED, true);
    }

    @Test
    public void testFuzzyUniqueIdMatchWordCountStep() throws Exception {
        this.testCount(FuzzyUniqueIdMatchWordCountStep.class, MatchType.FUZZY_UNIQUE_ID, false);
    }

    @Test
    public void testFuzzyUniqueIdMatchCharacterCountStep() throws Exception {
        this.testCount(FuzzyUniqueIdMatchCharacterCountStep.class, MatchType.FUZZY_UNIQUE_ID, true);
    }

    @Test
    public void testMTWordCountStep() throws Exception {
        this.testCount(MTWordCountStep.class, MatchType.MT, false);
    }

    @Test
    public void testMTCharacterCountStep() throws Exception {
        this.testCount(MTCharacterCountStep.class, MatchType.MT, true);
    }

    @Test
    public void testPhraseAssembledWordCountStep() {
    }
}

